/*
 * Decompiled with CFR 0.152.
 */
package pages.environmentsubsystem;

import core.ImageElement;
import core.ScreenElement;
import game.variables.EnvironmentSystemVariables;
import java.util.ArrayList;
import processing.core.PApplet;

public class VacuumTank
extends ScreenElement {
    ImageElement _vacTank;
    ImageElement _frost;
    ArrayList<ImageElement> _pumps;
    ArrayList<ImageElement> _tankIce;
    private final int _pumpSpc = 20;

    public VacuumTank(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this._vacTank = new ImageElement("vactank.png", this, pApplet);
        this._frost = new ImageElement("vactankfrost.png", this, pApplet);
        this._frost.setOpacity(0.0f);
        this._pumps = new ArrayList(EnvironmentSystemVariables.MaxVacuumPumps);
        this._tankIce = new ArrayList();
        for (int i = 0; i < EnvironmentSystemVariables.MaxVacuumPumps; ++i) {
            ImageElement imageElement = new ImageElement("vacpump.png", this, pApplet);
            this._pumps.add(imageElement);
            this.addChild(imageElement);
        }
        this._tankIce.add(new ImageElement("icicle1.png", this, pApplet));
        this._tankIce.add(new ImageElement("icicle2.png", this, pApplet));
        this._tankIce.add(new ImageElement("icicle3.png", this, pApplet));
        this._tankIce.add(new ImageElement("icicle1.png", this, pApplet));
        this._tankIce.add(new ImageElement("icicle3.png", this, pApplet));
        for (ImageElement imageElement : this._tankIce) {
            imageElement.setOrigin(0.5f, 0.0f);
            this.addChild(imageElement);
        }
        this.addChild(this._vacTank);
        this.addChild(this._frost);
    }

    @Override
    public void setup() {
        this.setBounds(this._vacTank.getWidth(), this._vacTank.getHeight());
        this._tankIce.get(0).setRelativePosition(0.105714284f, 0.64375f);
        this._tankIce.get(1).setRelativePosition(0.29f, 0.96875f);
        this._tankIce.get(2).setRelativePosition(0.86142856f, 0.6f);
        this._tankIce.get(3).setRelativePosition(0.5314286f, 0.6f);
        this._tankIce.get(4).setRelativePosition(0.5714286f, 0.6f);
        for (ImageElement imageElement : this._tankIce) {
            imageElement.setScale(1.0f, 1.0f - EnvironmentSystemVariables.getTargetTemperature() / 273.15f);
        }
        for (int i = 0; i < this._pumps.size(); ++i) {
            ImageElement imageElement;
            imageElement = this._pumps.get(i);
            imageElement.setOrigin(0.5f, 1.0f);
            if (i % 2 == 1) {
                imageElement.setRelativePosition((300.0f + (float)(i * 20)) / 700.0f, 0.375f);
                continue;
            }
            imageElement.setRotation(Float.valueOf((float)Math.PI));
            imageElement.setRelativePosition((300.0f + (float)((i + 1) * 20)) / 700.0f, 0.59375f);
        }
    }

    @Override
    public void update(float f) {
        int n = EnvironmentSystemVariables.NumberVacuumPumps - 1;
        if (n > EnvironmentSystemVariables.MaxVacuumPumps - 1) {
            n = EnvironmentSystemVariables.MaxVacuumPumps;
        }
        for (int i = 0; i < EnvironmentSystemVariables.MaxVacuumPumps; ++i) {
            ImageElement imageElement = this._pumps.get(i);
            if (i <= n) {
                imageElement.setVisible(true);
                continue;
            }
            imageElement.setVisible(false);
        }
        float f2 = EnvironmentSystemVariables.getTargetTemperature();
        if ((double)f2 < 273.15) {
            this._frost.setOpacity(1.0f - f2 / 273.15f);
            for (ImageElement imageElement : this._tankIce) {
                imageElement.setScale(1.0f, 1.0f - f2 / 273.15f);
            }
        } else {
            this._frost.setOpacity(0.0f);
        }
    }
}

