/*
 * Decompiled with CFR 0.152.
 */
package pages.environmentsubsystem;

import core.GamePage;
import core.ImageElement;
import core.ResourceManager;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.FrameElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.variables.EnvironmentSystemVariables;
import pages.environmentsubsystem.DetectorCooling;
import pages.environmentsubsystem.DetectorDepth;
import pages.environmentsubsystem.DetectorVacuum;
import parrot.Parrot;
import processing.core.PApplet;
import processing.core.PVector;

public class EnvironmentSystemBase
extends GamePage {
    private ImageElement _leftPaneBack;
    private FrameElement _icons;
    private DetectorDepth _detectorDepth;
    private DetectorVacuum _detectorVacuum;
    private DetectorCooling _detectorCooling;
    private Parrot _parrot;
    private ButtonElement _btnDepth;
    private ButtonElement _btnVacuum;
    private ButtonElement _btnCooling;
    private AudioPlayer background;
    private AudioPlayer vacuum;

    public EnvironmentSystemBase(PApplet pApplet) {
        super(pApplet);
        this._icons = new FrameElement(this, pApplet);
        this._icons.setRelativeBounds(0.22f, 1.0f);
        this._icons.setBackOpacity(0.0f);
        this._detectorDepth = new DetectorDepth(this, pApplet);
        this._detectorDepth.setRelativePosition(0.225f, 0.0f);
        this._detectorVacuum = new DetectorVacuum(this, pApplet);
        this._detectorVacuum.setRelativePosition(0.225f, 0.0f);
        this._detectorVacuum.setVisible(false);
        this._detectorCooling = new DetectorCooling(this, pApplet);
        this._detectorCooling.setRelativePosition(0.225f, 0.0f);
        this._detectorCooling.setVisible(false);
        this._leftPaneBack = new ImageElement("EnterScreenBack.jpg", this, pApplet);
        this._btnDepth = new ButtonElement(this, pApplet, "mole_icon.png", "audio/28826__junggle__btn016.mp3");
        this._btnVacuum = new ButtonElement(this, pApplet, "hoover_icon.png", "audio/28826__junggle__btn016.mp3");
        this._btnCooling = new ButtonElement(this, pApplet, "snowflake_icon.png", "audio/28826__junggle__btn016.mp3");
        this._btnDepth.setCallback(new IconClicked());
        this._btnVacuum.setCallback(new IconClicked());
        this._btnCooling.setCallback(new IconClicked());
        this._parrot = new Parrot(this, pApplet);
        this.addChild(this._leftPaneBack);
        this.addChild(this._detectorDepth);
        this.addChild(this._detectorVacuum);
        this.addChild(this._detectorCooling);
        this.addChild(this._icons);
        this.addChild(this._btnDepth);
        this.addChild(this._btnVacuum);
        this.addChild(this._btnCooling);
        this.addChild(this._parrot);
    }

    @Override
    public void setup() {
        this.setOpacity(0.0f);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.3f, Float.valueOf(0.0f), TargetProperty.opacity));
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation(false, this);
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.3f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        KeyFrameAnimation keyFrameAnimation3 = new KeyFrameAnimation(false);
        keyFrameAnimation3.AddKeyFrame(new PVectorKeyFrame(0.0f, new PVector(1.0f, 1.0f), TargetProperty.scale, EasingFunctions.EaseInOut));
        keyFrameAnimation3.AddKeyFrame(new PVectorKeyFrame(0.3f, new PVector(1.3f, 1.3f), TargetProperty.scale, EasingFunctions.EaseInOut));
        keyFrameAnimation3.AddKeyFrame(new PVectorKeyFrame(0.6f, new PVector(1.0f, 1.0f), TargetProperty.scale));
        this._btnDepth.setOrigin(0.5f, 0.5f);
        this._btnDepth.setRelativePosition(0.1f, 0.15f);
        keyFrameAnimation3.AddTargetObject(this._btnDepth);
        this._btnDepth.setHoverAnimation(keyFrameAnimation3);
        this._btnVacuum.setOrigin(0.5f, 0.5f);
        this._btnVacuum.setRelativePosition(0.1f, 0.4f);
        keyFrameAnimation3 = keyFrameAnimation3.duplicate(false, false);
        keyFrameAnimation3.AddTargetObject(this._btnVacuum);
        this._btnVacuum.setHoverAnimation(keyFrameAnimation3);
        this._btnCooling.setOrigin(0.5f, 0.5f);
        this._btnCooling.setRelativePosition(0.1f, 0.65f);
        keyFrameAnimation3 = keyFrameAnimation3.duplicate(false, false);
        keyFrameAnimation3.AddTargetObject(this._btnCooling);
        this._btnCooling.setHoverAnimation(keyFrameAnimation3);
        this._parrot.setRelativePosition(0.9f, 0.99f);
        this._parrot.SetText(Language.getString("Environment_parrot_1"), 330, 200, false);
    }

    @Override
    public void loadResources() {
        this.background = ResourceManager.LoadAudio("audio/54638__Sea_Fury__Turbine_Room.mp3");
        this.vacuum = ResourceManager.LoadAudio("audio/32671__Incarnadine__vacuum_cleaner_2.mp3");
    }

    @Override
    public void update(float f) {
        super.update(f);
        float f2 = 1.0f - (float)EnvironmentSystemVariables.NumberVacuumPumps / (float)EnvironmentSystemVariables.MaxVacuumPumps;
        if (this.vacuum != null) {
            this.vacuum.setGain(-17.0f + 13.0f * (1.0f - f2));
        }
        f2 = EnvironmentSystemVariables.getTargetTemperature() / (float)EnvironmentSystemVariables.getAmbientTemperature();
        if (this.background != null) {
            this.background.setGain(-17.0f + 16.5f * (1.0f - f2));
        }
    }

    @Override
    public void onPageHide() {
        if (this.vacuum != null) {
            this.vacuum.pause();
        }
        if (this.background != null) {
            this.background.pause();
        }
    }

    @Override
    public void onPageShow() {
        if (!this._detectorDepth.isVisible()) {
            if (this.vacuum != null) {
                this.vacuum.loop();
            }
            if (this.background != null) {
                this.background.loop();
            }
        }
    }

    @Override
    public void reset() {
        this._detectorCooling.reset();
        this._detectorVacuum.reset();
        this._detectorDepth.reset();
    }

    private class IconClicked
    implements ButtonElement.IButtonCallback {
        private IconClicked() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (n == 37) {
                if (buttonElement == EnvironmentSystemBase.this._btnDepth) {
                    EnvironmentSystemBase.this._detectorDepth.setVisible(true);
                    EnvironmentSystemBase.this._detectorVacuum.setVisible(false);
                    EnvironmentSystemBase.this._detectorCooling.setVisible(false);
                    if (EnvironmentSystemBase.this.background != null && EnvironmentSystemBase.this.background.isPlaying()) {
                        EnvironmentSystemBase.this.background.pause();
                    }
                    if (EnvironmentSystemBase.this.vacuum != null && EnvironmentSystemBase.this.vacuum.isPlaying()) {
                        EnvironmentSystemBase.this.vacuum.pause();
                    }
                } else if (buttonElement == EnvironmentSystemBase.this._btnVacuum) {
                    EnvironmentSystemBase.this._detectorDepth.setVisible(false);
                    EnvironmentSystemBase.this._detectorVacuum.setVisible(true);
                    EnvironmentSystemBase.this._detectorCooling.setVisible(false);
                    if (EnvironmentSystemBase.this.background != null && !EnvironmentSystemBase.this.background.isPlaying()) {
                        EnvironmentSystemBase.this.background.loop();
                    }
                    if (EnvironmentSystemBase.this.vacuum != null && !EnvironmentSystemBase.this.vacuum.isPlaying()) {
                        EnvironmentSystemBase.this.vacuum.loop();
                    }
                } else if (buttonElement == EnvironmentSystemBase.this._btnCooling) {
                    EnvironmentSystemBase.this._detectorDepth.setVisible(false);
                    EnvironmentSystemBase.this._detectorVacuum.setVisible(false);
                    EnvironmentSystemBase.this._detectorCooling.setVisible(true);
                    if (EnvironmentSystemBase.this.background != null && !EnvironmentSystemBase.this.background.isPlaying()) {
                        EnvironmentSystemBase.this.background.loop();
                    }
                    if (EnvironmentSystemBase.this.vacuum != null && !EnvironmentSystemBase.this.vacuum.isPlaying()) {
                        EnvironmentSystemBase.this.vacuum.loop();
                    }
                }
            }
        }
    }
}

