/*
 * Decompiled with CFR 0.152.
 */
package pages.environmentsubsystem;

import core.ImageElement;
import core.ScreenElement;
import core.gui.GLabel;
import core.gui.GWSlider;
import core.gui.TextBlockElement;
import core.language.Language;
import game.variables.EnvironmentSystemVariables;
import java.util.Random;
import pages.environmentsubsystem.VacuumTank;
import processing.core.PApplet;

public class DetectorVacuum
extends ScreenElement {
    private ImageElement _pressureGuage;
    private ImageElement _backdrop;
    private ImageElement _pressureGuageHand;
    private GWSlider _sldVacPumps;
    private GLabel _title;
    private GLabel _cost;
    private TextBlockElement _dscTxt;
    private Random _rand = new Random();
    private VacuumTank _vacTank;

    public DetectorVacuum(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.75f, 1.0f);
        this._pressureGuageHand = new ImageElement("pressuregaugehand.png", this, pApplet);
        this._pressureGuage = new ImageElement("pressuregauge.png", this, pApplet);
        this._pressureGuage.addChild(this._pressureGuageHand);
        this._vacTank = new VacuumTank(this, pApplet);
        this._backdrop = new ImageElement("vacuumbackdrop.jpg", this, pApplet);
        this._title = new GLabel(this, pApplet, Language.getString("Environment_vacuum_title"), 0.05f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._dscTxt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Environment_vacuum"), 18, 0.95f, 0.4f);
        this._dscTxt.setRelativePosition(0.05f, 0.08f);
        this._sldVacPumps = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.3f));
        this._sldVacPumps.setRelativePosition(0.64f, 0.48f);
        this._sldVacPumps.setLimits((float)EnvironmentSystemVariables.NumberVacuumPumps, 0.0f, (float)EnvironmentSystemVariables.MaxVacuumPumps);
        this._sldVacPumps.setFontColour(255, 255, 255);
        this._sldVacPumps.setFont(Language.getString("Font_Default"), 17);
        this._sldVacPumps.setUnit(" " + Language.getString("pump_units"));
        this._cost = new GLabel(this, pApplet, Language.getString("Environment_vacuum_cost") + ":", 0.95f, 0.58f, (int)((float)this.getWidth() * 0.35f));
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setTextAlign(2);
        this.addChild(this._backdrop);
        this.addChild(this._vacTank);
        this.addChild(this._pressureGuage);
        this.addChild(this._dscTxt);
        this.addChild(this._title);
        this.addChild(this._sldVacPumps);
        this.addChild(this._cost);
    }

    @Override
    public void setup() {
        this._vacTank.setRelativePosition(0.0f, 0.2f);
        this._pressureGuage.setOrigin(0.0f, 1.0f);
        this._pressureGuage.setRelativePosition(0.0f, 0.9f);
        this._pressureGuageHand.setOrigin(0.5f, 1.0f);
        this._pressureGuageHand.setRelativePosition(0.46583852f, 0.6688963f);
    }

    public void reset() {
        this._sldVacPumps.setLimits((float)EnvironmentSystemVariables.NumberVacuumPumps, 0.0f, (float)EnvironmentSystemVariables.MaxVacuumPumps);
    }

    @Override
    public void update(float f) {
        EnvironmentSystemVariables.NumberVacuumPumps = this._sldVacPumps.getValue();
        float f2 = (float)Math.log10(EnvironmentSystemVariables.getPressure() / (float)EnvironmentSystemVariables.AtmospherePressure);
        float f3 = 2.5132742f + 0.33772123f * f2;
        f3 = (float)((double)f3 + (double)((this._rand.nextFloat() - 0.5f) * (float)Math.PI / 25.0f) * (1.5 * (3.0 - Math.log10(EnvironmentSystemVariables.getPressure())) / 15.0));
        this._pressureGuageHand.setRotation(Float.valueOf(PApplet.max(f3, -2.4434612f)));
        this._cost.setText(Language.getString("Environment_vacuum_cost") + ": " + this.FormatMoney(Math.round(EnvironmentSystemVariables.getVacuumCosts())));
    }
}

