/*
 * Decompiled with CFR 0.152.
 */
package pages.environmentsubsystem;

import core.ImageElement;
import core.ScreenElement;
import core.gui.GLabel;
import core.gui.GWSlider;
import core.gui.TextBlockElement;
import core.language.Language;
import game.variables.EnvironmentSystemVariables;
import processing.core.PApplet;

public class DetectorDepth
extends ScreenElement {
    private ImageElement _mountains;
    private ImageElement _mole;
    private ImageElement _tunnel;
    private GWSlider _sldDepth;
    private GLabel _title;
    private GLabel _cost;
    private TextBlockElement _dscTxt;

    public DetectorDepth(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.78f, 1.0f);
        this._mountains = new ImageElement("mountains.png", this, pApplet);
        this._mole = new ImageElement("mole.png", this, pApplet);
        this._tunnel = new ImageElement("tunnel.png", this, pApplet);
        this._title = new GLabel(this, pApplet, Language.getString("Environment_depth_title"), 0.05f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._title.setColour(0.0f, 0.0f, 0.0f);
        this._sldDepth = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this._dscTxt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Environment_depth"), 18, 0.4f, 0.5f);
        this._dscTxt.setRelativePosition(0.05f, 0.45f);
        this._dscTxt.setFontColour(0.0f, 0.0f, 0.0f);
        this._sldDepth.setRelativePosition(0.61f, 0.5f);
        this._sldDepth.setLimits(0.0f, 0.0f, (float)EnvironmentSystemVariables.MaxDetectorDepth);
        this._sldDepth.setFontColour(0, 0, 0);
        this._sldDepth.setFont(Language.getString("Font_Default"), 17);
        this._sldDepth.setUnit("m");
        this._cost = new GLabel(this, pApplet, Language.getString("Environment_depth_cost") + ":", 0.95f, 0.6f, (int)((float)this.getWidth() * 0.35f));
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setTextAlign(2);
        this.addChild(this._mountains);
        this.addChild(this._dscTxt);
        this.addChild(this._title);
        this.addChild(this._sldDepth);
        this.addChild(this._cost);
        this.addChild(this._tunnel);
        this.addChild(this._mole);
    }

    @Override
    public void setup() {
        this._mole.setOrigin(0.5f, 0.5f);
        this._mole.setRelativePosition(0.4888889f, 0.3f);
        this._tunnel.setOrigin(0.5f, 0.0f);
        this._tunnel.setScale(1.0f, 0.0f);
        this._tunnel.setRelativePosition(0.4888889f, 0.27666667f);
    }

    public void reset() {
        this._sldDepth.setLimits(0.0f, 0.0f, (float)EnvironmentSystemVariables.MaxDetectorDepth);
    }

    @Override
    public void update(float f) {
        float f2 = this._sldDepth.getValuef() / (float)this._sldDepth.getMaxValue();
        EnvironmentSystemVariables.DetectorDepth = this._sldDepth.getValue();
        this._tunnel.setScale(1.0f, 4.0f * f2);
        this._mole.setY(0.25333333f * (float)this.getParent().getHeight() + (float)this._tunnel.getHeight() * 4.0f * f2);
        EnvironmentSystemVariables.DepthCosts = (double)PApplet.pow(Math.max(EnvironmentSystemVariables.DetectorDepth - 20, 0), 0.33333334f) * 7500000.0;
        if (EnvironmentSystemVariables.DetectorDepth > 10 & EnvironmentSystemVariables.DetectorDepth < 100) {
            EnvironmentSystemVariables.DepthComplex = 1.0;
        } else if (EnvironmentSystemVariables.DetectorDepth > 100 & EnvironmentSystemVariables.DetectorDepth < 500) {
            EnvironmentSystemVariables.DepthComplex = 4.0;
        } else if (EnvironmentSystemVariables.DetectorDepth > 500) {
            EnvironmentSystemVariables.DepthComplex = 6.0;
        }
        this._cost.setText(Language.getString("Environment_depth_cost") + ": " + this.FormatMoney(EnvironmentSystemVariables.DepthCosts));
    }

    public void closed() {
    }

    public void opened() {
    }
}

