/*
 * Decompiled with CFR 0.152.
 */
package pages.environmentsubsystem;

import core.ImageElement;
import core.ScreenElement;
import core.gui.GLabel;
import core.gui.GWSlider;
import core.gui.TextBlockElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.variables.EnvironmentSystemVariables;
import pages.environmentsubsystem.VacuumTank;
import processing.core.PApplet;

public class DetectorCooling
extends ScreenElement {
    private ImageElement _backdrop;
    private ImageElement _dewar;
    private ImageElement _dewarfrost;
    private Thermometer _thermom;
    private GWSlider _sldTemp;
    private GLabel _title;
    private GLabel _cost;
    private TextBlockElement _dscTxt;
    private VacuumTank _vacTank;
    AudioPlayer background;

    public DetectorCooling(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.75f, 1.0f);
        this._thermom = new Thermometer((ScreenElement)this, pApplet);
        this._vacTank = new VacuumTank(this, pApplet);
        this._backdrop = new ImageElement("vacuumbackdrop.jpg", this, pApplet);
        this._dewar = new ImageElement("dewar.png", this, pApplet);
        this._dewarfrost = new ImageElement("dewarfrost.png", this, pApplet);
        this._title = new GLabel(this, pApplet, Language.getString("Environment_cooling_title"), 0.05f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._sldTemp = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.41f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this._dscTxt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Environment_cooling"), 18, 0.95f, 0.4f);
        this._dscTxt.setRelativePosition(0.05f, 0.08f);
        this._sldTemp.setRelativePosition(0.64f, 0.48f);
        this._sldTemp.setLimits((float)EnvironmentSystemVariables.getAmbientTemperature(), 1.0f, (float)EnvironmentSystemVariables.getAmbientTemperature());
        this._sldTemp.setFontColour(255, 255, 255);
        this._sldTemp.setFont(Language.getString("Font_Default"), 17);
        this._sldTemp.setUnit(Language.getString("Kelvin"));
        this._cost = new GLabel(this, pApplet, Language.getString("Environment_cooling_cost") + ":", 1.0f, 0.6f, (int)((float)this.getWidth() * 0.35f));
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setTextAlign(2);
        this.addChild(this._backdrop);
        this.addChild(this._vacTank);
        this.addChild(this._dewar);
        this.addChild(this._dewarfrost);
        this.addChild(this._thermom);
        this.addChild(this._dscTxt);
        this.addChild(this._title);
        this.addChild(this._sldTemp);
        this.addChild(this._cost);
    }

    public void reset() {
        this._sldTemp.setLimits((float)EnvironmentSystemVariables.getAmbientTemperature(), 1.0f, (float)EnvironmentSystemVariables.getAmbientTemperature());
    }

    @Override
    public void setup() {
        this._vacTank.setRelativePosition(0.0f, 0.2f);
        this._thermom.setOrigin(0.0f, 1.0f);
        this._thermom.setRelativePosition(0.22f, 0.82f);
        this._thermom.setRotation(Float.valueOf(-0.62831855f));
        this._dewar.setOrigin(0.0f, 0.0f);
        this._dewarfrost.setOrigin(0.0f, 0.0f);
        this._dewar.setRelativePosition(0.15f, 0.5f);
        this._dewarfrost.setRelativePosition(0.15f, 0.5f);
    }

    @Override
    public void update(float f) {
        this._sldTemp.setLimits((float)this._sldTemp.getValue(), 1.0f, (float)EnvironmentSystemVariables.getAmbientTemperature());
        float f2 = EnvironmentSystemVariables.getTargetTemperature();
        if ((double)f2 < 273.15) {
            this._dewarfrost.setOpacity(1.0f - f2 / 273.15f);
        } else {
            this._dewarfrost.setOpacity(0.0f);
        }
        EnvironmentSystemVariables.setTargetTemperature(this._sldTemp.getValuef());
        this._cost.setText(Language.getString("Environment_cooling_cost") + ": " + this.FormatMoney(EnvironmentSystemVariables.getCoolingCosts()));
        if (EnvironmentSystemVariables.getTargetTemperature() < 260.0f & EnvironmentSystemVariables.getTargetTemperature() > 77.0f) {
            EnvironmentSystemVariables.CoolingComplex = 1.0;
        } else if (EnvironmentSystemVariables.getTargetTemperature() < 77.0f & EnvironmentSystemVariables.getTargetTemperature() > 10.0f) {
            EnvironmentSystemVariables.CoolingComplex = 5.0;
        } else if (EnvironmentSystemVariables.getTargetTemperature() < 10.0f) {
            EnvironmentSystemVariables.CoolingComplex = 7.0;
        }
    }

    public void closed() {
    }

    public void opened() {
    }

    private class Thermometer
    extends ImageElement {
        private int liquidWidth;
        private float height;

        public Thermometer(ScreenElement screenElement, PApplet pApplet) {
            super("thermometer.png", screenElement, pApplet);
            this.liquidWidth = 4;
        }

        @Override
        public void update(float f) {
            float f2 = EnvironmentSystemVariables.getTargetTemperature();
            float f3 = EnvironmentSystemVariables.getAmbientTemperature();
            this.height = f2 / f3;
        }

        @Override
        public void render() {
            this._app.pushStyle();
            this._app.stroke(0, this.getAbsoluteOpacity() * 255.0f);
            this._app.fill(255.0f, 0.0f, 0.0f, this.getAbsoluteOpacity() * 255.0f);
            this._app.rect((float)((double)this.getWidth() * 0.5 - (double)(this.liquidWidth / 2)), (int)((float)this.getHeight() * 170.0f / 200.0f), this.liquidWidth, (int)(-this.height * (float)this.getHeight() * 130.0f / 170.0f));
            this._app.popStyle();
            super.render();
        }
    }
}

