/*
 * Decompiled with CFR 0.152.
 */
package pages.controlroom.elements;

import core.ScreenElement;
import core.gui.TextBlockElement;
import core.language.Language;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class HUD
extends ScreenElement {
    PGraphics _tmp;
    PImage TextDisplay;
    PFont myfont;
    int _w;
    int _h;
    int _currentState;
    static final int _maxState = 6;
    static final int maxlines = 20;
    int _newState;
    boolean mouseHover;
    String window;
    String[][] stateStart;
    String[][] stateSuccess;
    String[][] stateFail;
    float[][] wait_time;
    float[] stateProb;
    int maxStates = 1;
    SimpleDateFormat sdf;
    TextBlockElement txtConsole;
    float texttimer;
    float texttimer_target;
    int _stateMessage;
    boolean started;
    ArrayList<String> textlines;

    public HUD(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setClickable(true);
        this.stateProb = new float[7];
        this.stateProb[0] = 0.9f;
        this.stateProb[1] = 0.9f;
        this.stateProb[2] = 0.7f;
        this.stateProb[3] = 0.8f;
        this.stateProb[4] = 0.6f;
        this.stateProb[5] = 0.8f;
        this.stateProb[6] = 0.9f;
        this.stateStart = new String[7][2];
        this.stateSuccess = new String[7][1];
        this.stateFail = new String[7][1];
        this._currentState = 0;
        this._stateMessage = 0;
        this.texttimer_target = 1000.0f;
        this.textlines = new ArrayList();
        this.window = "";
        this.texttimer = this._app.millis();
        this.started = false;
        this.txtConsole = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), "", 14, 0.9f, 0.9f);
        this.txtConsole.setRelativePosition(0.05f, 0.05f);
        this.txtConsole.setFont(Language.getString("Font_Default"), 15);
        this.addChild(this.txtConsole);
    }

    public void reset() {
        this._currentState = 0;
        this._stateMessage = 0;
    }

    @Override
    public void loadResources() {
        this.sdf = new SimpleDateFormat("'" + Language.getString("Control_control") + " 'HH:mm': '");
        this.stateStart[0][0] = new String(Language.getString("Control_1"));
        this.stateStart[0][1] = new String();
        this.stateStart[1][0] = new String(Language.getString("Control_2"));
        this.stateStart[1][1] = new String(Language.getString("Control_3"));
        this.stateStart[2][0] = new String(Language.getString("Control_4"));
        this.stateStart[2][1] = new String(Language.getString("Control_5"));
        this.stateStart[3][0] = new String(Language.getString("Control_6"));
        this.stateStart[3][1] = new String(Language.getString("Control_7"));
        this.stateStart[4][0] = new String(Language.getString("Control_8"));
        this.stateStart[4][1] = new String(Language.getString("Control_9"));
        this.stateStart[5][0] = new String(Language.getString("Control_10"));
        this.stateStart[5][1] = new String("");
        this.stateStart[6][0] = new String(Language.getString("Control_11"));
        this.stateStart[6][1] = new String(Language.getString("Control_12"));
        this.stateSuccess[0][0] = new String("");
        this.stateSuccess[1][0] = new String(Language.getString("Control_13"));
        this.stateSuccess[2][0] = new String(Language.getString("Control_14"));
        this.stateSuccess[3][0] = new String(Language.getString("Control_15"));
        this.stateSuccess[4][0] = new String(Language.getString("Control_16"));
        this.stateSuccess[5][0] = new String(Language.getString("Control_17"));
        this.stateSuccess[6][0] = new String(" *** " + Language.getString("Control_18") + " ***");
        this.stateFail[0][0] = new String("");
        this.stateFail[1][0] = new String("### " + Language.getString("Control_19"));
        this.stateFail[2][0] = new String("### " + Language.getString("Control_20"));
        this.stateFail[3][0] = new String("### " + Language.getString("Control_21"));
        this.stateFail[4][0] = new String("### " + Language.getString("Control_22"));
        this.stateFail[5][0] = new String("### " + Language.getString("Control_23"));
        this.stateFail[6][0] = new String("### " + Language.getString("Control_24"));
        this._h = this._w = (int)((float)this._app.width * 500.0f / 900.0f);
        this._tmp = this._app.createGraphics(this._w, this._h, "processing.core.PGraphicsJava2D");
        this._tmp.beginDraw();
        this._tmp.strokeWeight(2.0f);
        this._tmp.stroke(255);
        this._tmp.fill(0.0f, 40.0f, 0.0f, 200.0f);
        this._tmp.rect(0.0f, 0.0f, this._w - 4, this._h - 4);
        this._tmp.endDraw();
        this.TextDisplay = this._app.createImage(this._w, this._h, 2);
        this.TextDisplay.copy(this._tmp, 0, 0, this._w, this._h, 0, 0, this._w, this._h);
        this.setBounds(this._w, this._h);
    }

    @Override
    public void setup() {
        this.texttimer = this._app.millis();
        this.started = false;
    }

    @Override
    public void onMouseEvent(int n, int n2) {
        switch (n) {
            case 504: {
                this.mouseHover = true;
                this._newState = 0;
                break;
            }
            case 505: {
                this.mouseHover = false;
                this._newState = 1;
            }
        }
    }

    public void switchState(int n) {
        this._currentState = this._newState = n;
        this._stateMessage = 0;
    }

    @Override
    public void render() {
        if (this.started) {
            this._app.image(this.TextDisplay, 0.0f, 0.0f);
        }
    }

    @Override
    public void update(float f) {
        if (this.started && (float)this._app.millis() - this.texttimer > this.texttimer_target && this._currentState <= 6) {
            String string = this.sdf.format(new Date());
            String string2 = new String();
            this.texttimer = this._app.millis();
            this.texttimer_target = (float)(-300.0 + Math.random() * 1000.0);
            if (Math.random() > 0.95) {
                this.texttimer_target += 3000.0f;
            }
            switch (this._stateMessage) {
                case 0: {
                    string2 = string;
                    string2 = string2 + this.stateStart[this._currentState][0];
                    this._stateMessage = 1;
                    break;
                }
                case 1: {
                    if (this.stateStart[this._currentState][1].length() > 0) {
                        string2 = string;
                        string2 = string2 + this.stateStart[this._currentState][1];
                    }
                    if (Math.random() < (double)(2.0f * this.stateProb[this._currentState])) {
                        this._stateMessage = 2;
                        break;
                    }
                    this._stateMessage = -1;
                    break;
                }
                case 2: {
                    if (this.stateSuccess[this._currentState][0].length() > 0) {
                        string2 = string;
                        string2 = string2 + this.stateSuccess[this._currentState][0];
                    }
                    this.switchState(this._currentState + 1);
                    break;
                }
                case -1: {
                    if (this.stateFail[this._currentState][0].length() > 0) {
                        string2 = string;
                        string2 = string2 + this.stateFail[this._currentState][0];
                    }
                    this.switchState(0);
                    break;
                }
                default: {
                    this.switchState(0);
                }
            }
            if (string2.length() > 0) {
                this.textlines.add(string2);
                if (this.textlines.size() > 20) {
                    this.textlines.remove(0);
                }
                this.window = "";
                for (int i = 0; i < this.textlines.size(); ++i) {
                    this.window = this.window + this.textlines.get(i) + '\n';
                }
                this.txtConsole.setText(this.window);
            }
        }
    }

    public void startText() {
        this.started = true;
        this.texttimer = this._app.millis();
    }

    public boolean completed() {
        return this._currentState > 6 && (float)this._app.millis() - this.texttimer > 2000.0f;
    }
}

