/*
 * Decompiled with CFR 0.152.
 */
package pages.controlroom;

import core.GamePage;
import core.GameScreen;
import core.ResourceManager;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import ddf.minim.AudioPlayer;
import pages.controlroom.elements.HUD;
import pages.pioffice.elements.PInvestigator;
import processing.core.PApplet;
import processing.core.PImage;

public class ControlRoomPage
extends GamePage {
    PImage backdrop;
    PInvestigator piChair;
    HUD hud;
    KeyFrameAnimation hudShow;
    KeyFrameAnimation hudHide;
    boolean running;
    AudioPlayer beeping;
    AudioPlayer typing;
    float time;

    public ControlRoomPage(PApplet pApplet) {
        super(pApplet);
        this.hud = new HUD(this, this._app);
        this.piChair = new PInvestigator(this, this._app);
        this.addChild(this.piChair);
        this.addChild(this.hud);
        this.hudShow = new KeyFrameAnimation(false, this.hud, new OnHudShow());
        this.hudShow.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this.hudShow.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        this.hudShow.AddKeyFrame(new FloatKeyFrame(1.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.hudHide = new KeyFrameAnimation(false, this.hud, new OnHudHide());
        this.hudHide.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.hudHide.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.hudHide.AddKeyFrame(new FloatKeyFrame(1.0f, Float.valueOf(0.0f), TargetProperty.opacity));
    }

    @Override
    public void setup() {
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation(false, this);
        keyFrameAnimation2.AddKeyFrame(new PVectorKeyFrame(0.0f, 0.0f, 0.0f, TargetProperty.position));
        keyFrameAnimation2.AddKeyFrame(new PVectorKeyFrame(1.0f, 0.0f, 0.0f, TargetProperty.position));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        this.setOpacity(0.0f);
    }

    @Override
    public void PostShow() {
        if (this.IsFirstShow()) {
            this.piChair.ShowPI.addCallback(new OnPIShow());
        }
        this.piChair.ShowPI.Start();
        this.running = true;
    }

    @Override
    public void PreShow() {
        this.hud.reset();
        this.setOpacity(0.0f);
        this.hud.setOpacity(0.0f);
        GameScreen.hideHUD();
        this.setRelativePosition(0.0f, 1.0f);
        this.hud.setRelativePosition(0.4f, 0.1f);
        this.piChair.setRelativePosition(0.36666667f, 1.1666666f);
        if (this.beeping != null) {
            this.beeping.setGain(-10.0f);
            GameScreen.setChangeMusic(this.beeping, 4.0f, -12.0f);
        }
        this.time = 0.0f;
    }

    @Override
    public void update(float f) {
        super.update(f);
        this.hudHide.Update(f);
        this.hudShow.Update(f);
        this.time += f;
        this.running();
    }

    public void running() {
        if (this.running && this.hud.completed()) {
            this.hudHide.Start();
            this.running = false;
        }
    }

    @Override
    public void render() {
        this._app.image(this.backdrop, 0.0f, 0.0f);
    }

    @Override
    public void loadResources() {
        this.backdrop = ResourceManager.LoadImage("controlroom900x600.jpg");
        this.beeping = ResourceManager.LoadAudio("audio/3643__suonho__futuretrocomputing_06_suonho.mp3");
    }

    private class OnPIHide
    implements IAnimationCompleteCallback {
        private OnPIHide() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            ControlRoomPage.this.piChair.HidePI.removeCallback(new OnPIHide());
            GameScreen.showPage("FinalScore");
        }
    }

    private class OnPIShow
    implements IAnimationCompleteCallback {
        private OnPIShow() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            ControlRoomPage.this.hudShow.Start();
        }
    }

    private class OnHudHide
    implements IAnimationCompleteCallback {
        private OnHudHide() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            ControlRoomPage.this.piChair.HidePI.addCallback(new OnPIHide());
            ControlRoomPage.this.piChair.HidePI.Start();
        }
    }

    private class OnHudShow
    implements IAnimationCompleteCallback {
        private OnHudShow() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            ControlRoomPage.this.hud.startText();
        }
    }
}

