/*
 * Decompiled with CFR 0.152.
 */
package highscore;

import core.GamePage;
import core.GameScreen;
import core.ImageElement;
import core.ScreenElement;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.gui.ButtonElement;
import core.gui.GLabel;
import core.gui.OkDialog;
import core.gui.TextButtonElement;
import core.language.Language;
import game.PlayerData;
import guicomponents.GComponent;
import highscore.HighScores;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.gwoptics.graphics.GWColour;
import processing.core.PApplet;

public class HighScoreScreen
extends GamePage {
    ImageElement _ss_img;
    ImageElement _nn_img;
    ImageElement _bb_img;
    ArrayList<GLabel> _names;
    ArrayList<GLabel> _scores;
    ArrayList<GLabel> _position;
    ArrayList<GLabel> _ss;
    ArrayList<GLabel> _nn;
    ArrayList<GLabel> _bb;
    TextButtonElement _btnDone;
    GLabel txt;
    GLabel txt2;
    final double KM = 1000.0;
    final double Re = 6400.0;
    final double AU = 1.49598E8;
    final double PC = 3.08568025E16;
    final double KPC = 3.08568025E19;
    final double MPC = 3.08568025E22;
    private OkDialog okdiag;
    DecimalFormat frmKm = new DecimalFormat("#0.000 Km");
    DecimalFormat frmAu = new DecimalFormat("#0.000 Au");
    DecimalFormat frmPC = new DecimalFormat("#0.000 Parsec");
    DecimalFormat frmKPC = new DecimalFormat("#0.000 Kiloparsec");
    DecimalFormat frmMPC = new DecimalFormat("#0.000 Megaparsec");
    public boolean FromIntroPage = true;

    public HighScoreScreen(PApplet pApplet) {
        super(pApplet);
        Object object;
        this.okdiag = new OkDialog(this, pApplet, Language.getString("Final_sorry"), 300, 200, new OnOk());
        this.okdiag.setVisible(false);
        this._names = new ArrayList();
        this._scores = new ArrayList();
        this._position = new ArrayList();
        this._ss = new ArrayList();
        this._nn = new ArrayList();
        this._bb = new ArrayList();
        this._bb_img = new ImageElement("BHBHinspiral.png", this, pApplet);
        this._nn_img = new ImageElement("NSNSinspiral.png", this, pApplet);
        this._ss_img = new ImageElement("supernova.png", this, pApplet);
        for (int i = 0; i < 10; ++i) {
            GLabel gLabel = new GLabel(this, pApplet, "", 0.1f, 0.12f + 0.07f * (float)i, (int)(0.45f * (float)this.getWidth()));
            object = new GLabel(this, pApplet, "", 0.15f, 0.12f + 0.07f * (float)i, (int)(0.45f * (float)this.getWidth()));
            GLabel gLabel2 = new GLabel(this, pApplet, "", 0.7f, 0.12f + 0.07f * (float)i, (int)(0.45f * (float)this.getWidth()));
            GLabel gLabel3 = new GLabel(this, pApplet, "", 0.4f, 0.12f + 0.07f * (float)i, (int)(0.45f * (float)this.getWidth()));
            GLabel gLabel4 = new GLabel(this, pApplet, "", 0.5f, 0.12f + 0.07f * (float)i, (int)(0.45f * (float)this.getWidth()));
            GLabel gLabel5 = new GLabel(this, pApplet, "", 0.6f, 0.12f + 0.07f * (float)i, (int)(0.45f * (float)this.getWidth()));
            ((ScreenElement)object).setOrigin(0.0f, 0.5f);
            gLabel2.setOrigin(0.0f, 0.5f);
            gLabel.setOrigin(0.5f, 0.5f);
            gLabel3.setOrigin(0.5f, 0.5f);
            gLabel4.setOrigin(0.5f, 0.5f);
            gLabel5.setOrigin(0.5f, 0.5f);
            ((GLabel)object).setFont(Language.getString("Font_Default"), 18);
            gLabel2.setFont(Language.getString("Font_Default"), 18);
            gLabel.setFont(Language.getString("Font_Default"), 18);
            gLabel3.setFont(Language.getString("Font_Default"), 18);
            gLabel4.setFont(Language.getString("Font_Default"), 18);
            gLabel5.setFont(Language.getString("Font_Default"), 18);
            ((GComponent)object).setTextAlign(1);
            gLabel2.setTextAlign(1);
            gLabel.setTextAlign(4);
            gLabel3.setTextAlign(4);
            gLabel4.setTextAlign(4);
            gLabel5.setTextAlign(4);
            this._position.add(gLabel);
            this._names.add((GLabel)object);
            this._scores.add(gLabel2);
            this._ss.add(gLabel3);
            this._nn.add(gLabel4);
            this._bb.add(gLabel5);
            this.addChild(gLabel);
            this.addChild((ScreenElement)object);
            this.addChild(gLabel2);
            this.addChild(gLabel3);
            this.addChild(gLabel4);
            this.addChild(gLabel5);
        }
        this._btnDone = new TextButtonElement(this, pApplet, "buttons/donebutton.png", "buttons/donebutton.png", "buttons/donebuttonpressed.png", Language.getString("Done"));
        this._btnDone.setCallback(new BtnDone());
        this._btnDone.setRelativePosition(0.5f, 0.85f);
        this._btnDone.setOrigin(0.5f, 0.5f);
        this._btnDone.setTextColours(new GWColour(0, 0, 0), null, null);
        this._btnDone.setFont(Language.getString("Font_Handwritten"), 20);
        this.txt = new GLabel(this, pApplet, "", 0.5f, 0.95f, this.getWidth());
        this.txt.setFont(Language.getString("Font_Default"), 16);
        this.txt.setTextAlign(4);
        this.txt.setOrigin(0.5f, 1.0f);
        this.txt2 = new GLabel(this, pApplet, "", 0.5f, 0.975f, this.getWidth());
        this.txt2.setFont(Language.getString("Font_Default"), 16);
        this.txt2.setTextAlign(4);
        this.txt2.setOrigin(0.5f, 1.0f);
        this.addChild(this.txt);
        this.addChild(this.txt2);
        this.addChild(this._btnDone);
        this.addChild(this._ss_img);
        this.addChild(this._nn_img);
        this.addChild(this._bb_img);
        this.addChild(this.okdiag);
        this._ss_img.setOrigin(0.5f, 0.0f);
        this._nn_img.setOrigin(0.5f, 0.0f);
        this._bb_img.setOrigin(0.5f, 0.0f);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        object = new KeyFrameAnimation(false, this);
        ((KeyFrameAnimation)object).AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        ((KeyFrameAnimation)object).AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation((KeyFrameAnimation)object);
        this.setHideAnimation(keyFrameAnimation);
    }

    @Override
    public void loadResources() {
    }

    @Override
    public void PreShow() {
        this._ss_img.setRelativePosition(0.4f, 0.01f);
        this._nn_img.setRelativePosition(0.5f, 0.01f);
        this._bb_img.setRelativePosition(0.6f, 0.01f);
        this.setOpacity(0.0f);
        ArrayList<HighScores.HighScoreEntry> arrayList = null;
        arrayList = HighScores.GetScores(PlayerData.PlayerHighScorePosition);
        this.txt.setText(String.format(Language.getString("highscore_text"), "1.2"));
        this.txt2.setText(Language.getString("highscore_text_2"));
        if (arrayList == null) {
            this.okdiag.show();
        } else {
            String string = "";
            for (int i = 0; i < 10; ++i) {
                if (i <= arrayList.size() - 1) {
                    double d = Double.parseDouble(arrayList.get((int)i).Score);
                    if (d < 1.49598E8) {
                        string = this.frmKm.format(d / 1000.0);
                    } else if (d < 3.08568025E16) {
                        string = this.frmAu.format(d / 1.49598E8);
                    } else if (d < 3.08568025E19) {
                        string = this.frmPC.format(d / 3.08568025E16);
                    } else if (d < 3.08568025E22) {
                        string = this.frmKPC.format(d / 3.08568025E19);
                    } else if (d >= 3.08568025E22) {
                        string = this.frmMPC.format(d / 3.08568025E22);
                    }
                    if (PlayerData.PlayerHighScorePosition == Integer.parseInt(arrayList.get((int)i).Position)) {
                        this._position.get(i).setColour(0.0f, 1.0f, 1.0f);
                        this._names.get(i).setColour(0.0f, 1.0f, 1.0f);
                        this._scores.get(i).setColour(0.0f, 1.0f, 1.0f);
                    } else {
                        this._position.get(i).setColour(1.0f, 1.0f, 1.0f);
                        this._names.get(i).setColour(1.0f, 1.0f, 1.0f);
                        this._scores.get(i).setColour(1.0f, 1.0f, 1.0f);
                    }
                    this._position.get(i).setText(arrayList.get((int)i).Position + ".");
                    this._names.get(i).setText(arrayList.get((int)i).Name);
                    this._ss.get(i).setText(Integer.valueOf(arrayList.get((int)i).ss).toString());
                    this._nn.get(i).setText(Integer.valueOf(arrayList.get((int)i).nn).toString());
                    this._bb.get(i).setText(Integer.valueOf(arrayList.get((int)i).bb).toString());
                    this._scores.get(i).setText(string);
                    continue;
                }
                this._position.get(i).setText("");
                this._names.get(i).setText("");
                this._scores.get(i).setText("");
                this._ss.get(i).setText("");
                this._nn.get(i).setText("");
                this._bb.get(i).setText("");
            }
        }
    }

    private class BtnDone
    implements ButtonElement.IButtonCallback {
        private BtnDone() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (HighScoreScreen.this.FromIntroPage) {
                GameScreen.showPage("Intro");
            } else {
                GameScreen.showPage("FinalScore");
            }
        }
    }

    private class OnOk
    implements ButtonElement.IButtonCallback {
        private OnOk() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            HighScoreScreen.this.okdiag.hide();
        }
    }
}

