/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import core.ScreenElement;
import guicomponents.G4P;
import guicomponents.GComponent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class GSlider
extends GComponent {
    public static final int INTEGER = 0;
    public static final int DECIMAL = 1;
    public static final int EXPONENT = 2;
    protected float init;
    protected float maxValue = 0.0f;
    protected float minValue = 100.0f;
    protected float value;
    protected int _valueType;
    protected int thumbMin;
    protected int thumbMax;
    protected int thumbPos;
    protected int thumbTargetPos;
    protected int thumbSize = 10;
    protected int thumbInertia = 1;
    protected int offset;
    protected boolean isValueChanging = false;

    public GSlider(ScreenElement screenElement, PApplet pApplet, float f, float f2, int n, int n2) {
        super(screenElement, pApplet, f, f2);
        this.setWidth(n);
        this.setHeight(n2);
        this.registerAutos_DMPK(true, true, true, false);
        this.createEventHandler(this._app, "handleSliderEvents", new Class[]{GSlider.class});
    }

    public void setLimits(int n, int n2, int n3) {
        this.minValue = Math.min(n2, n3);
        this.maxValue = Math.max(n2, n3);
        this.init = Math.round(PApplet.constrain((float)n, this.minValue, this.maxValue));
        if ((float)(this.thumbMax - this.thumbMin) < this.maxValue - this.minValue && G4P.messages) {
            System.out.println(this.getClass().getSimpleName() + ".setLimits");
            System.out.println("  not all values in the range " + n2 + " - " + n3 + " can be returned");
            System.out.print("  either reduce the range or make the slider ");
            if (this.getClass().getSimpleName().equals("GHorzSlider")) {
                System.out.print("width");
            } else {
                System.out.print("height");
            }
            System.out.println(" at least " + (n3 - n2 + this.thumbSize));
        }
        this.thumbTargetPos = this.thumbPos;
        this.setValue(n, true);
    }

    public void setLimits(float f, float f2, float f3) {
        this.minValue = Math.min(f2, f3);
        this.maxValue = Math.max(f2, f3);
        this.init = PApplet.constrain(f, this.minValue, this.maxValue);
        this.thumbTargetPos = this.thumbPos;
        this.setValue(this.init, true);
    }

    @Override
    public void pre() {
        int n = this.thumbInertia;
        if (this.thumbPos == this.thumbTargetPos) {
            this.isValueChanging = false;
        } else {
            int n2;
            while ((n2 = (this.thumbTargetPos - this.thumbPos) / n) == 0 && --n > 0) {
            }
            if (n2 != 0) {
                this.thumbPos += n2;
                float f = PApplet.map(this.thumbPos, this.thumbMin, this.thumbMax, this.minValue, this.maxValue);
                boolean bl = f != this.value;
                this.value = f;
                if (bl) {
                    this.eventType = 257;
                    this.fireEvent();
                }
            } else {
                this.isValueChanging = false;
            }
        }
    }

    @Override
    public void draw() {
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
    }

    @Override
    public boolean isOver(int n, int n2) {
        return false;
    }

    public int getMinValue() {
        return Math.round(this.minValue);
    }

    public int getMaxValue() {
        return Math.round(this.maxValue);
    }

    public int getValue() {
        return Math.round(this.value);
    }

    public float getValuef() {
        if (this._valueType == 0) {
            return Math.round(this.value);
        }
        return this.value;
    }

    public boolean isValueChanging() {
        return this.isValueChanging;
    }

    public void setValue(int n) {
        this.value = PApplet.constrain((float)n, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
    }

    public void setValue(float f) {
        this.value = PApplet.constrain(f, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
    }

    public void setValue(int n, boolean bl) {
        this.setValue(n);
        if (bl) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setValue(float f, boolean bl) {
        this.setValue(f);
        if (bl) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setInertia(int n) {
        this.thumbInertia = PApplet.constrain(n, 1, 100);
    }
}

