/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import core.ScreenElement;
import guicomponents.G4P;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GHorzSlider
extends GSlider {
    public GHorzSlider(ScreenElement screenElement, PApplet pApplet, int n, int n2, int n3, int n4) {
        super(screenElement, pApplet, n, n2, n3, n4);
        this.initThumbDetails();
    }

    protected void initThumbDetails() {
        this.thumbSize = Math.max(20, this.getWidth() / 20);
        this.thumbMin = this.thumbSize / 2;
        this.thumbMax = this.getWidth() - this.thumbSize / 2;
        this.thumbTargetPos = this.thumbPos;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        float f = this.getHeight();
        float f2 = this.getWidth();
        this._app.pushStyle();
        this._app.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        this._app.noStroke();
        this._app.fill(this.localColor.sdrTrack);
        this._app.rect(point.x, point.y, f2, f);
        this._app.fill(this.localColor.sdrThumb);
        this._app.rect(point.x + this.thumbPos - this.thumbSize / 2, point.y, this.thumbSize, f);
        if (this.border != 0) {
            this._app.strokeWeight(this.border);
            this._app.noFill();
            this._app.stroke(this.localColor.sdrBorder);
            this._app.rect(point.x, point.y, f2, f);
        }
        this._app.popStyle();
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this._app.mouseX, this._app.mouseY);
        if (bl || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl) break;
                this.mdx = this._app.mouseX;
                this.mdy = this._app.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this._app.mouseX, this._app.mouseY)) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.isValueChanging = true;
                Point point = new Point(0, 0);
                this.calcAbsPosition(point);
                this.thumbTargetPos = PApplet.constrain(this._app.mouseX - this.offset - point.x, this.thumbMin, this.thumbMax);
            }
        }
    }

    @Override
    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (n >= point.x + this.thumbPos - this.thumbSize / 2 && n <= point.x + this.thumbPos + this.thumbSize / 2 && n2 >= point.y && n2 <= point.y + this.getHeight()) {
            this.offset = n - (point.x + this.thumbPos);
            return true;
        }
        return false;
    }
}

