/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import core.language.Language;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PFont;

public class GFont {
    private static final HashMap<GFontKey, PFont> fontmap = new HashMap();

    public static PFont getFont(PApplet pApplet, String string, int n) {
        PFont pFont = null;
        if (string.endsWith(".vlw")) {
            pFont = pApplet.loadFont(string);
        } else {
            GFontKey gFontKey = new GFontKey(string, n = PApplet.constrain(n, 8, 144));
            if (fontmap.containsKey(gFontKey)) {
                pFont = fontmap.get(gFontKey);
            } else {
                pFont = Language.getCharacterSet().length == 0 ? pApplet.createFont(string, n, true) : pApplet.createFont(string, n, true, Language.getCharacterSet());
                if (pFont != null) {
                    fontmap.put(gFontKey, pFont);
                } else {
                    gFontKey = new GFontKey("SansSerif", n);
                    if (fontmap.containsKey(gFontKey)) {
                        pFont = fontmap.get(gFontKey);
                    } else {
                        pFont = Language.getCharacterSet().length == 0 ? pApplet.createFont("SansSerif", n, true) : pApplet.createFont("SansSerif", n, true, Language.getCharacterSet());
                        fontmap.put(gFontKey, pFont);
                    }
                }
            }
        }
        return pFont;
    }

    public static PFont getDefaultFont(PApplet pApplet) {
        return GFont.getFont(pApplet, "SansSerif", 11);
    }

    private static class GFontKey
    implements Comparable {
        private final String fontKey;

        public GFontKey(String string, int n) {
            this.fontKey = string + "-" + n;
        }

        public boolean equals(Object object) {
            GFontKey gFontKey = (GFontKey)object;
            if (gFontKey == null) {
                return false;
            }
            return this.fontKey.equals(gFontKey.fontKey);
        }

        public int hashCode() {
            return this.fontKey.hashCode();
        }

        public int compareTo(Object object) {
            GFontKey gFontKey = (GFontKey)object;
            if (gFontKey == null) {
                return 1;
            }
            return this.fontKey.compareTo(gFontKey.fontKey);
        }
    }
}

