/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import core.ScreenElement;
import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GConstants;
import guicomponents.GFont;
import guicomponents.GMessenger;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PVector;

public abstract class GComponent
extends ScreenElement
implements PConstants,
GConstants,
Comparable {
    protected static GComponent focusIsWith;
    protected static GComponent cursorIsOver;
    protected int mdx = Integer.MAX_VALUE;
    protected int mdy = Integer.MAX_VALUE;
    public static GCScheme globalColor;
    public GCScheme localColor;
    public static PFont globalFont;
    public PFont localFont;
    protected static final int PADH = 4;
    protected static final int PADV = 2;
    protected HashSet<GComponent> children;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    protected String text = "";
    protected int textWidth;
    protected int textAlignHorz = 1;
    protected int textAlignVert = 64;
    protected int alignX = 0;
    protected int alignY = 0;
    protected int minWidth = 20;
    protected int minHeight = 20;
    protected int maxWidth = 200;
    protected int maxHeight = 200;
    public String tag;
    public int tagNo;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected int border = 0;
    protected boolean opaque = true;
    public int eventType = 0;
    protected boolean regDraw = false;
    protected boolean regMouse = false;
    protected boolean regPre = false;
    protected boolean regKey = false;
    private ArrayList<MouseEvent> _mEvents = new ArrayList();

    public GComponent(ScreenElement screenElement, PApplet pApplet, float f, float f2) {
        super(screenElement, pApplet);
        this._app = pApplet;
        if (globalColor == null) {
            globalColor = GCScheme.getColor(pApplet);
        }
        this.localColor = new GCScheme(globalColor);
        if (globalFont == null) {
            globalFont = GFont.getDefaultFont(pApplet);
        }
        this.localFont = globalFont;
        this.setRelativePosition(f, f2);
        G4P.setMainApp(this._app);
        G4P.addComponent(this);
    }

    protected void createEventHandler(Object object, String string, Class[] classArray) {
        try {
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
        }
        catch (Exception exception) {
            GMessenger.message(0x1000001, this, new Object[]{string, classArray});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object object, String string) {
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, this.getClass());
        }
        catch (Exception exception) {
            GMessenger.message(0x1000002, this, new Object[]{string, new Class[]{this.getClass()}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    public void addEventHandler(Object object, String string, Class[] classArray) {
        if (classArray == null) {
            classArray = new Class[]{};
        }
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
        }
        catch (Exception exception) {
            GMessenger.message(0x1000002, this.eventHandlerObject, new Object[]{string, classArray});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this);
            }
            catch (Exception exception) {
                GMessenger.message(-2130706429, this.eventHandlerObject, new Object[]{this.eventHandlerMethodName, exception});
            }
        }
    }

    public PApplet getPApplet() {
        return this._app;
    }

    protected void takeFocus() {
        if (focusIsWith != null && focusIsWith != this) {
            focusIsWith.loseFocus(this);
        }
        focusIsWith = this;
    }

    protected void loseFocus(GComponent gComponent) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = null;
    }

    public void setFocus(boolean bl) {
        if (bl) {
            this.takeFocus();
        } else {
            this.loseFocus(null);
        }
    }

    public boolean hasFocus() {
        return this == focusIsWith;
    }

    public static ScreenElement getFocusObject() {
        return focusIsWith;
    }

    public int getEventType() {
        return this.eventType;
    }

    protected boolean mouseHasMoved(int n, int n2) {
        return this.mdx != n || this.mdy != n2;
    }

    public boolean add(GComponent gComponent) {
        if (gComponent == null || this.children.contains(gComponent)) {
            if (G4P.messages) {
                System.out.println("Either the component doesn't exist or has already been added to this panel");
            }
            return false;
        }
        gComponent.setParent(this);
        this.children.add(gComponent);
        this._app.unregisterDraw(gComponent);
        gComponent.regDraw = false;
        if (this.localColor.getAlpha() < 255) {
            gComponent.setAlpha(this.localColor.getAlpha());
        }
        return true;
    }

    public void remove(GComponent gComponent) {
        this.children.remove(gComponent);
    }

    public void pre() {
    }

    public void draw() {
    }

    @Override
    public void update(float f) {
        for (MouseEvent mouseEvent : this._mEvents) {
            this.handleMouseEvent(mouseEvent);
        }
        this._mEvents.clear();
    }

    @Override
    public void render() {
        this.draw();
    }

    public final void mouseEvent(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this._mEvents.add(mouseEvent);
        }
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    protected void registerAutos_DMPK(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            this._app.registerMouseEvent(this);
            this.regMouse = true;
        }
        if (bl3) {
            this._app.registerPre(this);
            this.regPre = true;
        }
        if (bl4) {
            this._app.registerKeyEvent(this);
            this.regKey = true;
        }
    }

    public void changeWindow(PApplet pApplet) {
        if (this.regDraw) {
            this._app.unregisterDraw(this);
            pApplet.registerDraw(this);
        }
        if (this.regPre) {
            this._app.unregisterPre(this);
            pApplet.registerPre(this);
        }
        if (this.regMouse) {
            this._app.unregisterMouseEvent(this);
            pApplet.registerMouseEvent(this);
        }
        if (this.regKey) {
            this._app.unregisterKeyEvent(this);
            pApplet.registerKeyEvent(this);
        }
        this._app = pApplet;
        if (this.children != null && !this.children.isEmpty()) {
            Iterator<GComponent> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                iterator.next().changeWindow(pApplet);
            }
        }
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        return n >= point.x && n <= point.x + this.getWidth() && n2 >= point.y && n2 <= point.y + this.getHeight();
    }

    public void calcAbsPosition(Point point) {
        if (this.getParent() != null) {
            PVector pVector = this.getParent().getAbsolutePosition();
            point.x = (int)((float)point.x + pVector.x);
            point.y = (int)((float)point.y + pVector.y);
        }
        point.x = (int)((float)point.x + (this.getPosition().x - this.getOriginX() * (float)this.getWidth()));
        point.y = (int)((float)point.y + (this.getPosition().y - this.getOriginY() * (float)this.getHeight()));
    }

    public void setColorScheme(int n) {
        this.localColor = GCScheme.getColor(this._app, n);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this._app.textFont(this.localFont, this.localFont.size);
        this.textWidth = (int)this._app.textWidth(string);
        this.calcAlignX();
        this.calcAlignY();
    }

    public void setText(String string, int n) {
        this.text = string;
        this._app.textFont(this.localFont, this.localFont.getFont().getSize());
        this.textWidth = (int)this._app.textWidth(string);
        this.setTextAlign(n);
    }

    public void setTextAlign(int n) {
        int n2 = n & 7;
        int n3 = n & 0x70;
        if (n2 == 1 || n2 == 4 || n2 == 2) {
            this.textAlignHorz = n2;
            this.calcAlignX();
        }
        if (n3 == 16 || n3 == 64 || n3 == 32) {
            this.textAlignVert = n3;
            this.calcAlignY();
        }
    }

    public void setFont(String string, int n) {
    }

    protected void calcAlignX() {
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = this.border + 4;
                break;
            }
            case 2: {
                this.alignX = this.getWidth() - this.textWidth - this.border - 4;
                break;
            }
            case 4: {
                this.alignX = (this.getWidth() - this.textWidth) / 2;
            }
        }
    }

    protected void calcAlignY() {
        switch (this.textAlignVert) {
            case 16: {
                this.alignY = this.border + 2;
                break;
            }
            case 32: {
                this.alignY = this.getHeight() - this.localFont.getFont().getSize() - this.border - 2;
                break;
            }
            case 64: {
                this.alignY = (this.getHeight() - this.localFont.size - this.border - 2) / 2;
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBorder(int n) {
        this.border = n;
        this.calcAlignX();
    }

    public int getBorder() {
        return this.border;
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public boolean getOpaque() {
        return this.opaque;
    }

    public void setAlpha(int n) {
        this.localColor.setAlpha(n);
    }

    public int getAlpha() {
        return this.localColor.getAlpha();
    }

    public int compareTo(Object object) {
        return new Integer(this.hashCode()).compareTo(new Integer(object.hashCode()));
    }
}

