/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import core.ScreenElement;
import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GFont;
import guicomponents.GOption;
import guicomponents.GOptionGroup;
import guicomponents.GVertSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import processing.core.PApplet;
import processing.core.PImage;

public class GCombo
extends GComponent {
    protected static PImage imgArrow;
    protected int startRow;
    protected int maxRows = 5;
    protected int nbrRowsToShow;
    protected GOptionGroup optGroup;
    protected GVertSlider slider;
    protected boolean expanded = false;

    public GCombo(ScreenElement screenElement, PApplet pApplet, String[] stringArray, int n, int n2, int n3, int n4) {
        super(screenElement, pApplet, n2, n3);
        this.maxRows = PApplet.constrain(n, 1, 25);
        this.comboCtorCore(n4);
        this.createOptions(stringArray);
        this.createSlider();
    }

    private void comboCtorCore(int n) {
        this.children = new HashSet();
        if (imgArrow == null) {
            imgArrow = this._app.loadImage("combo0.png");
        }
        this.setWidth(n);
        this.setHeight(Math.max(this.localFont.getFont().getSize() + 4, GCombo.imgArrow.height));
        this.opaque = true;
        this.border = 1;
        this.createEventHandler(this._app, "handleComboEvents", new Class[]{GCombo.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    private void createSlider() {
        this.slider = new GVertSlider(this.getParent(), this._app, this.getWidth() - 10, this.getHeight(), 10, this.maxRows * this.getHeight());
        this.slider.setBorder(1);
        this.slider.setVisible(false);
        this.slider.setLimits(0, 0, this.maxRows - 1);
        this.slider.addEventHandler(this, "processSliderMotion", new Class[]{GVertSlider.class});
        this.add(this.slider);
    }

    private void createOptions(String[] stringArray) {
        this.optGroup = new GOptionGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            GOption gOption = this.makeOption(stringArray[i]);
            if (gOption == null) continue;
            this.optGroup.addOption(gOption);
            this.add(gOption);
        }
        this.optGroup.setSelected(0);
        this.text = this.optGroup.selectedText();
        this.nbrRowsToShow = Math.min(stringArray.length, this.maxRows);
    }

    public GOption makeOption(String string) {
        GOption gOption = null;
        if (string != null && !string.equals("")) {
            gOption = new GOption(this.getParent(), this._app, string, 0, 0, this.getWidth() - 10);
            gOption.addEventHandler(this, "processOptionSelection");
            gOption.setVisible(false);
            gOption.setOpaque(true);
            gOption.setBorder(0);
        }
        return gOption;
    }

    @Override
    public void setFont(String string, int n) {
        int n2 = this.textWidth;
        int n3 = this.localFont.getFont().getSize();
        this.localFont = GFont.getFont(this._app, string, n);
        if (n > n3) {
            this.setHeight(this.getHeight() + (n - n3));
        }
        this.setText(this.text);
        if (this.textWidth > n2) {
            this.setWidth(this.getWidth() + (this.textWidth - n2));
        }
        ArrayList<GOption> arrayList = this.optGroup.getOptions();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).setWidth(this.getWidth() - 10);
        }
        this.slider.setX(this.getWidth() - 10);
    }

    @Override
    public void setColorScheme(int n) {
        this.localColor = GCScheme.getColor(this._app, n);
        this.slider.localColor = GCScheme.getColor(this._app, n);
        ArrayList<GOption> arrayList = this.optGroup.getOptions();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get((int)i).localColor = GCScheme.getColor(this._app, n);
        }
    }

    public void processSliderMotion(GVertSlider gVertSlider) {
        this.startRow = this.slider.getValue();
    }

    public void processOptionSelection(GOption gOption, GOption gOption2) {
        this.text = this.optGroup.selectedText();
        if (gOption != gOption2) {
            this.fireEvent();
        }
        this.shrink();
        this.loseFocus(null);
    }

    public void setSelected(int n) {
        this.optGroup.setSelected(n);
        this.setText(this.optGroup.selectedText());
    }

    public void setSelected(String string) {
        this.optGroup.setSelected(string);
        this.setText(this.optGroup.selectedText());
    }

    public boolean addOption(String string) {
        GOption gOption = this.makeOption(string);
        boolean bl = this.optGroup.addOption(gOption);
        if (bl) {
            this.add(gOption);
        }
        return bl;
    }

    public boolean addOption(int n, String string) {
        GOption gOption = this.makeOption(string);
        boolean bl = this.optGroup.addOption(n, gOption);
        if (bl) {
            this.add(gOption);
        }
        return bl;
    }

    public void removeOption(int n) {
        GOption gOption = this.optGroup.removeOption(n);
        if (gOption != null) {
            this.remove(gOption);
        }
    }

    public void removeOption(String string) {
        GOption gOption = this.optGroup.removeOption(string);
        if (gOption != null) {
            this.remove(gOption);
        }
    }

    @Override
    public boolean isOver(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (this.expanded) {
            n6 = point.x;
            n5 = point.y;
            n4 = n6 + this.getWidth();
            n3 = n5 + (this.nbrRowsToShow + 1) * this.getHeight();
        } else {
            n6 = point.x + this.getWidth() - GCombo.imgArrow.width - 4;
            n5 = point.y + (this.getHeight() - GCombo.imgArrow.height) / 2 + 2;
            n4 = n6 + GCombo.imgArrow.width;
            n3 = n5 + GCombo.imgArrow.height;
        }
        return n >= n6 && n <= n4 && n2 >= n5 && n2 <= n3;
    }

    public void shrink() {
        this.expanded = false;
        for (int i = 0; i < this.optGroup.size(); ++i) {
            this.optGroup.get((int)i).visible = false;
        }
        this.slider.visible = false;
    }

    public void expand() {
        this.expanded = true;
        this.startRow = 0;
        this.slider.setLimits(0, 0, this.optGroup.size() - this.maxRows);
        this.takeFocus();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void loseFocus(GComponent gComponent) {
        if (!this.children.contains(gComponent)) {
            this.shrink();
            focusIsWith = null;
        }
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this._app.mouseX, this._app.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith != this && bl) {
                    this.takeFocus();
                    break;
                }
                if (focusIsWith != this || this.isOver(this._app.mouseX, this._app.mouseY)) break;
                this.loseFocus(null);
                break;
            }
            case 500: {
                if (focusIsWith != this || !this.isOver(this._app.mouseX, this._app.mouseY)) break;
                if (this.expanded) {
                    this.shrink();
                } else {
                    this.expand();
                }
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        float f = this.getHeight();
        float f2 = this.getWidth();
        this._app.pushStyle();
        this._app.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (this.border == 0) {
            this._app.noStroke();
        } else {
            this._app.strokeWeight(this.border);
            this._app.stroke(this.localColor.txfBorder);
        }
        if (this.opaque) {
            this._app.fill(this.localColor.txfBack);
        } else {
            this._app.noFill();
        }
        this._app.rect(point.x, point.y, f2, f);
        this._app.noStroke();
        this._app.fill(this.localColor.txfFont);
        this._app.textFont(this.localFont, this.localFont.getFont().getSize());
        this._app.text(this.text, (float)(point.x + 4), (float)(point.y - 2) + (f - (float)this.localFont.getFont().getSize()) / 2.0f, f2 - 16.0f, f);
        this._app.fill(this._app.color(255, 255));
        this._app.image(imgArrow, (float)point.x + f2 - (float)GCombo.imgArrow.width - 1.0f, (float)point.y + (f - (float)GCombo.imgArrow.height) / 2.0f);
        if (this.expanded) {
            this._app.noStroke();
            this._app.fill(this.localColor.txfBack);
            this._app.rect(point.x, (float)point.y + f, f2, (float)this.nbrRowsToShow * f);
            for (int i = 0; i < this.optGroup.size(); ++i) {
                GOption gOption = this.optGroup.get(i);
                if (i >= this.startRow && i < this.startRow + this.nbrRowsToShow) {
                    gOption.visible = true;
                    gOption.setY(f * (float)(i - this.startRow + 1));
                    gOption.draw();
                    continue;
                }
                gOption.visible = false;
            }
            if (this.border != 0) {
                this._app.strokeWeight(this.border);
                this._app.stroke(this.localColor.txfBorder);
                this._app.noFill();
                this._app.rect(point.x, (float)point.y + f, f2, (float)this.nbrRowsToShow * f);
            }
            if (this.optGroup.size() > this.maxRows) {
                this.slider.setVisible(true);
                this.slider.draw();
            }
        }
        this._app.popStyle();
    }

    public int selectedIndex() {
        return this.optGroup.selectedIndex();
    }

    public String selectedText() {
        return this.optGroup.selectedText();
    }

    public int deselectedIndex() {
        return this.optGroup.deselectedIndex();
    }

    public String deselectedText() {
        return this.optGroup.deselectedText();
    }
}

