/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import core.ScreenElement;
import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GCheckbox
extends GComponent {
    protected boolean selected;
    protected static PImage imgSelected;
    protected static PImage imgCleared;

    public GCheckbox(ScreenElement screenElement, PApplet pApplet, String string, int n, int n2, int n3) {
        super(screenElement, pApplet, n, n2);
        this.checkboxCtorCore(string, n3);
    }

    private void checkboxCtorCore(String string, int n) {
        if (imgSelected == null) {
            imgSelected = this._app.loadImage("check1.png");
        }
        if (imgCleared == null) {
            imgCleared = this._app.loadImage("check0.png");
        }
        this.setWidth(n);
        this.setHeight(Math.max(this.localFont.getFont().getSize() + 4, GCheckbox.imgCleared.height));
        this.opaque = false;
        this.setText(string);
        this.createEventHandler(this._app, "handleCheckboxEvents", new Class[]{GCheckbox.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    @Override
    public void setFont(String string, int n) {
        int n2 = this.textWidth;
        int n3 = this.localFont.getFont().getSize();
        this.localFont = GFont.getFont(this._app, string, n);
        if (n != n3) {
            this.setHeight(this.getHeight() + (n - n3));
        }
        this.setText(this.text);
        if (this.textWidth > n2) {
            this.setWidth(this.getWidth() + (this.textWidth - n2));
        }
    }

    @Override
    protected void calcAlignX() {
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = GCheckbox.imgSelected.width + 2 * this.border + 4;
                break;
            }
            case 2: {
                this.alignX = this.getWidth() - this.textWidth - 2 * this.border - 4;
                break;
            }
            case 4: {
                this.alignX = GCheckbox.imgSelected.width + (this.getWidth() - GCheckbox.imgSelected.width - this.textWidth) / 2;
            }
        }
    }

    @Override
    public void draw() {
        float f = this.getHeight();
        float f2 = this.getWidth();
        if (!this.visible) {
            return;
        }
        this._app.pushStyle();
        this._app.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (!this.text.equals("")) {
            if (this.border != 0) {
                this._app.strokeWeight(this.border);
                this._app.stroke(this.localColor.cbxBorder);
            } else {
                this._app.noStroke();
            }
            if (this.opaque) {
                this._app.fill(this.localColor.cbxBack);
            } else {
                this._app.noFill();
            }
            this._app.rect(point.x, point.y, f2, f);
            this._app.noStroke();
            this._app.fill(this.localColor.cbxFont);
            this._app.textFont(this.localFont, this.localFont.getFont().getSize());
            this._app.text(this.text, (float)(point.x + this.alignX), (float)point.y + (f - (float)this.localFont.getFont().getSize()) / 2.0f - 2.0f, (float)this.textWidth, f);
        }
        this._app.fill(this._app.color(255, 255));
        if (this.selected) {
            this._app.image(imgSelected, point.x, (float)point.y + (f - (float)GCheckbox.imgSelected.height) / 2.0f);
        } else {
            this._app.image(imgCleared, point.x, (float)point.y + (f - (float)GCheckbox.imgSelected.height) / 2.0f);
        }
        this._app.popStyle();
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this._app.mouseX, this._app.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl) break;
                this.mdx = this._app.mouseX;
                this.mdy = this._app.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.selected = !this.selected;
                this.eventType = this.selected ? 1025 : 1026;
                this.fireEvent();
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this._app.mouseX, this._app.mouseY)) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }
}

