/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GConstants;
import guicomponents.GCursorImageChanger;
import guicomponents.GFont;
import guicomponents.GMessenger;
import guicomponents.GWindow;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PStyle;

public class G4P
implements PConstants,
GConstants {
    private static HashSet<GComponent> allComponents = new HashSet();
    private static HashSet<GWindow> allWinApps = new HashSet();
    private static HashSet<PApplet> autoDrawDisabled = new HashSet();
    public static PApplet mainWinApp = null;
    public static PStyle g4pStyle = null;
    public static boolean messages = false;
    private static GCursorImageChanger mcd = new GCursorImageChanger();
    public static boolean overControl = false;
    public static boolean cursorChangeEnabled = false;
    public static int mouseOff = 0;
    public static int mouseOver = 12;
    private static final int PCAM_AVAILABLE = 0;
    private static final int PCAM_UNAVAILABLE = 1;
    private static final int PCAM_UNINITIALISED = 2;
    private static Object peasyCam;
    private static Method beginHud;
    private static Method endHud;
    private static int camStatus;

    public static void setMouseOverEnabled(boolean bl) {
        cursorChangeEnabled = bl;
        if (!cursorChangeEnabled) {
            mainWinApp.cursor(mouseOff);
            Iterator<GWindow> iterator = allWinApps.iterator();
            while (iterator.hasNext()) {
                iterator.next().papplet.cursor(mouseOff);
            }
        }
    }

    public static void cursor(int n, int n2) {
        mouseOff = n;
        mouseOver = n2;
    }

    public static void cursor(int n) {
        mouseOver = n;
    }

    public static void addComponent(GComponent gComponent) {
        if (g4pStyle == null) {
            G4P.getStyle();
        }
        if (allComponents.contains(gComponent)) {
            GMessenger.message(65793, gComponent, null);
        } else {
            allComponents.add(gComponent);
        }
    }

    public static void setMainApp(PApplet pApplet) {
        if (mainWinApp == null) {
            mainWinApp = pApplet;
            mainWinApp.registerPost(mcd);
        }
    }

    public static void addWindow(GWindow gWindow) {
        allWinApps.add(gWindow);
    }

    public static void removeWindow(GWindow gWindow) {
        allWinApps.remove(gWindow);
    }

    public static boolean isWindowActive(GWindow gWindow) {
        return allWinApps.contains(gWindow);
    }

    private static void getStyle() {
        PGraphics pGraphics = new PGraphics();
        g4pStyle = pGraphics.getStyle();
        G4P.g4pStyle.rectMode = 0;
        G4P.g4pStyle.ellipseMode = 3;
        G4P.g4pStyle.imageMode = 0;
        G4P.g4pStyle.shapeMode = 0;
        G4P.g4pStyle.colorMode = 1;
        G4P.g4pStyle.colorModeA = 255.0f;
        G4P.g4pStyle.colorModeX = 255.0f;
        G4P.g4pStyle.colorModeY = 255.0f;
        G4P.g4pStyle.colorModeZ = 255.0f;
    }

    public static void setTextMode(int n) {
        if (n == 4 || n == 256 || n == 5) {
            if (g4pStyle == null) {
                PGraphics pGraphics = new PGraphics();
                g4pStyle = pGraphics.getStyle();
            }
            G4P.g4pStyle.textMode = n;
        }
    }

    public static void setColorScheme(PApplet pApplet, int n) {
        if (pApplet != null) {
            G4P.setMainApp(pApplet);
        } else if (mainWinApp == null) {
            return;
        }
        GComponent.globalColor = GCScheme.getColor(mainWinApp, n);
    }

    public static void setFont(PApplet pApplet, String string, int n) {
        if (pApplet != null) {
            G4P.setMainApp(pApplet);
        } else if (mainWinApp == null) {
            return;
        }
        GComponent.globalFont = GFont.getFont(mainWinApp, string, n);
    }

    public static boolean setPeasyCam(Object object) {
        camStatus = 1;
        if (!object.getClass().getSimpleName().equals("PeasyCam")) {
            GMessenger.message(-2113929215, object, null);
            return false;
        }
        try {
            beginHud = object.getClass().getMethod("beginHUD", null);
            endHud = object.getClass().getMethod("endHUD", null);
            peasyCam = object;
            camStatus = 0;
            return true;
        }
        catch (Exception exception) {
            GMessenger.message(-2113929214, null, null);
            camStatus = 1;
            return false;
        }
    }

    public static void draw() {
        if (camStatus != 0) {
            G4P.draw(mainWinApp);
        } else {
            try {
                beginHud.invoke(peasyCam, (Object[])null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            G4P.draw(mainWinApp);
            try {
                endHud.invoke(peasyCam, (Object[])null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void draw(PApplet pApplet) {
        if (allComponents.size() > 0) {
            if (!autoDrawDisabled.contains(pApplet)) {
                G4P.unregisterFromPAppletDraw(pApplet);
            }
            pApplet.hint(4);
            for (GComponent gComponent : allComponents) {
                if (gComponent.getParent() != null || gComponent.getPApplet() != pApplet) continue;
                gComponent.draw();
            }
            pApplet.hint(-4);
        }
    }

    private static void unregisterFromPAppletDraw(PApplet pApplet) {
        for (GComponent gComponent : allComponents) {
            if (gComponent.getParent() != null || gComponent.getPApplet() != pApplet) continue;
            gComponent.regDraw = false;
            gComponent.getPApplet().unregisterDraw(gComponent);
        }
        autoDrawDisabled.add(pApplet);
    }

    public static void disableAutoDraw() {
        G4P.unregisterFromPAppletDraw(mainWinApp);
        GMessenger.message(65795, null, null);
    }

    public static boolean isAutoDrawOn() {
        return G4P.isAutoDrawOn(mainWinApp);
    }

    public static boolean isAutoDrawOn(PApplet pApplet) {
        return !autoDrawDisabled.contains(pApplet);
    }

    public static void messagesEnabled(boolean bl) {
        messages = bl;
    }

    static {
        camStatus = 2;
    }
}

