/*
 * Decompiled with CFR 0.152.
 */
package game.variables;

import game.noisemodels.GravityGradientNoise;
import game.noisemodels.MirrorThermalNoise;
import game.noisemodels.RadiationPressureNoise;
import game.noisemodels.ResidualGas;
import game.noisemodels.SeismicNoise;
import game.noisemodels.ShotNoise;

public final class ScoreCalculator {
    private static final double Mpow = Math.pow(1.28076E-5, 0.8333333333333334);
    private static final double K = 4.0E-14 * Math.sqrt(0.0520833320915699) * Mpow / (18.08 * Math.pow(3.1415927410125732, 0.6666666666666666));
    private static final double f_1 = 1.0;
    private static final double f_2 = 10000.0;
    private static final double df = 0.1;
    private static final MirrorThermalNoise mtNoise = new MirrorThermalNoise();
    private static final RadiationPressureNoise rpNoise = new RadiationPressureNoise();
    private static final SeismicNoise sNoise = new SeismicNoise();
    private static final ShotNoise shNoise = new ShotNoise();
    private static final ResidualGas gasNoise = new ResidualGas();
    private static final GravityGradientNoise ggNoise = new GravityGradientNoise();

    public static final Double getDetectorDistance() {
        return K * ScoreCalculator.calcSensitivityIntegral();
    }

    private static final double SensitivityLine(double d) {
        return Math.sqrt(gasNoise.computePoint(d, 0) * gasNoise.computePoint(d, 0) + mtNoise.computePoint(d, 0) * mtNoise.computePoint(d, 0) + rpNoise.computePoint(d, 0) * rpNoise.computePoint(d, 0) + sNoise.computePoint(d, 0) * sNoise.computePoint(d, 0) + shNoise.computePoint(d, 0) * shNoise.computePoint(d, 0) + ggNoise.computePoint(d, 0) * ggNoise.computePoint(d, 0));
    }

    public static final double calcSensitivityIntegral() {
        int n = 99990;
        double d = 0.0;
        double d2 = Math.pow(1.0, -2.3333332538604736) / ScoreCalculator.SensitivityLine(1.0);
        for (int i = 1; i <= n; ++i) {
            double d3 = 1.0 + (double)i * 0.1;
            double d4 = Math.pow(d3, -2.3333332538604736) / ScoreCalculator.SensitivityLine(d3);
            d += 0.1 * (d4 + d2) * 0.5;
            d2 = d4;
        }
        return d;
    }
}

