/*
 * Decompiled with CFR 0.152.
 */
package game.variables;

import core.language.Language;
import game.variables.EnvironmentSystemVariables;
import game.variables.SuspensionVariables;
import utils.Interpolator;

public final class OpticsVariables {
    public static float LaserPower = 0.0f;
    public static float MaxLaserPower = 200.0f;
    public static float Maxmirror_SurfQ = 500.0f;
    public static float mirror_SurfQ = 500.0f;
    public static float MirSurfQ_losses = -mirror_SurfQ / 499.0f * 0.9f + 1.0018036f;
    public static double MirMat_losses = 0.4;
    public static String mirror_material = Language.getString("Fused_Silica");
    private static final double[] _fused_silicaLoss_x = new double[]{1.0, 35.0, 90.0, 150.0, 200.0, 250.0, 300.0};
    private static final double[] _fused_silicayLoss_y = new double[]{0.001, 7.0E-4, 1.0E-4, 3.0E-6, 3.0E-7, 1.5E-7, 1.5E-7};
    private static final double[] _siliconLoss_x = new double[]{1.0, 32.0, 40.0, 270.0, 300.0};
    private static final double[] _siliconLoss_y = new double[]{1.4E-9, 1.5E-8, 7.5E-9, 4.5E-8, 7.0E-8};
    private static final double[] _glassLoss_x = new double[]{1.0, 300.0};
    private static final double[] _glassLoss_y = new double[]{0.001, 0.001};
    private static final double[] _sapphireLoss_x = new double[]{1.0, 25.0, 80.0, 105.0, 230.0, 300.0};
    private static final double[] _sapphireLoss_y = new double[]{1.4E-9, 2.5E-8, 7.0E-9, 1.2E-8, 1.6E-8, 1.0E-7};

    public static final int getLaserCosts() {
        if (LaserPower == 0.0f) {
            return 0;
        }
        return (int)Math.round(47000.0 + 2.5E7 * (double)LaserPower * (double)LaserPower / (double)MaxLaserPower / (double)MaxLaserPower);
    }

    public static final int getSurfCosts() {
        return (int)Math.round(Math.pow(SuspensionVariables.PendMass, 0.6666666865348816) * (Math.pow(MirSurfQ_losses, 3.0) / 25.0 * 8.0E7 - Math.pow(-Maxmirror_SurfQ / 499.0f * 0.9f + 1.0018036f, 3.0) / 25.0 * 8.0E7));
    }

    public static final int getMirMatCosts() {
        double d = 0.0;
        if (mirror_material == "") {
            return 0;
        }
        if (mirror_material.equalsIgnoreCase(Language.getString("Fused_Silica"))) {
            d = 1500000.0 + 2.85E7 * Math.pow(SuspensionVariables.PendMass / 100.0f, 2.0);
        } else if (mirror_material.equalsIgnoreCase(Language.getString("Silicon"))) {
            d = 2000000.0 + 3.8E7 * Math.pow(SuspensionVariables.PendMass / 100.0f, 2.0);
        } else if (mirror_material.equalsIgnoreCase(Language.getString("Glass"))) {
            d = 500000.0 + 9500000.0 * Math.pow(SuspensionVariables.PendMass / 100.0f, 2.0);
        } else if (mirror_material.equalsIgnoreCase(Language.getString("Sapphire"))) {
            d = 4000000.0 + 1.2E8 * Math.pow(SuspensionVariables.PendMass / 100.0f, 2.0);
        } else {
            throw new RuntimeException("Material type not valid: " + mirror_material);
        }
        return (int)Math.round(d);
    }

    public static final double getOpticsCosts() {
        return OpticsVariables.getLaserCosts() + OpticsVariables.getSurfCosts() + OpticsVariables.getMirMatCosts();
    }

    public static final int getLaserComplex() {
        return (int)Math.floor(LaserPower / 10.0f);
    }

    public static final int getSurfQComplex() {
        return (int)(1.0 + Math.floor((50.0f - mirror_SurfQ) / 500.0f));
    }

    public static final int getMirMatComplex() {
        return (int)Math.round(MirMat_losses);
    }

    public static final double getMirMatQ() {
        if (mirror_material == Language.getString("Fused_Silica")) {
            return 1.0 / Interpolator.interpLinear(_fused_silicaLoss_x, _fused_silicayLoss_y, new double[]{EnvironmentSystemVariables.getTargetTemperature()})[0];
        }
        if (mirror_material == Language.getString("Silicon")) {
            return 1.0 / Interpolator.interpLinear(_siliconLoss_x, _siliconLoss_y, new double[]{EnvironmentSystemVariables.getTargetTemperature()})[0];
        }
        if (mirror_material == Language.getString("Glass")) {
            return 1.0 / Interpolator.interpLinear(_glassLoss_x, _glassLoss_y, new double[]{EnvironmentSystemVariables.getTargetTemperature()})[0];
        }
        if (mirror_material == Language.getString("Sapphire")) {
            return 1.0 / Interpolator.interpLinear(_sapphireLoss_x, _sapphireLoss_y, new double[]{EnvironmentSystemVariables.getTargetTemperature()})[0];
        }
        throw new RuntimeException("Unknown mirror material");
    }

    public static void reset() {
        LaserPower = 0.0f;
        mirror_SurfQ = 500.0f;
        MirSurfQ_losses = -mirror_SurfQ / 499.0f * 0.9f + 1.0018036f;
        MirMat_losses = 0.4;
        mirror_material = Language.getString("Fused_Silica");
    }
}

