/*
 * Decompiled with CFR 0.152.
 */
package game.variables;

public final class EnvironmentSystemVariables {
    public static int MaxDetectorDepth = 1000;
    public static int DetectorDepth = 0;
    public static double DepthCosts = 0.0;
    public static double DepthComplex = 0.0;
    public static int NumberVacuumPumps = 0;
    public static int MaxVacuumPumps = 16;
    public static double VacuumPumpCost = 850000.0;
    public static int AtmospherePressure = 1013;
    private static int InitAmbientTemperature = 300;
    private static int TempIncPerKm = 30;
    private static float TargetTemperature = 300.0f;
    private static double T_nitrogen = 77.0;
    private static double T_helium = 4.0;
    private static double K0 = 0.0;
    private static double K1 = 20000.0;
    private static double K2 = 300.0;
    public static double CoolingComplex = 0.0;

    public static int getVacuumCosts() {
        return (int)((double)NumberVacuumPumps * VacuumPumpCost);
    }

    public static int getVacuumComplex() {
        return (int)Math.floor((float)NumberVacuumPumps / 10.0f);
    }

    public static float getPressure() {
        return (float)((double)AtmospherePressure * Math.exp(-8.0f * (float)NumberVacuumPumps) + 10.0 * Math.exp(-4.0f * (float)NumberVacuumPumps) + (double)0.001f * Math.exp(-2.0f * (float)NumberVacuumPumps) + (double)1.0E-8f * Math.exp(-0.7f * (float)NumberVacuumPumps) + (double)1.0E-11f * Math.exp(-0.3f * (float)NumberVacuumPumps) + (double)1.0E-16f);
    }

    public static int getAmbientTemperature() {
        return (int)((float)InitAmbientTemperature + (float)DetectorDepth / 1000.0f * (float)TempIncPerKm);
    }

    public static void setTargetTemperature(float f) {
        if (f <= 0.0f) {
            throw new RuntimeException("Target temperature cannot be 0 or below");
        }
        TargetTemperature = f;
    }

    public static float getTargetTemperature() {
        return TargetTemperature;
    }

    public static int getCoolingCosts() {
        if ((double)EnvironmentSystemVariables.getTargetTemperature() > T_nitrogen) {
            K0 = 0.0;
            K1 = 20000.0;
            K2 = 300.0;
        }
        if ((double)EnvironmentSystemVariables.getTargetTemperature() <= T_nitrogen & (double)EnvironmentSystemVariables.getTargetTemperature() > T_helium) {
            K2 = 77.0;
            K1 = 80000.0;
            K0 = 7000000.0;
        }
        if ((double)EnvironmentSystemVariables.getTargetTemperature() <= T_helium) {
            K2 = 4.0;
            K1 = 1500000.0;
            K0 = 1.5E7;
        }
        return (int)(K0 + K1 * (K2 - (double)EnvironmentSystemVariables.getTargetTemperature()));
    }

    public static void reset() {
        InitAmbientTemperature = 300;
        TempIncPerKm = 30;
        TargetTemperature = 300.0f;
        NumberVacuumPumps = 0;
        MaxVacuumPumps = 16;
        VacuumPumpCost = 850000.0;
        AtmospherePressure = 1013;
        MaxDetectorDepth = 1000;
        DetectorDepth = 0;
        DepthCosts = 0.0;
        DepthComplex = 0.0;
    }
}

