/*
 * Decompiled with CFR 0.152.
 */
package game.noisemodels;

import game.PlayerData;
import game.variables.EnvironmentSystemVariables;
import game.variables.IDetectorConstants;
import game.variables.SuspensionVariables;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;

public class SeismicNoise
implements ILine2DEquation,
IDetectorConstants {
    private static final double Q_pend = 5.0;

    public static double getSeismicNoise(double d) {
        double d2 = PlayerData.DetectorSite.X_dc() / (1.0 + Math.pow(d / PlayerData.DetectorSite.f_c(), PlayerData.DetectorSite.n_0()));
        double d3 = 1.0 / Math.sqrt(1.0 + Math.pow(EnvironmentSystemVariables.DetectorDepth / 50, 4.0)) + (double)8.0E-4f;
        double d4 = Math.pow(9.81 / (double)SuspensionVariables.PendLength, 0.5) / 6.2831854820251465;
        double d5 = Math.pow(1.0 + Math.pow(d / d4, 4.0) - 1.8 * Math.pow(d / d4, 2.0), -SuspensionVariables.PendNumber / 2.0f);
        return d2 * 2.0 / 5000.0 * d3 * d5;
    }

    @Override
    public double computePoint(double d, int n) {
        return SeismicNoise.getSeismicNoise(d);
    }
}

