/*
 * Decompiled with CFR 0.152.
 */
package game.noisemodels;

import game.variables.IDetectorConstants;
import game.variables.OpticsVariables;
import game.variables.SuspensionVariables;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;

public class RadiationPressureNoise
implements ILine2DEquation,
IDetectorConstants {
    private static final double K1 = Math.sqrt(1.661818328677766E-33) * 60.0 / 5000.0 / Math.pow(3.1415927410125732, 2.0);
    private static final double K2 = 249.82704833333335;

    public static double getRadiationPressureNoise(double d) {
        return K1 * Math.sqrt(OpticsVariables.LaserPower) / (double)SuspensionVariables.PendMass / d / d / Math.sqrt(1.0 + d * d / 249.82704833333335 / 249.82704833333335) * Math.sqrt(OpticsVariables.MirMat_losses) * Math.sqrt(OpticsVariables.MirSurfQ_losses);
    }

    @Override
    public double computePoint(double d, int n) {
        return RadiationPressureNoise.getRadiationPressureNoise(d);
    }
}

