/*
 * Decompiled with CFR 0.152.
 */
package game.noisemodels;

import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.GLabel;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.noisemodels.GravityGradientNoise;
import game.noisemodels.MirrorThermalNoise;
import game.noisemodels.RadiationPressureNoise;
import game.noisemodels.ResidualGas;
import game.noisemodels.SeismicNoise;
import game.noisemodels.ShotNoise;
import game.noisemodels.SuspThermalNoise;
import game.noisemodels.TotalNoise;
import org.gwoptics.ValueType;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.graph2D.Graph2D;
import org.gwoptics.graphics.graph2D.backgrounds.GridBackground;
import org.gwoptics.graphics.graph2D.traces.Line2DTrace;
import processing.core.PApplet;

public class NoiseModelScreen
extends ScreenElement {
    public Line2DTrace rgTrace;
    public Line2DTrace snTrace;
    public Line2DTrace rpnTrace;
    public Line2DTrace mtnTrace;
    public Line2DTrace stnTrace;
    public Line2DTrace senTrace;
    public Line2DTrace ggTrace;
    public Line2DTrace totalTrace;
    public Graph2D g;
    public KeyFrameAnimation Show;
    public KeyFrameAnimation Hide;
    public ImageElement legend;
    private AudioPlayer swoosh;
    private GLabel _lblshot;
    private GLabel _lblgas;
    private GLabel _lblrad;
    private GLabel _lblmir;
    private GLabel _lblsus;
    private GLabel _lblseis;
    private GLabel _lblgrav;
    private ButtonElement _btnClose;

    public NoiseModelScreen(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.legend = new ImageElement("legend.png", this, pApplet);
        this._btnClose = new ButtonElement(this, pApplet, "buttons/cross.png", "buttons/crosshvr.png", "buttons/crossclkd.png");
        this._lblseis = new GLabel(this, pApplet, Language.getString("seismic"), 0.16f, 0.07f, 200);
        this._lblmir = new GLabel(this, pApplet, Language.getString("mirror_thermal"), 0.16f, 0.2f, 200);
        this._lblsus = new GLabel(this, pApplet, Language.getString("suspension_thermal"), 0.16f, 0.34f, 200);
        this._lblrad = new GLabel(this, pApplet, Language.getString("radiation_pressure"), 0.16f, 0.475f, 200);
        this._lblshot = new GLabel(this, pApplet, Language.getString("shot_noise"), 0.16f, 0.62f, 200);
        this._lblgas = new GLabel(this, pApplet, Language.getString("residual_gas"), 0.16f, 0.74f, 200);
        this._lblgrav = new GLabel(this, pApplet, Language.getString("gravity_gradient"), 0.16f, 0.87f, 200);
        this.legend.addChild(this._lblgas);
        this.legend.addChild(this._lblshot);
        this.legend.addChild(this._lblrad);
        this.legend.addChild(this._lblmir);
        this.legend.addChild(this._lblsus);
        this.legend.addChild(this._lblseis);
        this.legend.addChild(this._lblgrav);
        this.addChild(this.legend);
        this.addChild(this._btnClose);
    }

    public void UpdateGraphs() {
        this.snTrace.generate();
        this.rgTrace.generate();
        this.rpnTrace.generate();
        this.mtnTrace.generate();
        this.stnTrace.generate();
        this.senTrace.generate();
        this.ggTrace.generate();
        this.totalTrace.generate();
    }

    @Override
    public void loadResources() {
        this.swoosh = ResourceManager.LoadAudio("audio/74692__Benboncan__Swoosh_5.mp3");
    }

    public void Show() {
        if (this.Show != null && this.Show.isRunning()) {
            return;
        }
        if (this.Hide != null) {
            this.Hide.Stop();
        }
        this.setVisible(true);
        this.Show = new KeyFrameAnimation(false, this);
        this.Show.AddKeyFrame(new PVectorKeyFrame(0.0f, this.getPosition().x, 0.0f, TargetProperty.position, EasingFunctions.EaseInOut));
        this.Show.AddKeyFrame(new PVectorKeyFrame(0.5f, 0.0f, 0.0f, TargetProperty.position));
        this.Show.Start();
        if (this.swoosh != null) {
            this.swoosh.cue(0);
            this.swoosh.play();
        }
    }

    public void Hide() {
        if (this.Hide != null && this.Hide.isRunning()) {
            return;
        }
        if (this.Show != null) {
            this.Show.Stop();
        }
        this.Hide = new KeyFrameAnimation(false, this, new OnHide());
        this.Hide.AddKeyFrame(new PVectorKeyFrame(0.0f, this.getPosition().x, 0.0f, TargetProperty.position, EasingFunctions.EaseInOut));
        this.Hide.AddKeyFrame(new PVectorKeyFrame(0.5f, (float)this.getParent().getWidth() * -1.0f, 0.0f, TargetProperty.position));
        this.Hide.Start();
        if (this.swoosh != null) {
            this.swoosh.cue(0);
            this.swoosh.play();
        }
    }

    @Override
    public void setup() {
        this._lblshot.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblgas.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblrad.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblmir.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblsus.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblseis.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblgrav.setFont(Language.getString("Font_Handwritten"), 20);
        this._lblshot.setTextAlign(1);
        this._lblgas.setTextAlign(1);
        this._lblrad.setTextAlign(1);
        this._lblmir.setTextAlign(1);
        this._lblsus.setTextAlign(1);
        this._lblseis.setTextAlign(1);
        this._lblgrav.setTextAlign(1);
        this.setBounds((int)((float)this.getParent().getWidth() * 0.68f), this.getParent().getHeight());
        this.setRelativePosition(-1.0f, 0.0f);
        this._btnClose.setCallback(new ButtonElement.IButtonCallback(){

            @Override
            public void OnClicked(ButtonElement buttonElement, int n) {
                NoiseModelScreen.this.Hide();
            }
        });
        this._btnClose.setOrigin(1.0f, 0.0f);
        this._btnClose.setRelativePosition(0.99f, 0.01f);
        this.legend.setOrigin(0.0f, 0.0f);
        this.legend.setRelativePosition(1.0f, 0.0f);
        this.g = new Graph2D(this._app, (int)(0.8f * (float)this.getWidth()), (int)(0.7f * (float)this.getHeight()), true);
        this.g.setAxisColour(220, 220, 220);
        this.g.setFontColour(255, 255, 255);
        this.g.position.y = (int)(0.06666667f * (float)this.getHeight());
        this.g.position.x = (int)(0.15555556f * (float)this.getWidth());
        this.g.setYAxisTickSpacing(1.0f);
        this.g.setXAxisTickSpacing(1.0f);
        this.g.setXAxisMinorTicks(1);
        this.g.setYAxisMinorTicks(2);
        this.g.setYAxisMin(1.0E-26f);
        this.g.setYAxisMax(1.0E-16f);
        this.g.setXAxisMin(1.0f);
        this.g.setXAxisMax(10000.0f);
        this.g.setXAxisLabel("Frequency (Hz)");
        this.g.setYAxisLabel("Noise (1/sqrt(Hz))");
        this.g.getYAxis().setLogarithmicAxis(true);
        this.g.getXAxis().setLogarithmicAxis(true);
        this.g.getYAxis().setTickLabelType(ValueType.EXPONENT);
        this.g.getYAxis().setMinorTicks(3);
        this.g.setXAxisLabelAccuracy(0);
        this.snTrace = new Line2DTrace(new ShotNoise());
        this.snTrace.setTraceColour(0, 255, 0);
        this.snTrace.setLineWidth(2);
        this.rgTrace = new Line2DTrace(new ResidualGas());
        this.rgTrace.setTraceColour(255, 125, 0);
        this.rgTrace.setLineWidth(2);
        this.rpnTrace = new Line2DTrace(new RadiationPressureNoise());
        this.rpnTrace.setTraceColour(0, 0, 255);
        this.rpnTrace.setLineWidth(2);
        this.mtnTrace = new Line2DTrace(new MirrorThermalNoise());
        this.mtnTrace.setTraceColour(0, 255, 255);
        this.mtnTrace.setLineWidth(2);
        this.stnTrace = new Line2DTrace(new SuspThermalNoise());
        this.stnTrace.setTraceColour(125, 125, 255);
        this.stnTrace.setLineWidth(2);
        this.senTrace = new Line2DTrace(new SeismicNoise());
        this.senTrace.setTraceColour(255, 255, 0);
        this.senTrace.setLineWidth(2);
        this.ggTrace = new Line2DTrace(new GravityGradientNoise());
        this.ggTrace.setTraceColour(255, 0, 0);
        this.ggTrace.setLineWidth(2);
        this.totalTrace = new Line2DTrace(new TotalNoise());
        this.totalTrace.setTraceColour(255, 255, 255);
        this.totalTrace.setLineWidth(3);
        this.g.addTrace(this.snTrace);
        this.g.addTrace(this.rgTrace);
        this.g.addTrace(this.rpnTrace);
        this.g.addTrace(this.mtnTrace);
        this.g.addTrace(this.stnTrace);
        this.g.addTrace(this.senTrace);
        this.g.addTrace(this.ggTrace);
        this.g.addTrace(this.totalTrace);
        GridBackground gridBackground = new GridBackground(new GWColour(100, 100, 100), new GWColour(15));
        this.g.setBackground(gridBackground);
    }

    @Override
    public void update(float f) {
        super.update(f);
        if (this.Show != null) {
            this.Show.Update(f);
        }
        if (this.Hide != null) {
            this.Hide.Update(f);
        }
        this.UpdateGraphs();
    }

    @Override
    public void render() {
        super.render();
        this._app.pushStyle();
        this._app.fill(0);
        this._app.rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        this._app.popStyle();
        this.g.draw();
    }

    public class OnHide
    implements IAnimationCompleteCallback {
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            NoiseModelScreen.this.setVisible(false);
        }
    }
}

