/*
 * Decompiled with CFR 0.152.
 */
package game.noisemodels;

import game.variables.EnvironmentSystemVariables;
import game.variables.IDetectorConstants;
import game.variables.OpticsVariables;
import game.variables.SuspensionVariables;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;

public class MirrorThermalNoise
implements ILine2DEquation,
IDetectorConstants {
    private static double K1 = Math.sqrt(4.0) / 5000.0 * Math.sqrt(5.5226E-23);
    private static double M_eff = 0.28f * SuspensionVariables.PendMass;

    public static double getMirrorThermalNoise(double d) {
        M_eff = 0.28f * SuspensionVariables.PendMass;
        double d2 = 6.2831854820251465 * d;
        double d3 = 35185.83984375 * Math.pow(23.0f / SuspensionVariables.PendMass, 0.66f);
        return K1 * Math.sqrt((double)EnvironmentSystemVariables.getTargetTemperature() * d3 * d3 / (d2 * M_eff * OpticsVariables.getMirMatQ() * (Math.pow(d3 * d3 - d2 * d2, 2.0) + Math.pow(d3 * d3 / OpticsVariables.getMirMatQ(), 2.0))));
    }

    @Override
    public double computePoint(double d, int n) {
        return MirrorThermalNoise.getMirrorThermalNoise(d);
    }
}

