/*
 * Decompiled with CFR 0.152.
 */
package game.budgetscreen;

import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.FrameElement;
import core.gui.TextBlockElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.PlayerData;
import game.variables.EnvironmentSystemVariables;
import game.variables.OpticsVariables;
import game.variables.SuspensionVariables;
import processing.core.PApplet;

public class BudgetScreen
extends ScreenElement {
    public KeyFrameAnimation Show;
    public KeyFrameAnimation Hide;
    private FrameElement frm;
    private AudioPlayer swoosh;
    ButtonElement _btnClose;
    private TextBlockElement startBudget;
    private TextBlockElement opticsCost;
    private TextBlockElement vibrationCost;
    private TextBlockElement enviroCost;
    private TextBlockElement lblstartBudget;
    private TextBlockElement lblopticsCost;
    private TextBlockElement lblvibrationCost;
    private TextBlockElement lblenviroCost;
    private TextBlockElement txt;

    public BudgetScreen(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.frm = new FrameElement(this, pApplet);
        this._btnClose = new ButtonElement(this, pApplet, "buttons/cross.png", "buttons/crosshvr.png", "buttons/crossclkd.png");
        this.startBudget = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), "", 20, 1.0f, 1.0f);
        this.opticsCost = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), "", 20, 1.0f, 1.0f);
        this.vibrationCost = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), "", 20, 1.0f, 1.0f);
        this.enviroCost = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), "", 20, 1.0f, 1.0f);
        this.lblstartBudget = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), Language.getString("Budget_init_budget") + "(" + Language.getString("Currency") + "):", 20, 1.0f, 1.0f);
        this.lblopticsCost = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), Language.getString("Budget_optics") + "(" + Language.getString("Currency") + "):", 20, 1.0f, 1.0f);
        this.lblvibrationCost = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), Language.getString("Budget_Suspension") + "(" + Language.getString("Currency") + "):", 20, 1.0f, 1.0f);
        this.lblenviroCost = new TextBlockElement(this.frm, pApplet, Language.getString("Font_Default"), Language.getString("Budget_environment") + "(" + Language.getString("Currency") + "):", 20, 1.0f, 1.0f);
        this.startBudget.setFontColour(0.0f, 0.0f, 0.0f);
        this.lblstartBudget.setFontColour(0.1f, 0.1f, 0.1f);
        this.lblopticsCost.setFontColour(0.1f, 0.1f, 0.1f);
        this.lblvibrationCost.setFontColour(0.1f, 0.1f, 0.1f);
        this.lblenviroCost.setFontColour(0.1f, 0.1f, 0.1f);
        this.txt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Budget_text"), 20, 0.85f, 0.5f);
        this.frm.addChild(this.txt);
        this.frm.addChild(this.startBudget);
        this.frm.addChild(this.opticsCost);
        this.frm.addChild(this.vibrationCost);
        this.frm.addChild(this.enviroCost);
        this.frm.addChild(this.lblstartBudget);
        this.frm.addChild(this.lblopticsCost);
        this.frm.addChild(this.lblvibrationCost);
        this.frm.addChild(this.lblenviroCost);
        this.addChild(this.frm);
        this.addChild(this._btnClose);
    }

    @Override
    public void loadResources() {
        this.swoosh = ResourceManager.LoadAudio("audio/74692__Benboncan__Swoosh_5.mp3");
    }

    @Override
    public void setup() {
        this.setBounds((int)((float)this.getParent().getWidth() * 0.55f), (int)((float)this.getParent().getHeight() * 0.5f));
        this.setRelativePosition(-1.0f, 0.0f);
        this.frm.setWidth(this.getWidth());
        this.frm.setHeight(this.getHeight());
        this.frm.setBackOpacity(1.0f);
        this.frm.setBackColour(1.0f, 1.0f, 1.0f);
        this.txt.setRelativePosition(0.1f, 0.1f);
        this.txt.setFontColour(0.0f, 0.0f, 0.0f);
        this._btnClose.setCallback(new ButtonElement.IButtonCallback(){

            @Override
            public void OnClicked(ButtonElement buttonElement, int n) {
                BudgetScreen.this.Hide();
            }
        });
        this._btnClose.setOrigin(1.0f, 0.0f);
        this._btnClose.setRelativePosition(0.99f, 0.01f);
        this.lblstartBudget.setRelativePosition(0.1f, 0.5f);
        this.lblenviroCost.setRelativePosition(0.1f, 0.6f);
        this.lblvibrationCost.setRelativePosition(0.1f, 0.7f);
        this.lblopticsCost.setRelativePosition(0.1f, 0.8f);
        this.startBudget.setRelativePosition(0.6f, 0.5f);
        this.enviroCost.setRelativePosition(0.6f, 0.6f);
        this.vibrationCost.setRelativePosition(0.6f, 0.7f);
        this.opticsCost.setRelativePosition(0.6f, 0.8f);
    }

    public void Show() {
        if (this.Show != null && this.Show.isRunning()) {
            return;
        }
        if (this.Hide != null) {
            this.Hide.Stop();
        }
        this.setVisible(true);
        this.Show = new KeyFrameAnimation(false, this);
        this.Show.AddKeyFrame(new PVectorKeyFrame(0.0f, this.getPosition().x, (float)this.getParent().getHeight() * 0.5f, TargetProperty.position, EasingFunctions.EaseInOut));
        this.Show.AddKeyFrame(new PVectorKeyFrame(0.5f, 5.0f, (float)this.getParent().getHeight() * 0.5f, TargetProperty.position));
        this.Show.Start();
        if (this.swoosh != null) {
            this.swoosh.cue(0);
            this.swoosh.play();
        }
    }

    public void Hide() {
        if (this.Hide != null && this.Hide.isRunning()) {
            return;
        }
        if (this.Show != null) {
            this.Show.Stop();
        }
        this.Hide = new KeyFrameAnimation(false, this, new OnHide());
        this.Hide.AddKeyFrame(new PVectorKeyFrame(0.0f, this.getPosition().x, (float)this.getParent().getHeight() * 0.5f, TargetProperty.position, EasingFunctions.EaseInOut));
        this.Hide.AddKeyFrame(new PVectorKeyFrame(0.5f, -1.0f * (float)this.getParent().getWidth(), (float)this.getParent().getHeight() * 0.5f, TargetProperty.position));
        this.Hide.Start();
        if (this.swoosh != null) {
            this.swoosh.cue(0);
            this.swoosh.play();
        }
    }

    @Override
    public void update(float f) {
        super.update(f);
        if (this.Show != null) {
            this.Show.Update(f);
        }
        if (this.Hide != null) {
            this.Hide.Update(f);
        }
        this.startBudget.setText("" + PlayerData.InitialPlayerMoney);
        Integer n = OpticsVariables.getLaserCosts() + OpticsVariables.getMirMatCosts() + OpticsVariables.getSurfCosts();
        this.opticsCost.setText(n.toString());
        Integer n2 = SuspensionVariables.getPendCost();
        this.vibrationCost.setText(n2.toString());
        Integer n3 = (int)((double)(EnvironmentSystemVariables.getVacuumCosts() + EnvironmentSystemVariables.getCoolingCosts()) + EnvironmentSystemVariables.DepthCosts);
        this.enviroCost.setText(n3.toString());
        if (n > 0) {
            this.opticsCost.setFontColour(1.0f, 0.0f, 0.0f);
        } else {
            this.opticsCost.setFontColour(0.0f, 0.0f, 0.0f);
        }
        if (n2 > 0) {
            this.vibrationCost.setFontColour(1.0f, 0.0f, 0.0f);
        } else {
            this.vibrationCost.setFontColour(0.0f, 0.0f, 0.0f);
        }
        if (n3 > 0) {
            this.enviroCost.setFontColour(1.0f, 0.0f, 0.0f);
        } else {
            this.enviroCost.setFontColour(0.0f, 0.0f, 0.0f);
        }
    }

    public class OnHide
    implements IAnimationCompleteCallback {
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            BudgetScreen.this.setVisible(false);
        }
    }
}

