/*
 * Decompiled with CFR 0.152.
 */
package game;

import core.GamePage;
import core.GameScreen;
import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.SpeechBubbleElement;
import core.gui.TextButtonElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.elements.GwopticsLogo;
import highscore.HighScoreScreen;
import java.util.Random;
import org.gwoptics.graphics.GWColour;
import processing.core.PApplet;

public class IntroPage
extends GamePage {
    private Backdrop _backdrop;
    private ImageElement _logo;
    private GwopticsLogo _gwlogo;
    private Rocket _rocket;
    KeyFrameAnimation logoShow;
    KeyFrameAnimation glassShow;
    KeyFrameAnimation btnShow;
    KeyFrameAnimation logoWobble;
    KeyFrameAnimation rocketLaunch;
    KeyFrameAnimation startGame;
    KeyFrameAnimation intro;
    KeyFrameAnimation score;
    KeyFrameAnimation gwoptics;
    HourGlass hglass;
    TextButtonElement _btnStart;
    TextButtonElement _btnInstructions;
    TextButtonElement _btnScores;
    TextButtonElement _btnQuit;
    TextButtonElement _btnCredits;
    boolean showingScores = false;
    boolean showingCredits = false;
    private boolean _skippedIntro;
    AudioPlayer music;
    private boolean rocketLaunched = false;

    public IntroPage(PApplet pApplet) {
        super(pApplet);
        this._btnStart = new TextButtonElement(this, pApplet, Language.getString("New_Game"));
        this._btnInstructions = new TextButtonElement(this, pApplet, Language.getString("Instructions"));
        this._btnScores = new TextButtonElement(this, pApplet, Language.getString("Highscores"));
        this._btnQuit = new TextButtonElement(this, pApplet, Language.getString("Quit"));
        this._btnCredits = new TextButtonElement(this, pApplet, Language.getString("Credits"));
        this._rocket = new Rocket(this, pApplet);
        this._logo = new ImageElement("logo.png", this, pApplet);
        this.hglass = new HourGlass((ScreenElement)this, pApplet);
        this._backdrop = new Backdrop(this, pApplet);
        this._gwlogo = new GwopticsLogo(this, pApplet);
        this.addChild(this._backdrop);
        this.addChild(this._logo);
        this.addChild(this.hglass);
        this.addChild(this._btnStart);
        this.addChild(this._btnInstructions);
        this.addChild(this._btnScores);
        this.addChild(this._btnQuit);
        this.addChild(this._btnCredits);
        this.addChild(this._gwlogo);
        this.addChild(this._rocket);
    }

    @Override
    public void setup() {
        this._btnStart.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnStart.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(1.0f, 1.0f, 1.0f));
        this._btnInstructions.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnInstructions.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(1.0f, 1.0f, 1.0f));
        this._btnScores.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnScores.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(1.0f, 1.0f, 1.0f));
        this._btnQuit.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnQuit.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(1.0f, 1.0f, 1.0f));
        this._btnCredits.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnCredits.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(1.0f, 1.0f, 1.0f));
        OnButtonClick onButtonClick = new OnButtonClick();
        this._btnStart.setCallback(onButtonClick);
        this._btnInstructions.setCallback(onButtonClick);
        this._btnScores.setCallback(onButtonClick);
        this._btnQuit.setCallback(onButtonClick);
        this._btnCredits.setCallback(onButtonClick);
        this._btnStart.setRelativePosition(1.5f, 0.5f);
        this._btnInstructions.setRelativePosition(1.5f, 0.6f);
        this._btnScores.setRelativePosition(1.5f, 0.7f);
        this._btnCredits.setRelativePosition(1.5f, 0.8f);
        this._btnQuit.setRelativePosition(1.5f, 0.9f);
        this._btnStart.setOrigin(1.0f, 0.5f);
        this._btnInstructions.setOrigin(1.0f, 0.5f);
        this._btnScores.setOrigin(1.0f, 0.5f);
        this._btnCredits.setOrigin(1.0f, 0.5f);
        this._btnQuit.setOrigin(1.0f, 0.5f);
        this.btnShow = new KeyFrameAnimation(false);
        this.btnShow.AddTargetObject(this._btnStart);
        this.btnShow.AddTargetObject(this._btnScores);
        this.btnShow.AddTargetObject(this._btnInstructions);
        this.btnShow.AddTargetObject(this._btnCredits);
        this.btnShow.AddTargetObject(this._btnQuit);
        this.btnShow.AddKeyFrame(new PVectorKeyFrame(0.0f, (float)this.getWidth() * 1.5f, Float.NaN, TargetProperty.position, EasingFunctions.EaseOut));
        this.btnShow.AddKeyFrame(new PVectorKeyFrame(2.0f, (float)this.getWidth() * 0.95f, Float.NaN, TargetProperty.position));
        this._logo.setOrigin(0.5f, 0.5f);
        this._logo.setRelativePosition(0.65f, -0.35f);
        this.hglass.setRelativePosition(0.2f, -0.35f);
        float f = (float)this.getHeight() * 0.2f;
        float f2 = this._backdrop.getHeight();
        float f3 = (float)this.getHeight() * 0.88f;
        this._gwlogo.setRelativePosition(0.0f, 1.35f);
        this.gwoptics = new KeyFrameAnimation(false, this._gwlogo);
        this.gwoptics.AddKeyFrame(new PVectorKeyFrame(0.0f, this._gwlogo.getX(), this._gwlogo.getY(), TargetProperty.position));
        this.gwoptics.AddKeyFrame(new PVectorKeyFrame(1.0f, this._gwlogo.getX(), f3, TargetProperty.position));
        this.logoShow = new KeyFrameAnimation(false, this._logo, new OnLogoShowDone());
        this.logoShow.AddKeyFrame(new PVectorKeyFrame(0.0f, this._logo.getX(), this._logo.getY(), TargetProperty.position, EasingFunctions.EaseOut));
        this.logoShow.AddKeyFrame(new PVectorKeyFrame(2.5f, this._logo.getX(), f, TargetProperty.position));
        this.glassShow = new KeyFrameAnimation(false, this.hglass, new OnGlassShowDone());
        this.glassShow.AddKeyFrame(new PVectorKeyFrame(0.0f, this.hglass.getX(), this.hglass.getY(), TargetProperty.position, EasingFunctions.EaseOut));
        this.glassShow.AddKeyFrame(new PVectorKeyFrame(2.5f, this.hglass.getX(), f, TargetProperty.position));
        this.logoWobble = new KeyFrameAnimation(true, this._logo);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(1.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this._backdrop.setRelativePosition(0.0f, -f2 + (float)this.getHeight());
        this._rocket.setRelativePosition(0.22f, 1.2f);
        this._rocket.setOrigin(0.5f, 0.5f);
        this.rocketLaunch = new KeyFrameAnimation(false, this._rocket);
        this.rocketLaunch.AddKeyFrame(new PVectorKeyFrame(0.0f, Float.NaN, this._rocket.getY(), TargetProperty.position));
        this.rocketLaunch.AddKeyFrame(new PVectorKeyFrame(6.5f, Float.NaN, (float)this.getHeight() * 0.51f, TargetProperty.position));
        this.rocketLaunch.AddKeyFrame(new PVectorKeyFrame(9.5f, Float.NaN, (float)this.getHeight() * 0.6f, TargetProperty.position, EasingFunctions.BounceIn));
        this.rocketLaunch.AddKeyFrame(new PVectorKeyFrame(10.0f, Float.NaN, (float)this.getHeight() * 0.64f, TargetProperty.position));
        this.intro = new KeyFrameAnimation(false, this._backdrop);
        this.intro.AddKeyFrame(new PVectorKeyFrame(0.0f, 0.0f, -f2 + (float)this.getHeight(), TargetProperty.position));
        this.intro.AddKeyFrame(new PVectorKeyFrame(0.5f, 0.0f, -f2 + (float)this.getHeight(), TargetProperty.position, EasingFunctions.EaseInOut));
        this.intro.AddKeyFrame(new PVectorKeyFrame(10.0f, 0.0f, 0.0f, TargetProperty.position));
        this.score = new KeyFrameAnimation(false, this);
        this.score.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this.score.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation(this.intro);
        this.setHideAnimation(keyFrameAnimation);
    }

    @Override
    public void PreShow() {
        if (!this.rocketLaunched) {
            this.rocketLaunch.Start();
            this._rocket.ShowFlame(true);
        }
    }

    @Override
    public void PostShow() {
        this.setShowAnimation(this.score);
        this._skippedIntro = true;
        if (!this.rocketLaunched) {
            GameScreen.setChangeMusic(this.music, 5.0f);
            this._rocket.ShowFlame(false);
            this.rocketLaunched = true;
            this.logoShow.Start();
            this.glassShow.Start();
            this.btnShow.Start();
            this.gwoptics.Start();
        }
    }

    @Override
    public void PostHide() {
        this._rocket.ShowFlame(false);
        this.rocketLaunch.Start();
        this.rocketLaunch.gotoTime(this.rocketLaunch.getFinishTime() * 0.99999f);
    }

    @Override
    public void update(float f) {
        super.update(f);
        this.rocketLaunch.Update(f);
        this.logoShow.Update(f);
        this.logoWobble.Update(f);
        this.glassShow.Update(f);
        this.btnShow.Update(f);
        this.gwoptics.Update(f);
        if (this.startGame != null) {
            this.startGame.Update(f);
        }
        if (this._app.key == ' ' && !this._skippedIntro) {
            this._skippedIntro = true;
            this.intro.gotoTime(this.intro.getFinishTime() * 0.9f);
            this.rocketLaunch.gotoTime(this.rocketLaunch.getFinishTime() * 0.9f);
        }
    }

    public class OnLogoShowDone
    implements IAnimationCompleteCallback {
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            if (!IntroPage.this.logoWobble.isRunning()) {
                float f = IntroPage.this._logo.getY();
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(0.0f, IntroPage.this._logo.getX(), f, TargetProperty.position, EasingFunctions.EaseInOut));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(0.0f, 1.0f, 1.0f, TargetProperty.scale));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(1.5f, 0.95f, 1.05f, TargetProperty.scale));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(3.0f, IntroPage.this._logo.getX(), f + (float)IntroPage.this.getHeight() * 0.06f, TargetProperty.position, EasingFunctions.EaseInOut));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(3.0f, 1.0f, 1.0f, TargetProperty.scale));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(4.5f, 1.05f, 0.95f, TargetProperty.scale));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(6.0f, IntroPage.this._logo.getX(), f, TargetProperty.position));
                IntroPage.this.logoWobble.AddKeyFrame(new PVectorKeyFrame(6.0f, 1.0f, 1.0f, TargetProperty.scale));
            }
            IntroPage.this.logoWobble.Start();
        }
    }

    public class OnGlassShowDone
    implements IAnimationCompleteCallback {
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            IntroPage.this.hglass.startMoving();
        }
    }

    private class OnGameStartAnimDone
    implements IAnimationCompleteCallback {
        private OnGameStartAnimDone() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            GameScreen.showPage("GameSetup");
        }
    }

    private class OnButtonClick
    implements ButtonElement.IButtonCallback {
        private OnButtonClick() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (buttonElement == IntroPage.this._btnStart) {
                IntroPage.this.showingScores = false;
                IntroPage.this.showingCredits = false;
                IntroPage.this._rocket.hideBubble();
                IntroPage.this._rocket.ShowFlame(true);
                IntroPage.this.startGame = new KeyFrameAnimation(false, IntroPage.this._rocket, new OnGameStartAnimDone());
                IntroPage.this.startGame.AddKeyFrame(new PVectorKeyFrame(0.0f, Float.NaN, IntroPage.this._rocket.getY(), TargetProperty.position, EasingFunctions.EaseIn));
                IntroPage.this.startGame.AddKeyFrame(new PVectorKeyFrame(3.0f, Float.NaN, (float)(-IntroPage.this.getWidth()) * 0.5f, TargetProperty.position));
                IntroPage.this.startGame.Start();
            } else if (buttonElement == IntroPage.this._btnScores) {
                IntroPage.this.showingScores = true;
                HighScoreScreen highScoreScreen = (HighScoreScreen)GameScreen.getPage("Scores");
                highScoreScreen.FromIntroPage = true;
                GameScreen.showPage("Scores");
            } else if (buttonElement == IntroPage.this._btnInstructions) {
                IntroPage.this._rocket.displayBubble();
            } else if (buttonElement == IntroPage.this._btnQuit) {
                IntroPage.this._app.exit();
            } else if (buttonElement == IntroPage.this._btnCredits) {
                IntroPage.this.showingCredits = true;
                GameScreen.showPage("Credits");
            }
        }
    }

    private class Rocket
    extends ScreenElement {
        ImageElement _rocket;
        ImageElement _flame;
        Random _rand;
        SpeechBubbleElement _spchBubble;
        AudioPlayer rocket;

        public Rocket(ScreenElement screenElement, PApplet pApplet) {
            super(screenElement, pApplet);
            this._rocket = new ImageElement("rocketship.png", this, pApplet);
            this._flame = new ImageElement("rrocketshipflames.png", this, pApplet);
            this._rand = new Random();
            this._spchBubble = new SpeechBubbleElement(this, pApplet);
            this.addChild(this._flame);
            this.addChild(this._rocket);
            this.addChild(this._spchBubble);
            this.setClickable(true);
        }

        @Override
        public void onMouseEvent(int n, int n2) {
            switch (n) {
                case 502: {
                    this.displayBubble();
                }
            }
        }

        @Override
        public void update(float f) {
            if (this._flame.isVisible()) {
                float f2 = 0.02f * (this._rand.nextFloat() - 0.5f);
                this._flame.setOrigin(0.5f + f2, 0.0f);
                this._rocket.setOrigin(f2, 0.0f);
            }
        }

        @Override
        public void loadResources() {
            this.setBounds(this._rocket.getWidth(), this._rocket.getHeight());
            this.rocket = ResourceManager.LoadAudio("audio/rocket_launch.mp3", 8192);
        }

        @Override
        public void setup() {
            this._spchBubble.setPointerToLeft(true);
            this._spchBubble.setOrigin(0.0f, 1.0f);
            this._spchBubble.setRelativePosition(0.5555556f, 0.4f);
            this._spchBubble.setVisible(false);
            this._flame.setOrigin(0.5f, 0.0f);
            this._flame.setRelativePosition(0.5f, 0.9f);
        }

        public void hideBubble() {
            this._spchBubble.Hide();
        }

        public void displayBubble() {
            String string = Language.getString("Intro_parrot");
            int n = 470;
            int n2 = 350;
            if (!this._flame.isVisible()) {
                if (this._spchBubble.isVisible()) {
                    this._spchBubble.Hide();
                } else {
                    this._spchBubble.setText(string);
                    this._spchBubble.Show(n, n2);
                }
            }
        }

        public void ShowFlame(boolean bl) {
            this._flame.setVisible(bl);
            if (bl) {
                if (this.rocket != null) {
                    this.rocket.cue(0);
                    this.rocket.play();
                }
            } else if (this.rocket != null) {
                this.rocket.pause();
            }
        }
    }

    private class Backdrop
    extends ScreenElement {
        private ImageElement _backdrop_top;
        private ImageElement _backdrop_top_2;
        private ImageElement _backdrop_bottom;
        private ImageElement _backdrop_bottom_2;

        public Backdrop(ScreenElement screenElement, PApplet pApplet) {
            super(screenElement, pApplet);
            this._backdrop_top = new ImageElement("intro_back_top.jpg", this, pApplet);
            this._backdrop_bottom = new ImageElement("intro_back_bottom.jpg", this, pApplet);
            this._backdrop_top_2 = new ImageElement("intro_back_top_2.jpg", this, pApplet);
            this._backdrop_bottom_2 = new ImageElement("intro_back_bottom_2.jpg", this, pApplet);
            this.addChild(this._backdrop_bottom);
            this.addChild(this._backdrop_bottom_2);
            this.addChild(this._backdrop_top_2);
            this.addChild(this._backdrop_top);
        }

        @Override
        public void loadResources() {
            this.setBounds(this._backdrop_bottom.getWidth(), this._backdrop_bottom.getHeight() + this._backdrop_top.getHeight() + this._backdrop_bottom_2.getHeight() + this._backdrop_top_2.getHeight());
            this._backdrop_top_2.setRelativePosition(0.0f, 0.25f);
            this._backdrop_bottom_2.setRelativePosition(0.0f, 0.5f);
            this._backdrop_bottom.setRelativePosition(0.0f, 0.75f);
            IntroPage.this.music = ResourceManager.LoadAudio("audio/gurdonark.mp3");
        }
    }

    private class HourGlass
    extends ImageElement {
        private final float omega = 0.003141593f;
        private boolean startMoving;
        private final float voffset = 50.0f;
        private final float hoffset = 50.0f;
        float x;
        float y;
        float time;

        public HourGlass(ScreenElement screenElement, PApplet pApplet) {
            super("hourglass.png", screenElement, pApplet);
            this.omega = 0.003141593f;
            this.startMoving = false;
            this.voffset = 50.0f;
            this.hoffset = 50.0f;
        }

        @Override
        public void setup() {
            this.setOrigin(0.5f, 0.5f);
        }

        public void startMoving() {
            this.x = this.getX();
            this.y = this.getY();
            this.startMoving = true;
        }

        @Override
        public void update(float f) {
            this.setRotation(Float.valueOf(this.getRotation() + 0.003141593f));
            if (this.startMoving) {
                this.time += f * 0.8f;
                this.setX((float)((double)this.x + 50.0 * Math.sin(this.time)));
                this.setY((float)((double)this.y + 50.0 * Math.sin(this.time)));
            }
        }
    }
}

