/*
 * Decompiled with CFR 0.152.
 */
package game;

import core.GamePage;
import core.GameScreen;
import core.ImageElement;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.gui.ButtonElement;
import core.gui.GLabel;
import core.language.Language;
import game.PlayerData;
import game.budgetscreen.BudgetScreen;
import game.noisemodels.NoiseModelScreen;
import java.text.DecimalFormat;
import processing.core.PApplet;

public class GameHud
extends GamePage {
    ImageElement _hudImg;
    ImageElement _complexBar;
    ButtonElement _btnNoise;
    ButtonElement _btnPIOffice;
    ButtonElement _btnComplex;
    ButtonElement _coins;
    ButtonElement _btnRestart;
    GLabel _lblMenuItem;
    GLabel _lblMoney;
    NoiseModelScreen _noiseModels;
    BudgetScreen _budScreen;
    static GameHud _inst;

    public GameHud(PApplet pApplet) {
        super(pApplet);
        _inst = this;
        this._noiseModels = new NoiseModelScreen(this, pApplet);
        this._budScreen = new BudgetScreen(this, pApplet);
        this._complexBar = new ImageElement("complexbar.png", this, pApplet);
        this._hudImg = new ImageElement("HUD.png", this, pApplet);
        this._coins = new ButtonElement(this, pApplet, "coins-dark.png", "coins-bright.png", "coins-dark.png");
        this._btnNoise = new ButtonElement(this, pApplet, "noiseButtonNrm.png", "noiseButtonHvr.png", "noiseButtonNrm.png");
        this._btnPIOffice = new ButtonElement(this, pApplet, "home-dark.png", "home-bright.png", "home-dark.png");
        this._btnComplex = new ButtonElement(this, pApplet, "cogs-dark.png", "cogs-bright.png", "cogs-dark.png");
        this._btnRestart = new ButtonElement(this, pApplet, "restart.png", "restart_over.png", "restart.png");
        this._hudImg.addChild(this._complexBar);
        this._hudImg.addChild(this._btnNoise);
        this._hudImg.addChild(this._btnPIOffice);
        this._hudImg.addChild(this._btnComplex);
        this._hudImg.addChild(this._coins);
        this._hudImg.addChild(this._btnRestart);
        this._lblMenuItem = new GLabel(this, pApplet, "", 0.5f, 1.0f, 300);
        this._lblMenuItem.setOrigin(0.5f, 1.0f);
        this._lblMenuItem.setTextAlign(4);
        this._lblMenuItem.setColour(0.0f, 0.0f, 0.0f);
        this._lblMenuItem.setFont(Language.getString("Font_Default"), 15);
        this._lblMoney = new GLabel(this, pApplet, Language.getString("Currency") + "10000000", 0.5f, 1.0f, 90);
        this._lblMoney.setOrigin(0.0f, 1.0f);
        this._lblMoney.setRelativePosition(0.775076f, 0.84090906f);
        this._lblMoney.setTextAlign(2);
        this._lblMoney.setColour(1.0f, 1.0f, 1.0f);
        this._lblMoney.setFont(Language.getString("Font_Default"), 18);
        this.addChild(this._noiseModels);
        this.addChild(this._budScreen);
        this._hudImg.addChild(this._lblMenuItem);
        this._hudImg.addChild(this._lblMoney);
        this.addChild(this._hudImg);
    }

    @Override
    public void setup() {
        super.setup();
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation(false, this);
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        ButtonHover buttonHover = new ButtonHover();
        ButtonClicked buttonClicked = new ButtonClicked();
        this._complexBar.setRelativePosition(0.021276595f, 0.5681818f);
        this._btnNoise.setOrigin(0.5f, 0.5f);
        this._btnNoise.setRelativePosition(0.5f, 0.4f);
        this._btnNoise.setCallback(buttonClicked);
        this._btnNoise.setHoverCallback(buttonHover);
        this._btnPIOffice.setOrigin(0.5f, 0.5f);
        this._btnPIOffice.setRelativePosition(0.35f, 0.5f);
        this._btnPIOffice.setCallback(buttonClicked);
        this._btnPIOffice.setHoverCallback(buttonHover);
        this._btnRestart.setOrigin(0.5f, 0.5f);
        this._btnRestart.setRelativePosition(0.62f, 0.5f);
        this._btnRestart.setCallback(buttonClicked);
        this._btnRestart.setHoverCallback(buttonHover);
        this._btnComplex.setOrigin(0.0f, 1.0f);
        this._btnComplex.setRelativePosition(0.1899696f, 0.90909094f);
        this._btnComplex.setCallback(buttonClicked);
        this._btnComplex.setHoverCallback(buttonHover);
        this._coins.setOrigin(1.0f, 1.0f);
        this._coins.setRelativePosition(0.79027355f, 0.90909094f);
        this._coins.setCallback(buttonClicked);
        this._coins.setHoverCallback(buttonHover);
        this._hudImg.setOrigin(0.5f, 1.0f);
        this._hudImg.setRelativePosition(0.5f, 1.0f);
        this._noiseModels.setVisible(false);
        this._budScreen.setVisible(false);
        this._budScreen.setOrigin(0.0f, 0.5f);
        this.setOpacity(0.0f);
    }

    @Override
    public void update(float f) {
        super.update(f);
        Long l = PlayerData.getPlayerMoney();
        if (l >= 0L) {
            this._lblMoney.setColour(1.0f, 1.0f, 1.0f);
        } else {
            this._lblMoney.setColour(1.0f, 0.0f, 0.0f);
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
        this._lblMoney.setText(Language.getString("Currency") + decimalFormat.format(l));
        float f2 = PlayerData.DetectorSite.getComplexometerCredits();
        float f3 = (f2 - (float)PlayerData.getPlayerComplex()) / f2;
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        this._complexBar.setScale(f3, 1.0f);
    }

    @Override
    public void render() {
        this._app.translate(0.0f, 0.0f, 0.002f);
        super.render();
    }

    public static void UpdateGraphs() {
        GameHud._inst._noiseModels.UpdateGraphs();
    }

    private class ButtonClicked
    implements ButtonElement.IButtonCallback {
        private ButtonClicked() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (!GameScreen.isPageChanging()) {
                if (buttonElement == GameHud.this._btnNoise) {
                    if (GameHud.this._noiseModels.isVisible()) {
                        GameHud.this._noiseModels.Hide();
                    } else {
                        if (GameHud.this._budScreen.isVisible()) {
                            GameHud.this._budScreen.Hide();
                        }
                        GameHud.this._noiseModels.Show();
                    }
                } else if (buttonElement == GameHud.this._btnPIOffice) {
                    if (GameHud.this._noiseModels.isVisible()) {
                        GameHud.this._noiseModels.Hide();
                    }
                    GameScreen.showPage("PIOffice");
                } else if (buttonElement == GameHud.this._btnRestart) {
                    ((GameHud)GameHud.this)._app.key = (char)27;
                    GameHud.this._app.keyPressed();
                } else if (buttonElement == GameHud.this._coins) {
                    if (GameHud.this._budScreen.isVisible()) {
                        GameHud.this._budScreen.Hide();
                    } else {
                        if (GameHud.this._noiseModels.isVisible()) {
                            GameHud.this._noiseModels.Hide();
                        }
                        GameHud.this._budScreen.Show();
                    }
                }
            }
        }
    }

    private class ButtonHover
    implements ButtonElement.IButtonHoverCallback {
        private ButtonHover() {
        }

        @Override
        public void OnHover(ButtonElement buttonElement) {
            if (buttonElement == GameHud.this._btnNoise) {
                if (GameHud.this._noiseModels.isVisible()) {
                    GameHud.this._lblMenuItem.setText(Language.getString("HUD_hide_noise"));
                } else {
                    GameHud.this._lblMenuItem.setText(Language.getString("HUD_show_noise"));
                }
            } else if (buttonElement == GameHud.this._btnPIOffice) {
                GameHud.this._lblMenuItem.setText(Language.getString("HUD_back_PI"));
            } else if (buttonElement == GameHud.this._btnComplex) {
                GameHud.this._lblMenuItem.setText(Language.getString("HUD_complexo"));
            } else if (buttonElement == GameHud.this._coins) {
                GameHud.this._lblMenuItem.setText(Language.getString("HUD_money"));
            } else if (buttonElement == GameHud.this._btnRestart) {
                GameHud.this._lblMenuItem.setText(Language.getString("HUD_exit"));
            }
        }

        @Override
        public void OnLeave(ButtonElement buttonElement) {
            GameHud.this._lblMenuItem.setText("");
        }
    }
}

