/*
 * Decompiled with CFR 0.152.
 */
package game;

import core.GamePage;
import core.GameScreen;
import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.GLabel;
import core.gui.OkDialog;
import core.gui.TextButtonElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.PlayerData;
import game.variables.ScoreCalculator;
import highscore.HighScoreScreen;
import highscore.HighScores;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import org.gwoptics.graphics.GWColour;
import parrot.Parrot;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class FinalScore
extends GamePage {
    private ScoreSlider _scrSld;
    private ImageElement _earth;
    private ImageElement _solar;
    private ImageElement _cluster;
    private ImageElement _galaxy;
    private ImageElement _group;
    private ImageElement _filament;
    private ImageElement _ss;
    private ImageElement _nn;
    private ImageElement _bb;
    private KeyFrameAnimation _parrotWobble;
    private KeyFrameAnimation _showNewImageBase;
    private KeyFrameAnimation _showImg;
    private KeyFrameAnimation _shownn;
    private KeyFrameAnimation _showss;
    private KeyFrameAnimation _showbb;
    private GLabel _lblScore;
    private GLabel _numS;
    private GLabel _numBB;
    private GLabel _numNN;
    private Double _ScoreDist = 0.0;
    private Double _dist = 0.0;
    private Parrot _parrot_astro;
    private TextButtonElement _btnScores;
    private TextButtonElement _btnTryAgain;
    private TextButtonElement _btnMainMenu;
    private ButtonElement _btnTweet;
    private OkDialog okdiag;
    private AudioPlayer music;
    private int numS = 0;
    private int numBB = 0;
    private int numNN = 0;
    boolean showingScores = false;
    boolean scoreBtnClicked = false;
    final double Re = 6400.0;
    final double AU = 1.49598E8;
    final double PC = 3.08568025E16;
    final double KPC = 3.08568025E19;
    final double MPC = 3.08568025E22;
    private double _compScale;
    double _inc = 0.0;
    double _maxDist = 3.08568025E24;
    boolean run = false;
    DecimalFormat frmKm = new DecimalFormat("#0.00 km");
    DecimalFormat frmAu = new DecimalFormat("#0.00 au");
    DecimalFormat frmPC = new DecimalFormat("#0.00 pc");
    DecimalFormat frmKPC = new DecimalFormat("#0.00 kpc");
    DecimalFormat frmMPC = new DecimalFormat("#0.00 Mpc");
    double EarthLim = 320000.0;
    double SolarLim = 3.08568025E14;
    double ClusterLim = 3.08568025E18;
    double GalaxyLim = 1.542840125E21;
    double GroupLim = 6.171360500000001E23;
    double FilamentLim = 3.08568025E24;
    boolean b1 = true;
    boolean b2 = true;
    boolean b3 = true;
    boolean b4 = true;
    boolean b5 = true;
    boolean b6 = true;

    public FinalScore(PApplet pApplet) {
        super(pApplet);
        this._earth = new ImageElement("finalImages/Earth.jpg", this, pApplet);
        this._solar = new ImageElement("finalImages/solarsystem.jpg", this, pApplet);
        this._cluster = new ImageElement("finalImages/starcluster.jpg", this, pApplet);
        this._galaxy = new ImageElement("finalImages/galaxy.jpg", this, pApplet);
        this._group = new ImageElement("finalImages/cluster.jpg", this, pApplet);
        this._filament = new ImageElement("finalImages/filaments.jpg", this, pApplet);
        this._ss = new ImageElement("supernovalarge.png", this, pApplet);
        this._nn = new ImageElement("NSNSinspirallarge.png", this, pApplet);
        this._bb = new ImageElement("BHBHinspirallarge.png", this, pApplet);
        this._btnTryAgain = new TextButtonElement(this, pApplet, Language.getString("Try_again"));
        this._btnScores = new TextButtonElement(this, pApplet, Language.getString("Highscores"));
        this._btnMainMenu = new TextButtonElement(this, pApplet, Language.getString("Main_Menu"));
        this._btnTweet = new ButtonElement(this, pApplet, "buttons/tweet.png", "buttons/tweet_over.png", "buttons/tweet_down.png");
        this._lblScore = new GLabel(this, pApplet, "", 0.5f, 0.5f, 200);
        this._lblScore.setTextAlign(4);
        this._lblScore.setColour(1.0f, 1.0f, 1.0f);
        this._scrSld = new ScoreSlider(this, pApplet);
        this._parrot_astro = new Parrot(this, pApplet);
        this.okdiag = new OkDialog(this, pApplet, Language.getString("Final_sorry"), 300, 200, new OnOk());
        this.okdiag.setVisible(false);
        this._numS = new GLabel(this, pApplet, "0", 0.15f, 0.3f, 200);
        this._numNN = new GLabel(this, pApplet, "0", 0.45f, 0.3f, 200);
        this._numBB = new GLabel(this, pApplet, "0", 0.75f, 0.3f, 200);
        this.addChild(this._earth);
        this.addChild(this._solar);
        this.addChild(this._cluster);
        this.addChild(this._galaxy);
        this.addChild(this._group);
        this.addChild(this._filament);
        this.addChild(this._ss);
        this.addChild(this._nn);
        this.addChild(this._bb);
        this.addChild(this._btnScores);
        this.addChild(this._btnMainMenu);
        this.addChild(this._btnTryAgain);
        this.addChild(this._btnTweet);
        this.addChild(this._numS);
        this.addChild(this._numNN);
        this.addChild(this._numBB);
        this.addChild(this._lblScore);
        this.addChild(this._scrSld);
        this.addChild(this._parrot_astro);
        this.addChild(this.okdiag);
    }

    @Override
    public void loadResources() {
        this.music = ResourceManager.LoadAudio("audio/gurdonark.mp3");
    }

    @Override
    public void setup() {
        this._numNN.setFont(Language.getString("Font_Default"), 30);
        this._numNN.setTextAlign(4);
        this._numNN.setOrigin(0.0f, 0.5f);
        this._numS.setFont(Language.getString("Font_Default"), 30);
        this._numS.setTextAlign(4);
        this._numS.setOrigin(0.0f, 0.5f);
        this._numBB.setFont(Language.getString("Font_Default"), 30);
        this._numBB.setTextAlign(4);
        this._numBB.setOrigin(0.0f, 0.5f);
        this._ss.setOrigin(0.5f, 0.5f);
        this._nn.setOrigin(0.5f, 0.5f);
        this._bb.setOrigin(0.5f, 0.5f);
        this._ss.setRelativePosition(0.15f, 0.3f);
        this._nn.setRelativePosition(0.45f, 0.3f);
        this._bb.setRelativePosition(0.75f, 0.3f);
        this._btnScores.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnTryAgain.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnMainMenu.setFont(Language.getString("Font_Handwritten"), 40);
        this._btnScores.setRelativePosition(0.5f, 0.7f);
        this._btnScores.setOrigin(0.5f, 0.5f);
        this._btnScores.setCallback(new OnButtonClick());
        this._btnScores.setWidth(500);
        this._btnTryAgain.setRelativePosition(0.5f, 0.8f);
        this._btnTryAgain.setOrigin(0.5f, 0.5f);
        this._btnTryAgain.setCallback(new OnButtonClick());
        this._btnMainMenu.setRelativePosition(0.5f, 0.9f);
        this._btnMainMenu.setOrigin(0.5f, 0.5f);
        this._btnMainMenu.setCallback(new OnButtonClick());
        this._btnTweet.setRelativePosition(0.5f, 0.55f);
        this._btnTweet.setOrigin(0.5f, 0.5f);
        this._btnTweet.setCallback(new OnButtonClick());
        this._btnTweet.setVisible(false);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation(false, this);
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        this._showss = new KeyFrameAnimation(false, this._ss, new OnShowScoreItem());
        this._showss.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this._showss.AddKeyFrame(new FloatKeyFrame(0.4f, Float.valueOf(1.0f), TargetProperty.opacity));
        this._showss.AddKeyFrame(new PVectorKeyFrame(0.0f, new PVector(0.1f, 0.1f, 1.0f), TargetProperty.scale));
        this._showss.AddKeyFrame(new PVectorKeyFrame(0.1f, new PVector(1.0f, 1.0f, 1.0f), TargetProperty.scale));
        this._shownn = new KeyFrameAnimation(false, this._nn, new OnShowScoreItem());
        this._shownn.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this._shownn.AddKeyFrame(new FloatKeyFrame(0.4f, Float.valueOf(1.0f), TargetProperty.opacity));
        this._shownn.AddKeyFrame(new PVectorKeyFrame(0.0f, new PVector(0.1f, 0.1f, 1.0f), TargetProperty.scale));
        this._shownn.AddKeyFrame(new PVectorKeyFrame(0.2f, new PVector(1.0f, 1.0f, 1.0f), TargetProperty.scale));
        this._showbb = new KeyFrameAnimation(false, this._bb, new OnShowScoreItem());
        this._showbb.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this._showbb.AddKeyFrame(new FloatKeyFrame(0.4f, Float.valueOf(1.0f), TargetProperty.opacity));
        this._showbb.AddKeyFrame(new PVectorKeyFrame(0.0f, new PVector(0.1f, 0.1f, 1.0f), TargetProperty.scale));
        this._showbb.AddKeyFrame(new PVectorKeyFrame(0.2f, new PVector(1.0f, 1.0f, 1.0f), TargetProperty.scale));
        this._showNewImageBase = new KeyFrameAnimation(false);
        this._showNewImageBase.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        this._showNewImageBase.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this._scrSld.setRelativePosition(0.95f, 0.083333336f);
        this._parrot_astro.setRelativePosition(0.1f, 0.9f);
        this._earth.setOrigin(0.0f, 0.5f);
        this._earth.setRelativePosition(0.1f, 0.5f);
        this._earth.setOpacity(1.0f);
        this._solar.setOpacity(0.0f);
        this._cluster.setOpacity(0.0f);
        this._galaxy.setOpacity(0.0f);
        this._group.setOpacity(0.0f);
        this._filament.setOpacity(0.0f);
        this.setOpacity(0.0f);
        this._compScale = 1.0 - (double)PlayerData.getPlayerComplex() / (double)PlayerData.DetectorSite.getComplexometerCredits() * 0.3;
    }

    @Override
    public void PreHide() {
        if (!this.scoreBtnClicked) {
            this.showingScores = false;
        }
    }

    @Override
    public void PreShow() {
        this.setOpacity(0.0f);
        this.scoreBtnClicked = false;
        GameScreen.setChangeMusic(this.music, 2.0f);
        if (!this.showingScores) {
            GameScreen.hideHUD();
            this._btnTweet.setVisible(false);
            this._ss.setVisible(false);
            this._nn.setVisible(false);
            this._bb.setVisible(false);
            this._numS.setVisible(false);
            this._numNN.setVisible(false);
            this._numBB.setVisible(false);
            this._btnScores.setVisible(false);
            this._btnMainMenu.setVisible(false);
            this._btnTryAgain.setVisible(false);
            this._parrot_astro.ShowPerch(false);
            this._parrot_astro.ShowHelmet(true);
            this._parrotWobble = new KeyFrameAnimation(true, this._parrot_astro);
            this._parrotWobble.AddKeyFrame(new PVectorKeyFrame(0.0f, this._parrot_astro.getX(), 0.9f * (float)this.getHeight(), TargetProperty.position, EasingFunctions.EaseInOut));
            this._parrotWobble.AddKeyFrame(new PVectorKeyFrame(3.0f, this._parrot_astro.getX(), 0.9f * (float)this.getHeight() + (float)this.getHeight() * 0.06f, TargetProperty.position, EasingFunctions.EaseInOut));
            this._parrotWobble.AddKeyFrame(new PVectorKeyFrame(6.0f, this._parrot_astro.getX(), 0.9f * (float)this.getHeight(), TargetProperty.position));
            this._parrotWobble.Start();
            this._dist = 1.0;
            this._ScoreDist = 3.08568025E22 * ScoreCalculator.getDetectorDistance() * this._compScale;
            this._earth.setOpacity(1.0f);
            this._solar.setOpacity(0.0f);
            this._cluster.setOpacity(0.0f);
            this._galaxy.setOpacity(0.0f);
            this._group.setOpacity(0.0f);
            this._filament.setOpacity(0.0f);
            this.b6 = true;
            this.b5 = true;
            this.b4 = true;
            this.b3 = true;
            this.b2 = true;
            this.b1 = true;
        }
    }

    @Override
    public void PostShow() {
        if (!this.showingScores) {
            this.run = true;
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_intro"), 300, 80, true);
        }
    }

    @Override
    public void update(float f) {
        super.update(f);
        if (this._showImg != null) {
            this._showImg.Update(f);
        }
        if (this._parrotWobble != null) {
            this._parrotWobble.Update(f);
        }
        this._inc = this._dist < this.EarthLim ? (double)(2.0f / this._app.frameRate) : (this._dist < this.SolarLim ? (double)(3.0f / this._app.frameRate) : (this._dist < this.ClusterLim ? (double)(2.0f / this._app.frameRate) : (this._dist < this.GalaxyLim ? (double)(1.0f / this._app.frameRate) : (this._dist < this.GroupLim ? (double)(1.0f / this._app.frameRate) : (double)(1.0f / this._app.frameRate)))));
        if (this._dist < this._ScoreDist && this.run) {
            this._dist = Math.pow(10.0, Math.log10(this._dist) + this._inc);
        } else if (this.b6 && this.run) {
            this.b6 = false;
            this.OnScoreReached();
        }
        if (this._dist > this._ScoreDist) {
            this._dist = this._ScoreDist;
        }
        int n = HighScores.calc_Num_Supernovae(this._dist);
        int n2 = HighScores.calc_Num_nn_binary(this._dist);
        int n3 = HighScores.calc_Num_bb_binary(this._dist);
        if (n > 0) {
            this._numS.setText(" x " + n);
            this._numS.setVisible(true);
            this._ss.setVisible(true);
            if (this.numS == 0) {
                this._showss.Start();
            }
            this.numS = n;
        }
        if (n2 > 0) {
            this._numNN.setText(" x " + n2);
            this._nn.setVisible(true);
            this._numNN.setVisible(true);
            if (this.numNN == 0) {
                this._shownn.Start();
            }
            this.numNN = n2;
        }
        if (n3 > 0) {
            this._numBB.setText(" x " + n3);
            this._bb.setVisible(true);
            this._numBB.setVisible(true);
            if (this.numBB == 0) {
                this._showbb.Start();
            }
            this.numBB = n3;
        }
        if (this._dist < this.EarthLim) {
            this._scrSld.setLabel(this.frmKm.format(this._dist));
            this._scrSld.setPosition((float)(0.1666666716337204 * (this._dist / this.EarthLim)));
        } else if (this._dist < this.SolarLim) {
            this._scrSld.setLabel(this.frmAu.format(this._dist / 1.49598E8));
            this._scrSld.setPosition((float)(0.1666666716337204 + 0.1666666716337204 * (this._dist / this.SolarLim)));
        } else if (this._dist < this.ClusterLim) {
            this._scrSld.setLabel(this.frmPC.format(this._dist / 3.08568025E16));
            this._scrSld.setPosition((float)(0.3333333432674408 + 0.1666666716337204 * (this._dist / this.ClusterLim)));
        } else if (this._dist < this.GalaxyLim) {
            this._scrSld.setLabel(this.frmKPC.format(this._dist / 3.08568025E19));
            this._scrSld.setPosition((float)(0.5 + 0.1666666716337204 * (this._dist / this.GalaxyLim)));
        } else if (this._dist < this.GroupLim) {
            this._scrSld.setLabel(this.frmKPC.format(this._dist / 3.08568025E19));
            this._scrSld.setPosition((float)(0.6666666865348816 + 0.1666666716337204 * (this._dist / this.GroupLim)));
        } else {
            this._scrSld.setLabel(this.frmMPC.format(this._dist / 3.08568025E22));
            if (this._dist < this.FilamentLim) {
                this._scrSld.setPosition((float)(0.8333333134651184 + 0.1666666716337204 * (this._dist / this.FilamentLim)));
            }
        }
        if (this._dist >= this.EarthLim * (double)0.97f && this.b1) {
            this._showImg = this._showNewImageBase.duplicate(false, false);
            this._showImg.AddTargetObject(this._solar);
            this._showImg.Start();
            this.b1 = false;
        } else if (this._dist >= this.SolarLim * (double)0.97f && this.b2) {
            this._showImg = this._showNewImageBase.duplicate(false, false);
            this._showImg.AddTargetObject(this._cluster);
            this._showImg.Start();
            this.b2 = false;
        } else if (this._dist >= this.ClusterLim * (double)0.97f && this.b3) {
            this._showImg = this._showNewImageBase.duplicate(false, false);
            this._showImg.AddTargetObject(this._galaxy);
            this._showImg.Start();
            this.b3 = false;
        } else if (this._dist >= this.GalaxyLim * (double)0.97f && this.b4) {
            this._showImg = this._showNewImageBase.duplicate(false, false);
            this._showImg.AddTargetObject(this._group);
            this._showImg.Start();
            this.b4 = false;
        } else if (this._dist >= this.GroupLim * (double)0.97f && this.b5) {
            this._showImg = this._showNewImageBase.duplicate(false, false);
            this._showImg.AddTargetObject(this._filament);
            this._showImg.Start();
            this.b5 = false;
        }
    }

    public void OnScoreReached() {
        this._btnTweet.setVisible(true);
        this._btnScores.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(0, 0, 0));
        this._btnMainMenu.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(0, 0, 0));
        this._btnTryAgain.setTextColours(new GWColour(1.0f, 1.0f, 1.0f), new GWColour(1.0f, 0.0f, 0.0f), new GWColour(0, 0, 0));
        if (this._dist < this.EarthLim) {
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_earth"), 300, 200, true);
        } else if (this._dist < this.SolarLim) {
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_solar"), 300, 200, true);
        } else if (this._dist < this.ClusterLim) {
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_cluster"), 320, 200, true);
        } else if (this._dist < this.GalaxyLim) {
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_galaxy"), 300, 200, true);
        } else if (this._dist < this.GroupLim) {
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_group"), 300, 200, true);
        } else if (this._dist < this.FilamentLim) {
            this._btnScores.setTextColours(new GWColour(0.0f, 0.0f, 0.0f), new GWColour(0.0f, 0.0f, 1.0f), new GWColour(0, 0, 0));
            this._btnMainMenu.setTextColours(new GWColour(0.0f, 0.0f, 0.0f), new GWColour(0.0f, 0.0f, 1.0f), new GWColour(0, 0, 0));
            this._btnTryAgain.setTextColours(new GWColour(0.0f, 0.0f, 0.0f), new GWColour(0.0f, 0.0f, 1.0f), new GWColour(0, 0, 0));
            this._parrot_astro.ShowExtraBubble(Language.getString("Final_filament"), 300, 220, true);
        }
        this.numS = HighScores.calc_Num_Supernovae(this._dist);
        this.numNN = HighScores.calc_Num_nn_binary(this._dist);
        this.numBB = HighScores.calc_Num_bb_binary(this._dist);
        PlayerData.PlayerHighScorePosition = HighScores.SaveScore(PlayerData.PlayerName, PlayerData.DetectorName, this._dist.toString(), this.numS, this.numNN, this.numBB);
        if (PlayerData.PlayerHighScorePosition == -1) {
            this.okdiag.show();
        }
        this._btnScores.setVisible(true);
        this._btnMainMenu.setVisible(true);
        this._btnTryAgain.setVisible(true);
    }

    private class OnButtonClick
    implements ButtonElement.IButtonCallback {
        private OnButtonClick() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (buttonElement == FinalScore.this._btnScores) {
                HighScoreScreen highScoreScreen = (HighScoreScreen)GameScreen.getPage("Scores");
                highScoreScreen.FromIntroPage = false;
                FinalScore.this.showingScores = true;
                FinalScore.this.scoreBtnClicked = true;
                GameScreen.showPage("Scores");
            } else if (buttonElement == FinalScore.this._btnMainMenu) {
                GameScreen.showPage("Intro");
            } else if (buttonElement == FinalScore.this._btnTryAgain) {
                GameScreen.showHUD();
                GameScreen.showPage("PIOffice");
            } else if (buttonElement == FinalScore.this._btnTweet) {
                String string = "https://twitter.com/intent/tweet?";
                String string2 = String.format(Language.getString("Tweet_Message"), FinalScore.this.numS, FinalScore.this.numNN, FinalScore.this.numBB);
                string = string + "url=" + URLEncoder.encode("http://gwoptics.org/stq_highscore/");
                string = string + "&text=" + URLEncoder.encode(string2);
                string = string + "&hashtags=SpaceTimeQuest";
                if (GameScreen.args.containsKey("tag")) {
                    string = string + "," + GameScreen.args.get("tag");
                }
                string = string + "&related=gwoptics";
                FinalScore.this._app.link(string);
            }
        }
    }

    private class OnShowScoreItem
    implements IAnimationCompleteCallback {
        private OnShowScoreItem() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            if (keyFrameAnimation == FinalScore.this._showss) {
                FinalScore.this._ss.setVisible(true);
                FinalScore.this._numS.setVisible(true);
            } else if (keyFrameAnimation == FinalScore.this._shownn) {
                FinalScore.this._nn.setVisible(true);
                FinalScore.this._numNN.setVisible(true);
            } else if (keyFrameAnimation == FinalScore.this._showbb) {
                FinalScore.this._bb.setVisible(true);
                FinalScore.this._numBB.setVisible(true);
            }
        }
    }

    private class OnOk
    implements ButtonElement.IButtonCallback {
        private OnOk() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            FinalScore.this.okdiag.hide();
        }
    }

    private class ScoreSlider
    extends ScreenElement {
        private PImage _endTop;
        private PImage _endBottom;
        private PImage _mid;
        private PImage _mid_full;
        private PImage _handle;
        private float pos;
        private GLabel _lbl;

        public ScoreSlider(ScreenElement screenElement, PApplet pApplet) {
            super(screenElement, pApplet);
            this.pos = 0.0f;
        }

        @Override
        public void loadResources() {
            this._endTop = ResourceManager.LoadImage("Slider/end_left.png");
            this._endBottom = ResourceManager.LoadImage("Slider/end_right_full.png");
            this._mid = ResourceManager.LoadImage("Slider/centre.png");
            this._mid_full = ResourceManager.LoadImage("Slider/centre_full.png");
            this._handle = ResourceManager.LoadImage("Slider/handle.png");
            this.setBounds(this._endTop.width, this._endTop.height * 2 + 500);
        }

        public void setPosition(float f) {
            this.pos = f;
        }

        public void setLabel(String string) {
            this._lbl.setText(Language.getString("Final_eff_range") + ": " + string);
        }

        @Override
        public void setup() {
            this._lbl = new GLabel(this, this._app, "80Mpc", 1.0f, 1.0f, 800);
            this._lbl.setOrigin(1.0f, 0.5f);
            this._lbl.setTextAlign(2);
            this._lbl.setFont(Language.getString("Font_Default"), 22);
            this.addChild(this._lbl);
        }

        @Override
        public void update(float f) {
            FinalScore.this._showss.Update(f);
            FinalScore.this._shownn.Update(f);
            FinalScore.this._showbb.Update(f);
        }

        @Override
        public void render() {
            this._app.translate(this._endTop.height, 0.0f);
            this._app.pushMatrix();
            this._app.rotate(1.5707964f);
            this._app.image(this._endTop, 0.0f, 0.0f);
            this._app.pushMatrix();
            this._app.translate(this._endTop.width, 0.0f);
            this._app.scale(500.0f, 1.0f);
            this._app.image(this._mid, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.stroke(255, this.getAbsoluteOpacity() * 255.0f);
            this._app.line((float)(this._endTop.width - this._handle.width / 2) + 83.333336f, -5.0f, (float)(this._endTop.width - this._handle.width / 2) + 83.333336f, this._endTop.height + 5);
            this._app.line((float)(this._endTop.width - this._handle.width / 2) + 166.66667f, -5.0f, (float)(this._endTop.width - this._handle.width / 2) + 166.66667f, this._endTop.height + 5);
            this._app.line((float)(this._endTop.width - this._handle.width / 2) + 250.0f, -5.0f, (float)(this._endTop.width - this._handle.width / 2) + 250.0f, this._endTop.height + 5);
            this._app.line((float)(this._endTop.width - this._handle.width / 2) + 333.33334f, -5.0f, (float)(this._endTop.width - this._handle.width / 2) + 333.33334f, this._endTop.height + 5);
            this._app.line((float)(this._endTop.width - this._handle.width / 2) + 416.66666f, -5.0f, (float)(this._endTop.width - this._handle.width / 2) + 416.66666f, this._endTop.height + 5);
            this._app.pushMatrix();
            this._app.translate((float)this._endTop.width + 500.0f * (1.0f - this.pos), 0.0f);
            this._app.scale(500.0f * this.pos, 1.0f);
            this._app.image(this._mid_full, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.image(this._endBottom, 500 + this._endTop.width, 0.0f);
            this._app.image(this._handle, 500.0f * (1.0f - this.pos) - 0.5f * (float)this._handle.width, (float)(-(this._handle.height - this._mid.height)) * 0.5f);
            this._lbl.setRelativePosition(-5.0f, 0.0f);
            this._app.popMatrix();
        }
    }
}

