/*
 * Decompiled with CFR 0.152.
 */
package game;

import core.GameScreen;
import core.ImageElement;
import core.LoadingPage;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.GLabel;
import core.language.Language;
import game.PlayerData;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class BSFLoadPage
extends LoadingPage {
    static final String Version_string = GameScreen.getVersionString();
    GLabel _title;
    GLabel _version;
    KeyFrameAnimation _steam;
    ImageElement _imgLaserBox;
    ImageElement _imgCoffee;
    ImageElement _imgSteam;
    private PImage _imgBack;
    int x;
    int y;
    int w;
    int h;

    public BSFLoadPage(PApplet pApplet) {
        super(pApplet);
        PlayerData.setToDefaults();
        this.x = (int)((float)this._app.width * 0.05f);
        this.y = (int)((float)this._app.height * 0.9f);
        this.w = (int)((float)this._app.width * 0.9f);
        this.h = (int)((float)this._app.height * 0.02f);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation();
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(1.0f, Float.valueOf(1.0f), TargetProperty.opacity, EasingFunctions.EaseOut));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(3.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        keyFrameAnimation.AddTargetObject(this);
        this.setRelativePosition(0.0f, -1.0f);
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation();
        keyFrameAnimation2.AddKeyFrame(new PVectorKeyFrame(0.0f, new PVector(0.0f, -600.0f), TargetProperty.position, EasingFunctions.EaseOut));
        keyFrameAnimation2.AddKeyFrame(new PVectorKeyFrame(1.0f, new PVector(0.0f, -4.0f), TargetProperty.position));
        keyFrameAnimation2.AddTargetObject(this);
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        this._imgCoffee = new ImageElement("coffeecup_loading.png", this, pApplet);
        this._imgLaserBox = new ImageElement("laserbox_loading.png", this, pApplet);
        this._imgSteam = new ImageElement("steam.png", this, pApplet);
        this._imgBack = this._app.loadImage("loading.png");
        this._imgCoffee.loadResources();
        this._imgLaserBox.loadResources();
        this._imgSteam.loadResources();
        this._imgSteam.setOrigin(0.5f, 1.0f);
        this._imgSteam.setRelativePosition(0.18f, 0.72f);
        this._imgSteam.setOpacity(0.0f);
        this._imgLaserBox.setOrigin(0.185f, 0.63975155f);
        this._imgLaserBox.setRelativePosition(0.7f, 0.5f);
        this._imgCoffee.setOrigin(0.4f, 0.3f);
        this._imgCoffee.setRelativePosition(0.18f, 0.72f);
        this._steam = new KeyFrameAnimation(false, this._imgSteam, new SteamShowComplete());
        this._steam.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity, EasingFunctions.EaseIn));
        this._steam.AddKeyFrame(new FloatKeyFrame(1.2f, Float.valueOf(0.8f), TargetProperty.opacity));
        this._title = new GLabel(this, pApplet, Language.getString("loading") + "...", 0.1f, 0.1f, 200);
        this._title.setFont(Language.getString("Font_Default"), 45);
        String string = "";
        if (GameScreen.args.containsKey("tag")) {
            string = "    Event Tag: " + GameScreen.args.get("tag");
        }
        this._version = new GLabel(this, pApplet, "v" + Version_string + string, 0.02f, 0.98f, 200);
        this._version.setOrigin(0.0f, 1.0f);
        this._version.setFont(Language.getString("Font_Default"), 20);
        this._version.setColour(0.6f, 0.6f, 0.6f);
        this.addChild(this._imgCoffee);
        this.addChild(this._imgSteam);
        this.addChild(this._title);
        this.addChild(this._version);
    }

    @Override
    public void render() {
        if (this._imgBack != null) {
            this._app.image(this._imgBack, 0.0f, 0.0f);
        }
        this._app.pushStyle();
        this._app.translate(0.0f, 0.0f, 0.001f);
        this._app.strokeWeight(40.0f);
        this._app.stroke(255.0f, 0.0f, 0.0f, 5.0f * this.getOpacity());
        this._app.strokeCap(2);
        this._app.line(674.0f, 270.0f, 674.0f + -478.0f * this.getPercentageDone(), 270.0f + 205.0f * this.getPercentageDone());
        this._app.strokeWeight(30.0f);
        this._app.stroke(255.0f, 0.0f, 0.0f, 10.0f * this.getOpacity());
        this._app.strokeCap(2);
        this._app.line(674.0f, 270.0f, 674.0f + -478.0f * this.getPercentageDone(), 270.0f + 205.0f * this.getPercentageDone());
        this._app.strokeWeight(16.0f);
        this._app.stroke(255.0f, 0.0f, 0.0f, 50.0f * this.getOpacity());
        this._app.strokeCap(2);
        this._app.line(684.0f, 240.0f, 684.0f + -478.0f * this.getPercentageDone(), 240.0f + 195.0f * this.getPercentageDone());
        this._app.strokeWeight(10.0f);
        this._app.stroke(255.0f, 0.0f, 0.0f, 100.0f * this.getOpacity());
        this._app.strokeCap(2);
        this._app.line(684.0f, 240.0f, 684.0f + -478.0f * this.getPercentageDone(), 240.0f + 195.0f * this.getPercentageDone());
        this._app.strokeWeight(6.0f);
        this._app.stroke(255.0f, 0.0f, 0.0f, 200.0f * this.getOpacity());
        this._app.strokeCap(2);
        this._app.line(684.0f, 240.0f, 684.0f + -478.0f * this.getPercentageDone(), 240.0f + 195.0f * this.getPercentageDone());
        this._app.strokeWeight(1.0f);
        this._app.stroke(255.0f, 255.0f, 255.0f, 200.0f * this.getOpacity());
        this._app.strokeCap(2);
        this._app.line(684.0f, 240.0f, 684.0f + -478.0f * this.getPercentageDone(), 240.0f + 195.0f * this.getPercentageDone());
        this._app.popStyle();
    }

    @Override
    public void OnLoadComplete() {
        PApplet.println("Load Completed");
        this._steam.Start();
    }

    @Override
    public void update(float f) {
        super.update(f);
        this._steam.Update(f);
    }

    @Override
    public void SetLoadingText(String string) {
        PApplet.println(string);
    }

    private class SteamShowComplete
    implements IAnimationCompleteCallback {
        private SteamShowComplete() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            GameScreen.showPage("Intro");
        }
    }
}

