/*
 * Decompiled with CFR 0.152.
 */
package core.language;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import processing.core.PApplet;

public class Language {
    private static HashMap<String, String> _dict_strings;
    private static char[] character_set;
    private static Languages _lang;
    private static String _language_file;
    private static boolean checked;
    private static String NOT_ADDED;

    public Language(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new RuntimeException("Game text xml file was empty or null");
        }
        _dict_strings = new HashMap();
        _language_file = string;
    }

    public static char[] getCharacterSet() {
        return character_set;
    }

    public void loadLanguage(Languages languages) {
        Serializable serializable;
        try {
            _lang = languages;
            serializable = this.getClass().getResource("/data/" + _language_file);
            if (serializable == null) {
                throw new RuntimeException("XML Language file for game text does not exist: " + _language_file);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(((URL)serializable).toString());
            document.getDocumentElement().normalize();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.compile("//String[@id]/" + _lang.toString()).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = _lang.toString();
                Element element = (Element)node.getParentNode();
                String string2 = element.getAttribute("id");
                _dict_strings.put(string2, node.getTextContent().replaceAll("\\\\n", System.getProperty("line.separator")));
                PApplet.println("Loading string " + string2);
            }
            PApplet.println("----- Language loading done -----");
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        this.checkStrings();
        serializable = new ArrayList(0);
        switch (languages) {
            case Chinese: {
                this.addStandardCharactersToSet((ArrayList<Character>)serializable);
                this.makeChineseFont((ArrayList<Character>)serializable);
            }
        }
        character_set = new char[((ArrayList)serializable).size()];
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            Language.character_set[i] = ((Character)((ArrayList)serializable).get(i)).charValue();
        }
    }

    public static String getString(String string) {
        String string2;
        if (_dict_strings.containsKey(string)) {
            string2 = _dict_strings.get(string);
        } else if (!checked) {
            _dict_strings.put(string, NOT_ADDED);
            string2 = _dict_strings.get(string);
        } else {
            throw new RuntimeException("Could not find the string with key " + string + " in the language xml text file.");
        }
        return string2;
    }

    public void checkStrings() {
        boolean bl = false;
        for (Map.Entry<String, String> entry : _dict_strings.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(NOT_ADDED)) continue;
            PApplet.println("Could not find the key " + entry.getKey() + " for lanaguage: " + _lang.toString());
            bl = true;
        }
        if (bl) {
            throw new RuntimeException("Found missing multilingual strings, please check console output.");
        }
        checked = true;
    }

    public void addStandardCharactersToSet(ArrayList<Character> arrayList) {
        for (char c = '\u0000'; c <= '\u007f'; c = (char)(c + '\u0001')) {
            arrayList.add(Character.valueOf(c));
        }
    }

    public void makeChineseFont(ArrayList<Character> arrayList) {
        PApplet.print("Creating Chinese font...");
        HashMap<Character, Boolean> hashMap = new HashMap<Character, Boolean>();
        for (Map.Entry<String, String> entry : _dict_strings.entrySet()) {
            char[] cArray;
            for (char c : cArray = entry.getValue().toCharArray()) {
                hashMap.put(Character.valueOf(c), true);
            }
        }
        Character[] characterArray = hashMap.keySet().toArray(new Character[hashMap.keySet().size()]);
        for (int i = 0; i < characterArray.length; ++i) {
            arrayList.add(characterArray[i]);
        }
        PApplet.println("Done");
    }

    static {
        _lang = Languages.English;
        checked = false;
        NOT_ADDED = "NOT_ADDED_KEY!!!";
    }

    public static enum Languages {
        English,
        Spanish,
        Catalan,
        Chinese,
        Dutch;

    }
}

