/*
 * Decompiled with CFR 0.152.
 */
package core.gui;

import core.ScreenElement;
import guicomponents.GFont;
import java.awt.Color;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;

public class TextBlockElement
extends ScreenElement {
    private String _fntName;
    private String _txt;
    private PFont _fnt;
    private int _txtSize;
    private int _txtHAlign;
    private int _txtVAlign;
    private int _margin;
    private Color _txtColour;
    private int _mode = 4;

    public TextBlockElement(ScreenElement screenElement, PApplet pApplet, String string, String string2, int n, float f, float f2) {
        super(screenElement, pApplet);
        this._txt = string2;
        this._fntName = string;
        this._txtSize = n;
        this._txtHAlign = 37;
        this._txtVAlign = 101;
        this._margin = 0;
        this._txtColour = new Color(1.0f, 1.0f, 1.0f);
        this.setRelativeBounds(f, f2);
    }

    @Override
    public void loadResources() {
        this.setFont(this._fntName, this._txtSize);
    }

    public void setFont(String string, int n) {
        this._fntName = string;
        this._txtSize = n;
        this._fnt = GFont.getFont(this._app, string, this._txtSize);
        if (this._fnt == null) {
            throw new RuntimeException("Could not load the font: " + string + " for the TextBlock");
        }
    }

    @Override
    public void render() {
        int n = this.getWidth() - this._margin;
        int n2 = this.getHeight() - this._margin;
        if (n >= 0 && n2 >= 0) {
            PVector pVector = this._mode == 256 ? this.getAbsolutePosition() : new PVector(0.0f, 0.0f);
            this._app.pushStyle();
            this._app.noStroke();
            this._app.fill(this._txtColour.getRed(), this._txtColour.getGreen(), this._txtColour.getBlue(), 255.0f * this.getAbsoluteOpacity());
            this._app.textAlign(this._txtHAlign, this._txtVAlign);
            this._app.textMode(this._mode);
            this._app.textFont(this._fnt);
            if (this._txt != null) {
                this._app.text(this._txt, pVector.x + (float)this._margin, pVector.y + (float)this._margin, (float)n, (float)n2);
            }
            this._app.popStyle();
        }
    }

    public void setText(String string) {
        this._txt = string;
    }

    public void setFontColour(float f, float f2, float f3) {
        this._txtColour = new Color(f, f2, f3);
    }

    public void setMargin(int n) {
        this._margin = 5;
    }
}

