/*
 * Decompiled with CFR 0.152.
 */
package core.gui;

import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.IntKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.TextBlockElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;

public class SpeechBubbleElement
extends ScreenElement {
    PImage corner;
    PImage side;
    PImage sideFlip;
    PImage pointer;
    KeyFrameAnimation _showBubble;
    KeyFrameAnimation _hideBubble;
    KeyFrameAnimation _showContent;
    ButtonElement _btnClose;
    TextBlockElement _txt;
    private ArrayList<String> _textData;
    private boolean _bubbleTickLeft = true;
    AudioPlayer popClose;

    public SpeechBubbleElement(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this._txt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), "", 18, 0.9f, 0.9f);
        this._txt.setRelativePosition(0.05f, 0.05f);
        this._txt.setFontColour(0.0f, 0.0f, 0.0f);
        this._textData = new ArrayList();
        this.setClickable(true);
        this._btnClose = new ButtonElement(this, pApplet, "speechbubble/close.png", "speechbubble/close_over.png", "speechbubble/close_down.png");
        this.addChild(this._txt);
        this.addChild(this._btnClose);
    }

    @Override
    public void loadResources() {
        this.corner = ResourceManager.LoadImage("speechbubble/corner.png");
        this.side = ResourceManager.LoadImage("speechbubble/edge.png");
        this.sideFlip = ResourceManager.LoadImage("speechbubble/edgeFlip.png");
        this.pointer = ResourceManager.LoadImage("speechbubble/pointer.png");
        this.popClose = ResourceManager.LoadAudio("audio/97978__oldedgar__Pop_editted.mp3");
    }

    @Override
    public void setup() {
        this._showContent = new KeyFrameAnimation(false, this._txt);
        this._showContent.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity, EasingFunctions.EaseInOut));
        this._showContent.AddKeyFrame(new FloatKeyFrame(0.2f, Float.valueOf(1.0f), TargetProperty.opacity));
        this._hideBubble = new KeyFrameAnimation(false, this, new HideContent());
        this._hideBubble.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity, EasingFunctions.EaseInOut));
        this._hideBubble.AddKeyFrame(new FloatKeyFrame(0.2f, Float.valueOf(0.0f), TargetProperty.opacity));
        this._btnClose.setCallback(new CloseButtonClicked());
        this._btnClose.setVisible(false);
        this._btnClose.setOrigin(1.0f, 0.0f);
    }

    public void Show(int n, int n2) {
        this.setVisible(true);
        this.setClickable(true);
        this.setOpacity(1.0f);
        this._txt.setOpacity(0.0f);
        this._showBubble = new KeyFrameAnimation(false, this, new ShowContent());
        this._showBubble.AddKeyFrame(new IntKeyFrame(0.0f, 150, TargetProperty.width, EasingFunctions.EaseInOut));
        this._showBubble.AddKeyFrame(new IntKeyFrame(0.0f, 50, TargetProperty.height, EasingFunctions.EaseInOut));
        this._showBubble.AddKeyFrame(new IntKeyFrame(0.3f, n, TargetProperty.width));
        this._showBubble.AddKeyFrame(new IntKeyFrame(0.3f, n2, TargetProperty.height));
        this._showBubble.Start();
    }

    public void Hide() {
        this._hideBubble.Start();
        if (this.isVisible() && this.popClose != null) {
            this.popClose.cue(0);
            this.popClose.play();
        }
    }

    public void setText(String string) {
        this.clearAllText();
        this._textData.add(string);
    }

    public void setText(ArrayList<String> arrayList) {
        this._textData.addAll(arrayList);
    }

    public void clearAllText() {
        this._textData.clear();
    }

    public void setPointerToLeft(boolean bl) {
        this._bubbleTickLeft = bl;
    }

    public void NextText() {
        if (this._textData.size() > 0) {
            this._textData.remove(0);
        }
    }

    @Override
    public void onMouseEvent(int n, int n2) {
        if (n == 502) {
            this.Hide();
        }
    }

    @Override
    public void update(float f) {
        if (this._showBubble != null) {
            this._showBubble.Update(f);
        }
        if (this._hideBubble != null) {
            this._hideBubble.Update(f);
        }
        if (this._showContent != null) {
            this._showContent.Update(f);
        }
        if (this._textData.size() > 0) {
            this._txt.setText(this._textData.get(0));
        }
        this._btnClose.setPosition(this.getWidth() + (int)((double)this.corner.width * 0.5) - 2, -((int)((double)this.corner.width * 0.5)) + 2);
    }

    @Override
    public void render() {
        int n;
        if (this.pointer != null) {
            if (this._bubbleTickLeft) {
                this._app.pushMatrix();
                this._app.translate(this.corner.width, this.getHeight() - 1);
                this._app.noStroke();
                this._app.image(this.pointer, 0.0f, 0.0f);
                this._app.popMatrix();
            } else {
                this._app.pushMatrix();
                this._app.translate(this.getWidth() - this.corner.width, this.getHeight());
                this._app.scale(-1.0f, 1.0f);
                this._app.noStroke();
                this._app.image(this.pointer, 0.0f, 0.0f);
                this._app.popMatrix();
            }
        }
        if (this.side != null) {
            n = 0;
            int n2 = 36;
            this._app.pushMatrix();
            this._app.translate((float)((double)n2 * 0.5), 0.0f);
            this._app.scale(this.getWidth() - n2, 1.0f);
            this._app.noStroke();
            this._app.image(this.side, 0.0f, -this.side.height + n);
            this._app.image(this.sideFlip, 0.0f, this.getHeight() + n);
            this._app.popMatrix();
            this._app.pushMatrix();
            this._app.translate(0.0f, (float)((double)n2 * 0.5));
            this._app.scale(1.0f, this.getHeight() - n2);
            this._app.rotate(1.5707964f);
            this._app.noStroke();
            this._app.image(this.sideFlip, 0.0f, n);
            this._app.image(this.side, 0.0f, -this.getWidth() - this.side.height + n);
            this._app.popMatrix();
        }
        if (this.corner != null) {
            this._app.pushMatrix();
            n = (int)((double)this.corner.width * 0.5) - 2;
            this._app.image(this.corner, -n, -n);
            this._app.pushMatrix();
            this._app.translate(this.getWidth() + n, -n);
            this._app.rotate(1.5707964f);
            this._app.noStroke();
            this._app.image(this.corner, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.pushMatrix();
            this._app.translate(this.getWidth() + n, this.getHeight() + n);
            this._app.rotate((float)Math.PI);
            this._app.noStroke();
            this._app.image(this.corner, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.pushMatrix();
            this._app.translate(-n, this.getHeight() + n);
            this._app.rotate(4.712389f);
            this._app.noStroke();
            this._app.image(this.corner, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.popMatrix();
        }
        this._app.pushStyle();
        this._app.noStroke();
        this._app.fill(255, 255.0f * this.getAbsoluteOpacity());
        this._app.rect(0.0f, -1.0f, this.getWidth() + 5, this.getHeight() + 2);
        this._app.popStyle();
    }

    private class HideContent
    implements IAnimationCompleteCallback {
        private HideContent() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            SpeechBubbleElement.this.setVisible(false);
            SpeechBubbleElement.this.setClickable(false);
        }
    }

    private class ShowContent
    implements IAnimationCompleteCallback {
        private ShowContent() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            SpeechBubbleElement.this._btnClose.setVisible(true);
            SpeechBubbleElement.this._showContent.Start();
        }
    }

    private class CloseButtonClicked
    implements ButtonElement.IButtonCallback {
        private CloseButtonClicked() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            SpeechBubbleElement.this.Hide();
        }
    }
}

