/*
 * Decompiled with CFR 0.152.
 */
package core.gui;

import core.ScreenElement;
import guicomponents.GFont;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GWSlider
extends GSlider {
    public String unit;
    protected PImage _leftEnd;
    protected PImage _thumb;
    protected PImage _thumb_mouseover;
    protected PImage _rightEnd;
    protected PImage _centre;
    protected String _skin;
    protected int _numTicks;
    protected int _tickLength;
    protected int _tickOffset;
    protected int _precision;
    protected boolean _renderMaxMinLabel;
    protected boolean _renderValueLabel;
    protected boolean _stickToTicks;
    protected String[] _tickLabels;
    protected boolean _isMouseOverThumb;
    protected boolean _mousePressedOverThumb;
    protected int[] _tickPositions;
    protected float[] _tickValues;
    protected int _tickColour;
    protected int _fontColour;
    protected int _currTickStuck;

    public void setPrecision(int n) {
        this._precision = PApplet.constrain(n, 0, 6);
    }

    public void setValueType(int n) {
        this._valueType = n;
    }

    @Override
    public void setValue(int n) {
        this.value = PApplet.constrain((float)n, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    @Override
    public void setValue(float f) {
        this.value = PApplet.constrain(f, this.minValue, this.maxValue);
        this.thumbTargetPos = (int)PApplet.map(this.value, this.minValue, this.maxValue, this.thumbMin, this.thumbMax);
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setValueToTickNumber(int n) {
        if (this._stickToTicks) {
            n = PApplet.constrain(n, 0, this._numTicks);
            float f = PApplet.map(n, 0.0f, this._numTicks, this.minValue, this.maxValue);
            this._stickToTickByValue(f);
        }
    }

    public void setTickCount(int n) {
        this._numTicks = n;
        this._tickLabels = null;
        this._calcTickPositions();
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setTickLabels(String[] stringArray) {
        this._tickLabels = stringArray;
        this._numTicks = stringArray.length - 1;
        this._calcTickPositions();
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setStickToTicks(boolean bl) {
        this._stickToTicks = bl;
        if (bl) {
            this._stickToTickByValue(this.value);
        }
        this._calcTickPositions();
    }

    public void setTickLength(int n) {
        this._tickLength = PApplet.constrain(n, 1, 10);
        this._calcControlWidthHeight();
    }

    public void setRenderMaxMinLabel(boolean bl) {
        this._renderMaxMinLabel = bl;
        this._calcControlWidthHeight();
    }

    public void setRenderValueLabel(boolean bl) {
        this._renderValueLabel = bl;
    }

    public void setTickColour(int n, int n2, int n3) {
        this.setTickColour(this._app.color(n, n2, n3));
    }

    public void setTickColour(int n) {
        this._tickColour = n;
    }

    public void setFontColour(int n, int n2, int n3) {
        this.setFontColour(this._app.color(n, n2, n3));
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void setFontColour(int n) {
        this._fontColour = n;
    }

    public GWSlider(ScreenElement screenElement, PApplet pApplet, int n, int n2, int n3) {
        this(screenElement, pApplet, "Slider", (float)n, (float)n2, n3);
    }

    public GWSlider(ScreenElement screenElement, PApplet pApplet, String string, float f, float f2, int n) {
        super(screenElement, pApplet, f, f2, n, 1);
        if (n < 1) {
            throw new RuntimeException("Length of slider must be greater than 0.");
        }
        this.createEventHandler(this._app, "handleSliderEvents", new Class[]{GSlider.class});
        this._skin = string == null ? "Slider" : string;
        this._numTicks = 5;
        this._tickLength = 5;
        this._tickOffset = 3;
        this._renderMaxMinLabel = true;
        this._renderValueLabel = true;
        this._stickToTicks = false;
        this._precision = 2;
        this._valueType = 0;
        this._tickColour = this._app.color(0);
        this._fontColour = this._app.color(0);
        this.unit = "";
        this._leftEnd = pApplet.loadImage(this._skin + "/end_left.png");
        this._rightEnd = pApplet.loadImage(this._skin + "/end_right.png");
        this._thumb = pApplet.loadImage(this._skin + "/handle.png");
        this._thumb_mouseover = pApplet.loadImage(this._skin + "/handle_mouseover.png");
        PImage pImage = pApplet.loadImage(this._skin + "/centre.png");
        String string2 = "";
        if (this._leftEnd == null) {
            string2 = string2 + "end_left.png\n";
        }
        if (this._rightEnd == null) {
            string2 = string2 + "end_right.png\n";
        }
        if (this._thumb == null) {
            string2 = string2 + "handle.png\n";
        }
        if (this._thumb_mouseover == null) {
            string2 = string2 + "handle_mouseover.png\n";
        }
        if (pImage == null) {
            string2 = string2 + "centre.png\n";
        }
        if (string2 != "") {
            PApplet.println("The following files could not be found for the skin " + this._skin + ": \n" + string2 + "\nCheck that these files are correctly placed in the data directory under a folder with" + " the same name as the skin used.\n");
        }
        if (pImage.width != 1) {
            PApplet.println("The supplied centre image for this skin is not of width 1px.");
        }
        if (pImage.height != this._leftEnd.height || pImage.height != this._rightEnd.height) {
            PApplet.println("The image components of the slider are not all the same height.");
        }
        this.setHeight(pImage.height);
        int n2 = n - this._leftEnd.width - this._rightEnd.width;
        if (n2 < 0) {
            n2 = 0;
        }
        this._centre = new PImage(n2, pImage.height);
        pImage.loadPixels();
        this._centre.loadPixels();
        for (int i = 0; i < this._centre.height; ++i) {
            for (int j = 0; j < this._centre.width; ++j) {
                this._centre.pixels[i * this._centre.width + j] = pImage.pixels[i];
            }
        }
        this.thumbMin = this._leftEnd.width;
        this.thumbMax = this._leftEnd.width + this._centre.width;
        this.setLimits(50.0f, 0.0f, 100.0f);
        this.localFont = globalFont;
        this._app.textFont(this.localFont);
        this._app.textAlign(3);
        this._calcControlWidthHeight();
        this._calcTickPositions();
        this._app.registerKeyEvent(this);
    }

    protected void _calcControlWidthHeight() {
        this.setWidth(this._leftEnd.width + this._centre.width + this._rightEnd.width);
        this.setHeight(this._centre.height + this._tickLength + this._tickOffset);
        if (this._renderMaxMinLabel) {
            this.setHeight(this.getHeight() + this.localFont.getFont().getSize());
        }
    }

    protected void _calcTickPositions() {
        Point point = new Point();
        this.calcAbsPosition(point);
        float f = this.maxValue - this.minValue;
        float f2 = f / (float)this._numTicks;
        this._tickPositions = new int[this._numTicks + 1];
        this._tickValues = new float[this._numTicks + 1];
        for (int i = 0; i <= this._numTicks; ++i) {
            this._tickPositions[i] = Math.round(PApplet.map(this.minValue + (float)i * f2, this.minValue, this.maxValue, this.thumbMin, this.thumbMax));
            this._tickValues[i] = this.minValue + (float)i * f2;
        }
    }

    protected void _stickToTickByValue(float f) {
        float f2 = this.maxValue - this.minValue;
        float f3 = f2 / (float)this._numTicks;
        int n = Math.round(PApplet.constrain(f - this.minValue, 0.0f, f2) / f3);
        this._currTickStuck = PApplet.constrain(n, 0, this._numTicks);
        this.thumbTargetPos = this._tickPositions[this._currTickStuck];
        this.value = this.minValue + (float)this._currTickStuck * f3;
    }

    protected void _stickToTickByPosition(float f) {
        Point point = new Point();
        this.calcAbsPosition(point);
        float f2 = this.maxValue - this.minValue;
        float f3 = f2 / (float)this._numTicks;
        float f4 = PApplet.map(f, this.thumbMin, this.thumbMax, this.minValue, this.maxValue);
        int n = Math.round((f4 - this.minValue) / f3);
        this._currTickStuck = PApplet.constrain(n, 0, this._tickPositions.length - 1);
        this.thumbTargetPos = this._tickPositions[this._currTickStuck];
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent) {
        if (!(this.isVisible() && this.visible && this.enabled)) {
            return;
        }
        Point point = new Point();
        this.calcAbsPosition(point);
        float f = this.maxValue - this.minValue;
        if (this.isVisible() && f > 0.0f) {
            boolean bl = this.isOver(mouseEvent.getX(), mouseEvent.getY());
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!bl) break;
                    this.takeFocus();
                    if (this.isOverThumb(mouseEvent.getX(), mouseEvent.getY())) {
                        this._mousePressedOverThumb = true;
                        break;
                    }
                    this._mousePressedOverThumb = false;
                    break;
                }
                case 502: {
                    if (focusIsWith == this && bl || this._mousePressedOverThumb) {
                        if (this._stickToTicks) {
                            this._stickToTickByPosition(this._app.mouseX - point.x);
                        } else {
                            this.thumbTargetPos = PApplet.constrain(this._app.mouseX - point.x, this.thumbMin, this.thumbMax);
                        }
                        this._isMouseOverThumb = this.isOverThumb(mouseEvent.getX(), mouseEvent.getY());
                        this._mousePressedOverThumb = false;
                        this.eventType = 771;
                        this.fireEvent();
                        break;
                    }
                    this._isMouseOverThumb = false;
                    this._mousePressedOverThumb = false;
                    break;
                }
                case 506: {
                    if (focusIsWith != this || !this._mousePressedOverThumb) break;
                    this.thumbTargetPos = PApplet.constrain(this._app.mouseX - point.x, this.thumbMin, this.thumbMax);
                    break;
                }
                case 503: {
                    this._isMouseOverThumb = this.isOverThumb(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && this.hasFocus()) {
            if (keyEvent.getKeyCode() == 37) {
                if (this._stickToTicks) {
                    this._currTickStuck = PApplet.constrain(this._currTickStuck - 1, 0, this._tickPositions.length - 1);
                    this.thumbTargetPos = this._tickPositions[this._currTickStuck];
                } else {
                    this.thumbTargetPos = PApplet.constrain(this.thumbTargetPos - 1, this.thumbMin, this.thumbMax);
                }
            } else if (keyEvent.getKeyCode() == 39) {
                if (this._stickToTicks) {
                    this._currTickStuck = PApplet.constrain(this._currTickStuck + 1, 0, this._tickPositions.length - 1);
                    this.thumbTargetPos = this._tickPositions[this._currTickStuck];
                } else {
                    this.thumbTargetPos = PApplet.constrain(this.thumbTargetPos + 1, this.thumbMin, this.thumbMax);
                }
            }
        }
    }

    @Override
    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        float f = (float)((double)this._centre.height * 0.5 - (double)this._thumb.height * 0.5);
        return n >= point.x && n <= point.x + this.getWidth() && (float)n2 >= (float)point.y + f && (float)n2 <= (float)(point.y + this.getHeight()) - f;
    }

    public boolean isOverThumb(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        Rectangle rectangle = new Rectangle((int)((double)(point.x + this.thumbPos) - 0.5 * (double)this._thumb.width - 1.0), (int)((double)point.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height - 1.0), this._thumb.width + 1, this._thumb.height + 1);
        return rectangle.contains(n, n2);
    }

    @Override
    public void setFont(String string, int n) {
        this.localFont = GFont.getFont(this._app, string, n);
    }

    @Override
    public void draw() {
        if (!this.visible || !this.isVisible()) {
            return;
        }
        String string = null;
        switch (this._valueType) {
            case 0: {
                string = "%d%s";
                break;
            }
            case 1: {
                string = "%." + this._precision + "f%s";
                break;
            }
            case 2: {
                string = "%." + this._precision + "E%s";
            }
        }
        Point point = new Point(0, 0);
        this._app.image(this._leftEnd, point.x, point.y);
        this._app.image(this._centre, point.x + this._leftEnd.width, point.y);
        this._app.image(this._rightEnd, point.x + this._leftEnd.width + this._centre.width, point.y);
        this._app.pushStyle();
        this._app.textFont(this.localFont);
        this._app.textAlign(3);
        float f = (float)this._centre.width / (float)this._numTicks;
        this._app.stroke(this._tickColour, 255.0f * this.getAbsoluteOpacity());
        this._app.strokeWeight(1.0f);
        this._app.fill(this._fontColour, 255.0f * this.getAbsoluteOpacity());
        float f2 = point.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getFont().getSize();
        for (int i = 0; i < this._tickPositions.length; ++i) {
            Point point2;
            if (this._tickLabels != null) {
                point2 = new Point(this._tickPositions[i], (int)f2);
                this._app.text(this._tickLabels[i], (float)(point.x + point2.x), (float)point2.y);
            } else if (i == 0 && this._renderMaxMinLabel) {
                point2 = new Point(point.x + this._leftEnd.width + Math.round((float)i * f), point.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getFont().getSize());
                if (this._valueType == 0) {
                    this._app.text(String.format(string, Math.round(this.minValue), this.unit), (float)point2.x, (float)point2.y);
                } else {
                    this._app.text(String.format(string, Float.valueOf(this.minValue), this.unit), (float)point2.x, (float)point2.y);
                }
            } else if (i == this._numTicks && this._renderMaxMinLabel) {
                point2 = new Point(point.x + this._leftEnd.width + Math.round((float)i * f), point.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getFont().getSize());
                if (this._valueType == 0) {
                    this._app.text(String.format(string, Math.round(this.maxValue), this.unit), (float)point2.x, (float)point2.y);
                } else {
                    this._app.text(String.format(string, Float.valueOf(this.maxValue), this.unit), (float)point2.x, (float)point2.y);
                }
            }
            this._app.beginShape(4);
            this._app.vertex(point.x + this._tickPositions[i], point.y + this._centre.height + this._tickOffset);
            this._app.vertex(point.x + this._tickPositions[i], point.y + this._centre.height + this._tickOffset + this._tickLength);
            this._app.endShape();
            this._app.pushStyle();
            this._app.stroke(230, 255.0f * this.getAbsoluteOpacity());
            this._app.beginShape(4);
            this._app.vertex(point.x + this._tickPositions[i] + 1, point.y + this._centre.height + this._tickOffset);
            this._app.vertex(point.x + this._tickPositions[i] + 1, point.y + this._centre.height + this._tickOffset + this._tickLength);
            this._app.endShape();
            this._app.popStyle();
            if (!this._isMouseOverThumb) {
                this._app.image(this._thumb, (long)(point.x + this.thumbPos) - Math.round((double)this._thumb.width * 0.5) + 1L, (float)((double)point.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height));
            } else {
                this._app.image(this._thumb_mouseover, (long)(point.x + this.thumbPos) - Math.round((double)this._thumb_mouseover.width * 0.5) + 1L, (float)((double)point.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb_mouseover.height));
            }
            if (!this._renderValueLabel) continue;
            if (this._valueType == 0) {
                this._app.text(String.format(string, Math.round(this.value), this.unit), (float)(point.x + this.thumbPos), (float)point.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
                continue;
            }
            this._app.text(String.format(string, Float.valueOf(this.value), this.unit), (float)(point.x + this.thumbPos), (float)point.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
        }
        this._app.popStyle();
    }
}

