/*
 * Decompiled with CFR 0.152.
 */
package core.gui;

import core.ResourceManager;
import core.ScreenElement;
import processing.core.PApplet;
import processing.core.PImage;

public class FrameElement
extends ScreenElement {
    PImage corner;
    PImage side;
    float backOpacity = 0.4f;
    float r = 0.5f;
    float g = 0.5f;
    float b = 0.5f;

    public FrameElement(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
    }

    public void setBackOpacity(float f) {
        this.backOpacity = PApplet.constrain(f, 0.0f, 1.0f);
    }

    @Override
    public void loadResources() {
        this.corner = ResourceManager.LoadImage("textboxcorner.png");
        this.side = ResourceManager.LoadImage("textboxbar.png");
    }

    @Override
    public void render() {
        this._app.fill((int)(255.0f * this.r), (int)(255.0f * this.g), (int)(255.0f * this.b), 255.0f * this.backOpacity * this.getAbsoluteOpacity());
        this._app.rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        if (this.side != null) {
            this._app.pushMatrix();
            this._app.scale(this.getWidth(), 1.0f);
            this._app.image(this.side, 0.0f, -this.side.height);
            this._app.image(this.side, 0.0f, this.getHeight());
            this._app.popMatrix();
            this._app.pushMatrix();
            this._app.scale(1.0f, this.getHeight());
            this._app.rotate(1.5707964f);
            this._app.image(this.side, 0.0f, 0.0f);
            this._app.image(this.side, 0.0f, -this.getWidth() - this.side.height);
            this._app.popMatrix();
        }
        if (this.corner != null) {
            this._app.pushMatrix();
            int n = (int)(0.35f * (float)this.corner.width);
            this._app.image(this.corner, -n, -n);
            this._app.pushMatrix();
            this._app.translate(this.getWidth() + n, -n);
            this._app.rotate(1.5707964f);
            this._app.image(this.corner, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.pushMatrix();
            this._app.translate(this.getWidth() + n, this.getHeight() + n);
            this._app.rotate((float)Math.PI);
            this._app.image(this.corner, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.pushMatrix();
            this._app.translate(-n, this.getHeight() + n);
            this._app.rotate(4.712389f);
            this._app.image(this.corner, 0.0f, 0.0f);
            this._app.popMatrix();
            this._app.popMatrix();
        }
    }

    public void setBackColour(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
    }
}

