/*
 * Decompiled with CFR 0.152.
 */
package core.gui;

import core.GameScreen;
import core.ScreenElement;
import core.gui.FrameElement;
import core.gui.TextBlockElement;
import core.language.Language;
import processing.core.PApplet;

public abstract class DialogBox
extends ScreenElement {
    private TextBlockElement txt;
    private FrameElement frm;
    private static DialogBox shownDialog;
    private boolean prevHudVisibility;

    public DialogBox(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setClickable(true);
        this.frm = new FrameElement(screenElement, pApplet);
        this.txt = new TextBlockElement(this, this._app, Language.getString("Font_Default"), "Dialog text", 16, 0.9f, 0.9f);
        this.frm.addChild(this.txt);
        this.addChild(this.frm);
    }

    protected void setDialogText(String string) {
        this.txt.setText(string);
    }

    protected void setDimeneions(int n, int n2) {
        this.frm.setWidth(n);
        this.frm.setHeight(n2);
    }

    public void show() {
        if (shownDialog == null) {
            this.prevHudVisibility = GameScreen.getHUDVisibility();
            shownDialog = this;
            this.setVisible(true);
            GameScreen.hideHUD();
        }
    }

    public void hide() {
        if (shownDialog != null && shownDialog == this) {
            shownDialog = null;
            this.setVisible(false);
            if (this.prevHudVisibility) {
                GameScreen.showHUD();
            }
        }
    }

    protected void addDialogChild(ScreenElement screenElement) {
        this.frm.addChild(screenElement);
    }

    @Override
    public void setup() {
        super.setup();
        this.setBounds(900, 600);
        this.setRelativePosition(0.5f, 0.5f);
        this.setOrigin(0.5f, 0.5f);
        this.setWidth(this._app.width);
        this.setHeight(this._app.height);
        this.frm.setOrigin(0.5f, 0.5f);
        this.frm.setRelativePosition(0.5f, 0.5f);
        this.frm.setBackOpacity(255.0f);
        this.txt.setRelativePosition(0.5f, 0.5f);
        this.txt.setOrigin(0.5f, 0.5f);
        this.getParent().changeChildZIndex(this, 10000000);
    }

    @Override
    public void render() {
        if (shownDialog != null && shownDialog == this) {
            this._app.pushStyle();
            this._app.pushMatrix();
            this._app.translate(0.5f * (float)(this.getWidth() - this._app.width), 0.5f * (float)(this.getHeight() - this._app.height));
            this._app.fill(100.0f, 100.0f, 100.0f, 200.0f);
            this._app.rect(0.0f, 0.0f, this._app.width, this._app.height);
            this._app.popMatrix();
            this._app.popStyle();
            super.render();
        }
    }
}

