/*
 * Decompiled with CFR 0.152.
 */
package core.gui;

import core.ResourceManager;
import core.ScreenElement;
import core.animation.KeyFrameAnimation;
import ddf.minim.AudioPlayer;
import processing.core.PApplet;
import processing.core.PImage;

public class ButtonElement
extends ScreenElement {
    protected String _normFilename;
    protected String _hoverFilename;
    protected String _clickedFilename;
    protected String _clickSound;
    protected PImage _normImg;
    protected PImage _hoverImg;
    protected PImage _clickedImg;
    protected PImage _draw;
    protected IButtonCallback _callback = null;
    protected KeyFrameAnimation _hoverAnim;
    protected boolean _repeatHoverAnim = true;
    protected boolean enabled = true;
    protected IButtonHoverCallback _hcallback = null;
    protected AudioPlayer click;
    protected int _button_state;

    public ButtonElement(ScreenElement screenElement, PApplet pApplet, String string) {
        super(screenElement, pApplet);
        this.setClickable(true);
        this._normFilename = string;
        this._hoverFilename = string;
        this._clickedFilename = string;
    }

    public ButtonElement(ScreenElement screenElement, PApplet pApplet, String string, String string2) {
        this(screenElement, pApplet, string);
        this._clickSound = string2;
    }

    public ButtonElement(ScreenElement screenElement, PApplet pApplet, String string, String string2, String string3) {
        this(screenElement, pApplet, string, null);
        this._hoverFilename = string2;
        this._clickedFilename = string3;
    }

    public ButtonElement(ScreenElement screenElement, PApplet pApplet, String string, String string2, String string3, String string4) {
        this(screenElement, pApplet, string, string4);
        this._hoverFilename = string2;
        this._clickedFilename = string3;
    }

    public void isEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void loadResources() {
        if (this._normFilename != null) {
            this._normImg = ResourceManager.LoadImage(this._normFilename);
        }
        if (this._hoverFilename != null) {
            this._hoverImg = ResourceManager.LoadImage(this._hoverFilename);
        }
        if (this._clickedFilename != null) {
            this._clickedImg = ResourceManager.LoadImage(this._clickedFilename);
        }
        this._draw = this._normImg;
        if (this._clickSound != null && this.click != null) {
            this.click = ResourceManager.LoadAudio(this._clickSound);
            this.click.setGain(-20.0f);
            this.click.cue(0);
        }
        if (this._normFilename != null) {
            this.setBounds(this._normImg.width, this._normImg.height);
        }
    }

    public void setRepeatHoverAnimation(boolean bl) {
        this._repeatHoverAnim = bl;
    }

    public void setCallback(IButtonCallback iButtonCallback) {
        if (iButtonCallback == null) {
            throw new NullPointerException("Callback object cannot be null");
        }
        this._callback = iButtonCallback;
    }

    public void setHoverCallback(IButtonHoverCallback iButtonHoverCallback) {
        if (iButtonHoverCallback == null) {
            throw new NullPointerException("Callback object cannot be null");
        }
        this._hcallback = iButtonHoverCallback;
    }

    @Override
    public void update(float f) {
        if (this._hoverAnim != null) {
            this._hoverAnim.Update(f);
        }
    }

    @Override
    public void render() {
        if (this._draw != null) {
            this._app.image(this._draw, 0.0f, 0.0f);
        }
    }

    public void setHoverAnimation(KeyFrameAnimation keyFrameAnimation) {
        if (keyFrameAnimation == null) {
            throw new RuntimeException("Animation reference cannot be null");
        }
        this._hoverAnim = keyFrameAnimation;
    }

    @Override
    public void onMouseEvent(int n, int n2) {
        switch (n) {
            case 501: {
                this._draw = this._clickedImg;
                this._button_state = 3;
                break;
            }
            case 502: {
                if (!this.enabled) break;
                this._draw = this._hoverImg;
                this._button_state = 2;
                if (this.click != null) {
                    this.click.play();
                    this.click.cue(1);
                }
                if (this._callback == null) break;
                this._callback.OnClicked(this, n2);
                break;
            }
            case 504: {
                if (!this.enabled) break;
                if (this._hoverAnim != null) {
                    if (this._repeatHoverAnim) {
                        this._hoverAnim.setRepeatable(true);
                    }
                    this._hoverAnim.Unpause();
                }
                if (this._hcallback != null) {
                    this._hcallback.OnHover(this);
                }
                this._draw = this._hoverImg;
                this._button_state = 2;
                break;
            }
            case 505: {
                if (!this.enabled) break;
                if (this._hoverAnim != null) {
                    this._hoverAnim.setRepeatable(false);
                }
                if (!this._repeatHoverAnim) {
                    this._hoverAnim.setPlayAnimationForward(false);
                }
                if (this._hcallback != null) {
                    this._hcallback.OnLeave(this);
                }
                this._draw = this._normImg;
                this._button_state = 1;
            }
        }
    }

    public static interface IButtonHoverCallback {
        public void OnHover(ButtonElement var1);

        public void OnLeave(ButtonElement var1);
    }

    public static interface IButtonCallback {
        public void OnClicked(ButtonElement var1, int var2);
    }
}

