/*
 * Decompiled with CFR 0.152.
 */
package core.animation;

import core.ScreenElement;
import core.animation.IKeyFrame;
import core.animation.TargetProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import processing.core.PVector;

public class Timeline {
    private List<IKeyFrame> _keys;
    private TargetProperty _prop;
    private float _currTime;
    private float _finishTime;
    private Object _calcValue;
    private boolean runForwards = true;
    private int _prevIndex;

    public Timeline(TargetProperty targetProperty) {
        if (targetProperty == null) {
            throw new NullPointerException();
        }
        this._prop = targetProperty;
        this._keys = new ArrayList<IKeyFrame>();
        this._currTime = 0.0f;
    }

    protected Timeline(TargetProperty targetProperty, List<IKeyFrame> list) {
        if (targetProperty == null) {
            throw new NullPointerException();
        }
        this._prop = targetProperty;
        this._keys = list;
        this._currTime = 0.0f;
    }

    public Timeline duplicate() {
        return new Timeline(this._prop, this._keys);
    }

    public TargetProperty GetTargetProperty() {
        return this._prop;
    }

    public void setPlayForward(boolean bl) {
        this.runForwards = bl;
    }

    public void Reset() {
        if (this.runForwards) {
            this._currTime = 0.0f;
            this._prevIndex = 0;
        } else {
            this._currTime = this._finishTime;
            this._prevIndex = this._keys.size() - 1;
        }
    }

    public void AddKeyFrame(IKeyFrame iKeyFrame) {
        if (iKeyFrame.getTargetProperty() != this._prop) {
            throw new RuntimeException("Cannot add key frame whose target is different from the Timeline target.");
        }
        int n = Collections.binarySearch(this._keys, iKeyFrame);
        if (iKeyFrame.getKeyTime().floatValue() > this._finishTime) {
            this._finishTime = iKeyFrame.getKeyTime().floatValue();
        }
        if (n < 0) {
            this._keys.add(-n - 1, iKeyFrame);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean UpdateTarget(ScreenElement screenElement, float f) {
        Object object = null;
        if (f == this._currTime) {
            object = this._calcValue;
            this._updateTarget(screenElement, object);
        } else if (this.runForwards) {
            if (this._prevIndex + 1 >= this._keys.size()) return false;
            if (this._currTime > this._keys.get(this._prevIndex + 1).getKeyTime().floatValue()) {
                ++this._prevIndex;
            }
            if (this._currTime >= this._keys.get(this._prevIndex).getKeyTime().floatValue()) {
                if (this._prevIndex >= this._keys.size() - 1) return false;
                IKeyFrame iKeyFrame = this._keys.get(this._prevIndex);
                IKeyFrame iKeyFrame2 = this._keys.get(this._prevIndex + 1);
                object = iKeyFrame.Interpolate(iKeyFrame2, f);
                this._updateTarget(screenElement, object);
            }
        } else {
            if (this._prevIndex - 1 <= 0) return false;
            if (this._currTime < this._keys.get(this._prevIndex - 1).getKeyTime().floatValue()) {
                --this._prevIndex;
            }
            if (this._currTime <= this._keys.get(this._prevIndex).getKeyTime().floatValue()) {
                if (this._prevIndex >= this._keys.size() - 1) return false;
                IKeyFrame iKeyFrame = this._keys.get(this._prevIndex);
                IKeyFrame iKeyFrame3 = this._keys.get(this._prevIndex - 1);
                object = iKeyFrame.Interpolate(iKeyFrame3, f);
                this._updateTarget(screenElement, object);
            }
        }
        this._currTime = f;
        this._calcValue = object;
        return true;
    }

    private void _updateTarget(ScreenElement screenElement, Object object) {
        switch (this._prop) {
            case position: {
                screenElement.setPosition((PVector)object);
                break;
            }
            case scale: {
                screenElement.setScale((PVector)object);
                break;
            }
            case rotation: {
                screenElement.setRotation((Float)object);
                break;
            }
            case opacity: {
                screenElement.setOpacity(((Float)object).floatValue());
                break;
            }
            case width: {
                screenElement.setWidth((Integer)object);
                break;
            }
            case height: {
                screenElement.setHeight((Integer)object);
                break;
            }
            default: {
                throw new RuntimeException("Cannot process target property " + this._prop.toString());
            }
        }
    }
}

