/*
 * Decompiled with CFR 0.152.
 */
package core.animation;

import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.IKeyFrame;
import core.animation.TargetProperty;
import core.animation.Timeline;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class KeyFrameAnimation {
    private HashMap<TargetProperty, Timeline> _timelines;
    private float _currTime;
    private boolean _running;
    private boolean _repeatAnim;
    private List<IAnimationCompleteCallback> _callback;
    private List<ScreenElement> _targets;
    private boolean _playForward = true;
    private float _finishTime = 0.0f;

    public KeyFrameAnimation() {
        this._timelines = new HashMap();
        this._targets = new LinkedList<ScreenElement>();
        this._callback = new LinkedList<IAnimationCompleteCallback>();
        this._running = false;
        this._repeatAnim = false;
    }

    public KeyFrameAnimation(boolean bl) {
        this();
        this._repeatAnim = bl;
    }

    public KeyFrameAnimation(boolean bl, ScreenElement screenElement) {
        this(bl);
        this.AddTargetObject(screenElement);
    }

    public KeyFrameAnimation(boolean bl, ScreenElement screenElement, IAnimationCompleteCallback iAnimationCompleteCallback) {
        this(bl, screenElement);
        this.addCallback(iAnimationCompleteCallback);
    }

    private KeyFrameAnimation(HashMap<TargetProperty, Timeline> hashMap, List<IAnimationCompleteCallback> list, List<ScreenElement> list2) {
        this._timelines = new HashMap(hashMap.size());
        for (TargetProperty targetProperty : hashMap.keySet()) {
            this._timelines.put(targetProperty, hashMap.get((Object)targetProperty).duplicate());
        }
        this._targets = list2 != null ? list2 : new LinkedList<ScreenElement>();
        this._callback = list != null ? list : new LinkedList<IAnimationCompleteCallback>();
    }

    public float getFinishTime() {
        return this._finishTime;
    }

    public KeyFrameAnimation duplicate(boolean bl, boolean bl2) {
        HashMap hashMap = (HashMap)this._timelines.clone();
        LinkedList<ScreenElement> linkedList = null;
        LinkedList<IAnimationCompleteCallback> linkedList2 = null;
        if (bl) {
            linkedList = new LinkedList<ScreenElement>(this._targets);
        }
        if (bl2) {
            linkedList2 = new LinkedList<IAnimationCompleteCallback>(this._callback);
        }
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(hashMap, linkedList2, linkedList);
        return keyFrameAnimation;
    }

    public void addCallback(IAnimationCompleteCallback iAnimationCompleteCallback) {
        if (!this._callback.contains(iAnimationCompleteCallback)) {
            this._callback.add(iAnimationCompleteCallback);
        }
    }

    public void removeCallback(IAnimationCompleteCallback iAnimationCompleteCallback) {
        this._callback.remove(iAnimationCompleteCallback);
    }

    public void addCallback(List<IAnimationCompleteCallback> list) {
        for (IAnimationCompleteCallback iAnimationCompleteCallback : list) {
            this.addCallback(iAnimationCompleteCallback);
        }
    }

    public void AddKeyFrame(IKeyFrame iKeyFrame) {
        Timeline timeline;
        if (this._running) {
            throw new RuntimeException("Cannot add key frame when running");
        }
        if (this._timelines.containsKey((Object)iKeyFrame.getTargetProperty())) {
            timeline = this._timelines.get((Object)iKeyFrame.getTargetProperty());
        } else {
            timeline = new Timeline(iKeyFrame.getTargetProperty());
            this._timelines.put(iKeyFrame.getTargetProperty(), timeline);
        }
        if (iKeyFrame.getKeyTime().floatValue() > this._finishTime) {
            this._finishTime = iKeyFrame.getKeyTime().floatValue();
        }
        timeline.AddKeyFrame(iKeyFrame);
    }

    public void AddTargetObject(ScreenElement screenElement) {
        if (this._running) {
            throw new RuntimeException("Cannot add target object when running");
        }
        if (!this._targets.contains(screenElement)) {
            this._targets.add(screenElement);
        }
    }

    public void Start() {
        this.Reset();
        this.Unpause();
    }

    public void Pause() {
        this._running = false;
    }

    public void Unpause() {
        this._running = true;
    }

    public void Reset() {
        for (Timeline timeline : this._timelines.values()) {
            timeline.Reset();
        }
        this._currTime = this._playForward ? 0.0f : 0.0f;
    }

    public void Stop() {
        if (this._repeatAnim) {
            for (int i = 0; i < this._callback.size(); ++i) {
                this._callback.get(i).OnComplete(this);
            }
        }
        this._running = false;
    }

    public void gotoTime(float f) {
        this._currTime = f > this._finishTime ? this._finishTime * 0.95f : (f < 0.0f ? 0.0f : f);
    }

    public void Update(float f) {
        if (this._running) {
            this._currTime = this._playForward ? (this._currTime += f) : (this._currTime -= f);
            int n = 0;
            for (ScreenElement screenElement : this._targets) {
                for (Timeline timeline : this._timelines.values()) {
                    if (timeline.UpdateTarget(screenElement, this._currTime)) continue;
                    ++n;
                }
            }
            if (n == this._timelines.size() * this._targets.size()) {
                if (this._repeatAnim) {
                    this.Start();
                } else {
                    int n2 = 0;
                    for (n2 = 0; n2 < this._callback.size(); ++n2) {
                        this._callback.get(n2).OnComplete(this);
                    }
                    this.Stop();
                }
            }
        }
    }

    public void setPlayAnimationForward(boolean bl) {
        this._playForward = bl;
        for (Timeline timeline : this._timelines.values()) {
            timeline.setPlayForward(bl);
        }
    }

    public void setRepeatable(boolean bl) {
        this._repeatAnim = bl;
    }

    public boolean isRunning() {
        return this._running;
    }
}

