/*
 * Decompiled with CFR 0.152.
 */
package core.animation;

import core.animation.IKeyFrame;
import core.animation.TargetProperty;
import core.animation.keyframes.easing.EasingFunction;
import core.animation.keyframes.easing.EasingFunctions;

public abstract class KeyFrame<T>
implements IKeyFrame {
    public float KeyTime;
    public T KeyValue;
    private TargetProperty TargetProperty;
    private EasingFunctions easeMethod;

    @Override
    public Float getKeyTime() {
        return Float.valueOf(this.KeyTime);
    }

    @Override
    public Object getKeyValue() {
        return this.KeyValue;
    }

    @Override
    public TargetProperty getTargetProperty() {
        return this.TargetProperty;
    }

    @Override
    public int compareTo(IKeyFrame iKeyFrame) {
        return Float.compare(this.KeyTime, iKeyFrame.getKeyTime().floatValue());
    }

    public KeyFrame(float f, T t, TargetProperty targetProperty) {
        this.KeyTime = f;
        this.KeyValue = t;
        this.TargetProperty = targetProperty;
        this.easeMethod = EasingFunctions.Linear;
    }

    public KeyFrame(float f, T t, TargetProperty targetProperty, EasingFunctions easingFunctions) {
        this.KeyTime = f;
        this.KeyValue = t;
        this.TargetProperty = targetProperty;
        this.easeMethod = easingFunctions;
    }

    @Override
    public Object Interpolate(IKeyFrame iKeyFrame, float f) {
        return this.Interpolate(f - this.KeyTime, iKeyFrame.getKeyTime().floatValue() - this.KeyTime, this.KeyValue, iKeyFrame.getKeyValue());
    }

    protected float getEasingParameter(float f, float f2) {
        float f3 = 0.0f;
        if (f > f2) {
            f = f2;
        }
        switch (this.easeMethod) {
            case EaseIn: {
                f3 = EasingFunction.EaseIn(f, f2);
                break;
            }
            case EaseOut: {
                f3 = EasingFunction.EaseOut(f, f2);
                break;
            }
            case EaseInOut: {
                f3 = EasingFunction.EaseInOut(f, f2);
                break;
            }
            case BounceIn: {
                f3 = EasingFunction.BounceIn(f, f2);
                break;
            }
            default: {
                f3 = f / f2;
            }
        }
        return f3;
    }

    protected abstract T Interpolate(float var1, float var2, T var3, T var4);
}

