/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GameScreen;
import core.ILoadingCallback;
import core.language.Language;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import processing.core.PApplet;
import processing.core.PVector;

public abstract class ScreenElement {
    private ScreenElement _parent;
    private Rectangle _bounds;
    protected PApplet _app;
    private PVector _position;
    private PVector _relPosition;
    private float _originX;
    private float _originY;
    private float _rotation;
    private PVector _scale;
    private float _opacity;
    private int _width;
    private int _height;
    private float _relwidth;
    private float _relheight;
    private boolean _clickable;
    private int _zindex;
    private Color _boundStroke;
    protected List<ScreenElement> _children;
    private boolean _visible = true;
    private boolean _setrelativebounds;
    private DecimalFormat _mny = new DecimalFormat(Language.getString("Currency") + "#,##0");
    private DecimalFormat _mnyK = new DecimalFormat(Language.getString("Currency") + "#,##0.0K");
    private DecimalFormat _mnyM = new DecimalFormat(Language.getString("Currency") + "#,##0.0M");

    public ScreenElement(ScreenElement screenElement, PApplet pApplet) {
        if (pApplet == null) {
            throw new NullPointerException("Applet reference cannot be null");
        }
        this._position = new PVector();
        this._relPosition = new PVector();
        this._height = 0;
        this._width = 0;
        this._app = pApplet;
        this._parent = screenElement;
        this._bounds = new Rectangle();
        this._relPosition = new PVector(0.0f, 0.0f);
        this._scale = new PVector(1.0f, 1.0f);
        this._opacity = 1.0f;
        this._children = new LinkedList<ScreenElement>();
        Random random = new Random();
        this._boundStroke = new Color(random.nextFloat(), random.nextFloat(), random.nextFloat());
        this.updateBounds();
    }

    protected String FormatMoney(double d) {
        if (d < 1000.0) {
            return this._mny.format(d);
        }
        if (d < 1000000.0) {
            return this._mnyK.format(d / 1000.0);
        }
        return this._mnyM.format(d / 1000000.0);
    }

    public final void beginLoadResourceCycle(ILoadingCallback iLoadingCallback, float f) {
        float f2 = f / (float)(1 + this._children.size());
        for (ScreenElement screenElement : this._children) {
            screenElement.beginLoadResourceCycle(iLoadingCallback, f2);
        }
        this.loadResources();
        if (iLoadingCallback != null) {
            iLoadingCallback.IncrementPercentageDone(f2);
        }
    }

    public void loadResources() {
    }

    public final void beginSetupCycle() {
        this.setup();
        for (ScreenElement screenElement : this._children) {
            screenElement.beginSetupCycle();
        }
    }

    public void setup() {
    }

    public int getChildCount() {
        return this._children.size();
    }

    public ScreenElement getParent() {
        return this._parent;
    }

    public final void beginRenderCycle() {
        if (this._visible) {
            this._app.pushStyle();
            this._app.pushMatrix();
            this.preRender();
            this._app.translate(this._position.x, this._position.y);
            this._app.pushMatrix();
            if (this._scale.x != 1.0f || this._scale.y != 1.0f) {
                this._app.scale(this._scale.x, this._scale.y);
            }
            if (this._rotation != 0.0f) {
                this._app.rotate(this._rotation);
            }
            this._app.translate(-this._originX * (float)this.getWidth(), -this._originY * (float)this.getHeight());
            float f = this.getAbsoluteOpacity();
            if (f != 1.0f) {
                this._app.tint(255, 255.0f * f);
            }
            this.render();
            for (ScreenElement screenElement : this._children) {
                screenElement.beginRenderCycle();
            }
            this._app.popMatrix();
            if (!GameScreen.isPageChanging() && this._app.keyPressed && this._app.key == ' ') {
                if (this._rotation != 0.0f) {
                    this._app.rotate(this._rotation);
                }
                this._app.strokeWeight(2.0f);
                this._app.stroke(this._boundStroke.getRed(), this._boundStroke.getGreen(), this._boundStroke.getBlue());
                this._app.noFill();
                this._app.rect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            }
            this.postRender();
            this._app.popMatrix();
            this._app.popStyle();
        }
    }

    public void preRender() {
    }

    public void render() {
    }

    public void postRender() {
    }

    public final void beginUpdateCycle(float f) {
        if (this._setrelativebounds) {
            this.refreshBounds();
        }
        this.preUpdate(f);
        this.update(f);
        for (ScreenElement screenElement : this._children) {
            screenElement.beginUpdateCycle(f);
        }
        this.postUpdate(f);
    }

    public void preUpdate(float f) {
    }

    public void update(float f) {
    }

    public void postUpdate(float f) {
    }

    protected void beginOnPageShowCycle() {
        this.onPageShow();
        for (ScreenElement screenElement : this._children) {
            screenElement.beginOnPageShowCycle();
        }
    }

    protected void beginOnPageHideCycle() {
        this.onPageHide();
        for (ScreenElement screenElement : this._children) {
            screenElement.beginOnPageHideCycle();
        }
    }

    public void onPageShow() {
    }

    public void onPageHide() {
    }

    public final int getWidth() {
        return this._width;
    }

    public final int getHeight() {
        return this._height;
    }

    public void setWidth(int n) {
        this._setrelativebounds = false;
        this._width = n;
        this.updateBounds();
    }

    public void setHeight(int n) {
        this._setrelativebounds = false;
        this._height = n;
        this.updateBounds();
    }

    public final void setBounds(int n, int n2) {
        this._setrelativebounds = false;
        this._width = n;
        this._height = n2;
        this.updateBounds();
    }

    public final void setRelativeBounds(float f, float f2) {
        this._setrelativebounds = true;
        this._relwidth = f;
        this._relheight = f2;
        this.refreshBounds();
    }

    protected final void refreshBounds() {
        if (this._setrelativebounds) {
            if (this._parent != null) {
                this._width = (int)(this._relwidth * (float)this._parent.getWidth());
                this._height = (int)(this._relheight * (float)this._parent.getHeight());
            } else {
                this._width = (int)(this._relwidth * (float)this._app.getWidth());
                this._height = (int)(this._relheight * (float)this._app.getHeight());
            }
            this.updateBounds();
        }
    }

    protected final void updateBounds() {
        PVector pVector = this.getAbsoluteScale();
        this._bounds.x = (int)(-this._originX * (float)this.getWidth() * pVector.x);
        this._bounds.y = (int)(-this._originY * (float)this.getHeight() * pVector.y);
        this._bounds.width = (int)((float)this._width * pVector.x);
        this._bounds.height = (int)((float)this._height * pVector.y);
        for (int i = 0; i < this._children.size(); ++i) {
            this._children.get(i).refreshPosition();
            this._children.get(i).refreshBounds();
        }
    }

    public final int getZIndex() {
        return this._zindex;
    }

    public final void setZIndex(int n) {
        this._zindex = n;
    }

    public final void setVisible(boolean bl) {
        this._visible = bl;
    }

    public final boolean isVisible() {
        return this._parent == null ? this._visible : this._visible && this._parent.isVisible();
    }

    public void onMouseEvent(int n, int n2) {
    }

    public final void setClickable(boolean bl) {
        this._clickable = bl;
    }

    public final boolean isClickable() {
        return this._clickable;
    }

    public void setOrigin(float f, float f2) {
        this._originX = f;
        this._originY = f2;
        this.updateBounds();
    }

    public void onRemove() {
    }

    public void onAdd() {
    }

    public float getOriginX() {
        return this._originX;
    }

    public float getOriginY() {
        return this._originY;
    }

    public final ScreenElement HitTest(float f, float f2) {
        if (this._children.size() > 0 && this._visible) {
            for (int i = this._children.size() - 1; i >= 0; --i) {
                ScreenElement screenElement = this._children.get(i);
                ScreenElement screenElement2 = null;
                if (this._rotation != 0.0f) {
                    float f3 = f - this._position.x;
                    float f4 = f2 - this._position.y;
                    float f5 = (float)((double)f3 * Math.cos(this._rotation) + (double)f4 * Math.sin(this._rotation));
                    float f6 = (float)((double)(-f3) * Math.sin(this._rotation) + (double)f4 * Math.cos(this._rotation));
                    screenElement2 = screenElement.HitTest(f5, f6);
                } else {
                    screenElement2 = screenElement.HitTest(f - this._position.x + this._originX * (float)this.getWidth(), f2 - this._position.y + this._originY * (float)this.getHeight());
                }
                if (screenElement2 == null) continue;
                return screenElement2;
            }
        }
        if (this._hitTest(f - this._position.x, f2 - this._position.y) && this._clickable) {
            return this;
        }
        return null;
    }

    protected boolean _hitTest(float f, float f2) {
        if (this._rotation != 0.0f) {
            float f3 = (float)((double)f * Math.cos(this._rotation) + (double)f2 * Math.sin(this._rotation));
            float f4 = (float)((double)(-f) * Math.sin(this._rotation) + (double)f2 * Math.cos(this._rotation));
            return this._bounds.contains(f3, f4);
        }
        return this._bounds.contains(f, f2);
    }

    public final float getAbsoluteOpacity() {
        return this._parent == null ? this._opacity : this._parent.getAbsoluteOpacity() * this._opacity;
    }

    public final float getOpacity() {
        return this._opacity;
    }

    public final void setOpacity(float f) {
        this._opacity = f;
    }

    public final float getRotation() {
        return this._rotation;
    }

    public final float getAbsoluteRotation() {
        return this._parent != null ? this._rotation + this._parent.getAbsoluteRotation() : this._rotation;
    }

    public final void setRotation(Float f) {
        this._rotation = f.floatValue();
    }

    public final PVector getPosition() {
        return this._position;
    }

    public final PVector getAbsolutePosition() {
        return this._parent != null ? PVector.add(this._position, this._parent.getAbsolutePosition()) : this._position;
    }

    public final float getX() {
        return this._position.x;
    }

    public final float getY() {
        return this._position.y;
    }

    public final void setX(float f) {
        if (!Float.isNaN(f)) {
            this._position.x = f;
        }
        this.updateBounds();
    }

    public final void setY(float f) {
        if (!Float.isNaN(f)) {
            this._position.y = f;
        }
        this.updateBounds();
    }

    public final void setRelativePosition(float f, float f2) {
        if (!Float.isNaN(f)) {
            this._relPosition.x = f;
        }
        if (!Float.isNaN(f2)) {
            this._relPosition.y = f2;
        }
        this.refreshPosition();
    }

    protected final void refreshPosition() {
        if (this._parent != null) {
            this.setPosition(this._relPosition.x * (float)this._parent.getWidth(), this._relPosition.y * (float)this._parent.getHeight());
        } else {
            this.setPosition(this._relPosition.x * (float)this._app.getWidth(), this._relPosition.y * (float)this._app.getHeight());
        }
    }

    public final void setPosition(PVector pVector) {
        this.setPosition(pVector.x, pVector.y);
    }

    public final void setPosition(float f, float f2) {
        if (!Float.isNaN(f)) {
            this._position.x = f;
        }
        if (!Float.isNaN(f2)) {
            this._position.y = f2;
        }
        this.updateBounds();
    }

    public final PVector getScale() {
        return this._scale;
    }

    public final PVector getAbsoluteScale() {
        return this._parent != null ? PVector.mult(this._scale, this._parent.getAbsoluteScale()) : this._scale;
    }

    public final void setScale(PVector pVector) {
        this.setScale(pVector.x, pVector.y);
    }

    public final void setScale(float f, float f2) {
        if (!Float.isNaN(f)) {
            this._scale.x = f;
        }
        if (!Float.isNaN(f2)) {
            this._scale.y = f2;
        }
        this.updateBounds();
    }

    public final void setParent(ScreenElement screenElement) {
        this._parent = screenElement;
        if (screenElement != null) {
            this.setPosition(this._relPosition.x * (float)this._parent.getWidth(), this._relPosition.y * (float)this._parent.getHeight());
            this.refreshPosition();
        }
    }

    public final void changeChildZIndex(ScreenElement screenElement, int n) {
        if (screenElement == null) {
            throw new NullPointerException("Child reference cannot be null");
        }
        int n2 = this._children.indexOf(screenElement);
        if (n2 >= 0) {
            if (n > this._children.size() - 1) {
                n = this._children.size() - 1;
            }
            if (n < 0) {
                n = 0;
            }
            if (n == n2) {
                return;
            }
            if (n > n2) {
                for (int i = n2 + 1; i < this._children.size(); ++i) {
                    if (i == n || i == this._children.size() - 1) {
                        this._children.add(screenElement);
                        break;
                    }
                    this._children.get(i).setZIndex(i - 1);
                }
            } else {
                for (int i = n2 - 1; i >= 0; --i) {
                    if (i == n || i == 0) {
                        this._children.add(screenElement);
                        break;
                    }
                    this._children.get(i).setZIndex(i + 1);
                }
            }
            this._children.remove(n2);
            screenElement.setZIndex(n);
        }
    }

    public final void addChild(ScreenElement screenElement) {
        if (screenElement == null) {
            throw new NullPointerException("Child reference cannot be null");
        }
        screenElement.setParent(this);
        screenElement.setZIndex(this._children.size() + 1);
        this._children.add(screenElement);
        screenElement.onAdd();
    }

    public final void removeChild(ScreenElement screenElement) {
        if (screenElement == null) {
            throw new NullPointerException("Child reference cannot be null");
        }
        int n = this._children.indexOf(screenElement);
        if (n < this._children.size() - 1) {
            for (int i = n + 1; i < this._children.size(); ++i) {
                this._children.get(i).setZIndex(i - 1);
            }
        }
        screenElement.setParent(null);
        this._children.remove(n);
        screenElement.onRemove();
    }
}

