/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GameScreen;
import ddf.minim.AudioPlayer;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;

public final class ResourceManager {
    private static boolean _finishedLoading = false;
    private static HashMap<String, PImage> _imageBank;
    private static HashMap<String, AudioPlayer> _soundBank;
    private static PApplet _app;
    private static ResourceManager _instance;

    public ResourceManager(PApplet pApplet) {
        if (_instance != null) {
            throw new RuntimeException("An instance of a ResourceManager already exists");
        }
        _soundBank = new HashMap();
        _imageBank = new HashMap();
        _app = pApplet;
    }

    public void setLoaded() {
        _finishedLoading = true;
    }

    public static PImage LoadImage(String string) {
        PImage pImage = _imageBank.get(string);
        if (pImage == null) {
            if (_finishedLoading) {
                PApplet.println("You are loading the resources " + string + " after" + " the resource loading stage at the start. Check if this can be moved into the" + " relevant elements loadResources() methods");
            } else {
                PApplet.println("Loading " + string);
            }
            pImage = _app.loadImage(string);
            if (pImage == null) {
                throw new RuntimeException("Could not find the file " + string);
            }
            _imageBank.put(string, pImage);
        }
        return pImage;
    }

    public static AudioPlayer LoadAudio(String string, int n) {
        if (!GameScreen.audio_enabled()) {
            return null;
        }
        AudioPlayer audioPlayer = _soundBank.get(string);
        if (audioPlayer == null) {
            if (_finishedLoading) {
                PApplet.println("You are loading the resources " + string + " after" + " the resource loading stage at the start. Check if this can be moved into the" + " relevant elements loadResources() methods");
            } else {
                PApplet.println("Loading " + string);
            }
            audioPlayer = n > 0 ? GameScreen.minim.loadFile(string, n) : GameScreen.minim.loadFile(string);
            if (audioPlayer == null) {
                throw new RuntimeException("Could not find the file " + string);
            }
            _soundBank.put(string, audioPlayer);
        }
        return audioPlayer;
    }

    public static AudioPlayer LoadAudio(String string) {
        return ResourceManager.LoadAudio(string, 0);
    }
}

