/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GamePage;
import core.ILoadingCallback;
import processing.core.PApplet;

public abstract class LoadingPage
extends GamePage
implements ILoadingCallback {
    private float _percentageDone = 0.0f;

    public abstract void OnLoadComplete();

    public float getPercentageDone() {
        return this._percentageDone;
    }

    public LoadingPage(PApplet pApplet) {
        super(pApplet);
    }

    @Override
    public void IncrementPercentageDone(float f) {
        this.setLoadingPercentage(this._percentageDone + f);
    }

    public void FinishLoading() {
        this._percentageDone = 1.0f;
        this.OnLoadComplete();
    }

    public void setLoadingPercentage(float f) {
        if (this._percentageDone > f) {
            PApplet.println("Loading percentage went down?");
        }
        this._percentageDone = f;
        if (this._percentageDone >= 1.0f) {
            this._percentageDone = 0.99999f;
        }
    }
}

