/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.ResourceManager;
import core.ScreenElement;
import processing.core.PApplet;
import processing.core.PImage;

public class ImageElement
extends ScreenElement {
    private String _filename;
    private PImage _img;
    public float xOffset;
    public float yOffset;

    public ImageElement(String string, ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        if (string.trim() == "") {
            throw new RuntimeException("Filename for image cannot be empty");
        }
        this._filename = string;
    }

    @Override
    public void loadResources() {
        this._img = ResourceManager.LoadImage(this._filename);
        this.setBounds(this._img.width, this._img.height);
    }

    @Override
    public void render() {
        if (this._img != null) {
            this._app.image(this._img, this.xOffset * (float)this.getWidth(), this.yOffset * (float)this.getHeight());
        }
    }

    public void setImage(PImage pImage) {
        if (pImage == null) {
            throw new NullPointerException("PImage reference is null");
        }
        this._img = pImage;
    }
}

