/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GamePage;
import core.LoadingPage;
import core.ResourceManager;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.gui.ButtonElement;
import core.gui.YesNoDialog;
import core.language.Language;
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import game.BSFLoadPage;
import game.FinalScore;
import game.GameHud;
import game.IntroPage;
import game.PlayerData;
import game.variables.EnvironmentSystemVariables;
import game.variables.OpticsVariables;
import game.variables.SuspensionVariables;
import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import highscore.HighScoreScreen;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.ImageIcon;
import pages.controlroom.ControlRoomPage;
import pages.creditspage.CreditsPage;
import pages.environmentsubsystem.EnvironmentSystemBase;
import pages.gamesetup.EnterNamePage;
import pages.optics.OpticsBase;
import pages.pioffice.PIOfficePage;
import pages.vibrationisolation.VibrationIsolationbase;
import processing.core.PApplet;

public class GameScreen
extends PApplet {
    public static final int MajorVersion = 1;
    public static final int MinorVersion = 2;
    public static final int BuildVersion = 0;
    private static boolean _audio_enabled = true;
    public static HashMap<String, String> args = new HashMap();
    private HashMap<String, GamePage> _pages;
    private static GameScreen _instance;
    protected static GamePage _currPage;
    protected static GamePage _nextPage;
    protected static GamePage _hud;
    protected Language _lang;
    public static Minim minim;
    private static String _currPageName;
    private static boolean _changingScreen;
    private static Object _lock;
    private ResourceManager _rscMgr;
    protected LoadingPage _lPage;
    private Thread _loadingThread;
    private static YesNoDialog dbox;
    private int _scrW;
    private int _scrH;
    private static AudioPlayer currMusic;
    private static AudioPlayer nextMusic;
    private static float musicFadeIn;
    private static float musicPlayTime;
    private static float musicFinalGain;
    private static float prevMusicGain;
    private float _x_screen_factor = 1.0f;
    private float _y_screen_factor = 1.0f;
    Frame _frame = new Frame();
    private boolean firstDraw = true;
    private static boolean fadeMusicIn;

    public static String getVersionString() {
        return "1.2.0";
    }

    public static boolean audio_enabled() {
        return _audio_enabled;
    }

    public static String getCurrentPage() {
        return _currPageName;
    }

    public static boolean isPageChanging() {
        return _changingScreen;
    }

    protected void PostSetup() {
        String string = "";
        string = args.containsKey("language") ? args.get("language") : "English";
        try {
            Language.Languages languages = Language.Languages.valueOf(string);
            PApplet.println("Loading language " + languages.toString());
            this._lang.loadLanguage(languages);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Could not load language " + string + ". Please check spelling and first letter should be capitalised.");
        }
        GameScreen.addPage("Intro", new IntroPage(this));
        GameScreen.addPage("PIOffice", new PIOfficePage(this));
        GameScreen.addPage("ControlRoom", new ControlRoomPage(this));
        GameScreen.addPage("GameSetup", new EnterNamePage(this));
        GameScreen.addPage("EnvironmentSubsystem", new EnvironmentSystemBase(this));
        GameScreen.addPage("VibrationIsolation", new VibrationIsolationbase(this));
        GameScreen.addPage("Optics", new OpticsBase(this));
        GameScreen.addPage("FinalScore", new FinalScore(this));
        GameScreen.addPage("Scores", new HighScoreScreen(this));
        GameScreen.addPage("Credits", new CreditsPage(this));
        this._lPage = new BSFLoadPage(this);
        _hud = new GameHud(this);
    }

    protected void PreDraw() {
    }

    public static void setChangeMusic(AudioPlayer audioPlayer, float f) {
        if (audioPlayer == null) {
            return;
        }
        if (currMusic != audioPlayer) {
            nextMusic = audioPlayer;
            musicFadeIn = f;
            fadeMusicIn = true;
            musicPlayTime = 0.0f;
            musicFinalGain = 0.0f;
        }
    }

    public static void setChangeMusic(AudioPlayer audioPlayer, float f, float f2) {
        if (audioPlayer == null) {
            return;
        }
        if (currMusic != audioPlayer) {
            nextMusic = audioPlayer;
            musicFadeIn = f;
            fadeMusicIn = true;
            musicPlayTime = 0.0f;
            musicFinalGain = f2;
        }
    }

    public int Width() {
        return this._scrW;
    }

    public int Height() {
        return this._scrH;
    }

    public static final GameScreen Current() {
        return _instance;
    }

    public static void showHUD() {
        _hud.setVisible(true);
        _hud.setOpacity(1.0f);
    }

    public static void hideHUD() {
        _hud.setVisible(false);
        _hud.setOpacity(0.0f);
    }

    public static boolean getHUDVisibility() {
        return _hud.isVisible();
    }

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            String[] stringArray2 = GameScreen.split(string, "=");
            if (stringArray2.length != 2) continue;
            args.put(stringArray2[0], stringArray2[1]);
        }
        if (args.containsKey("sound")) {
            _audio_enabled = Boolean.parseBoolean(args.get("sound"));
        }
        if (args.containsKey("present")) {
            PApplet.main(new String[]{"--present", "--hide-stop", GameScreen.class.getName()});
        } else {
            PApplet.main(new String[]{GameScreen.class.getName()});
        }
    }

    @Override
    public void keyPressed() {
        if (this.key == '\u001b' && dbox == null && !(_currPage instanceof BSFLoadPage)) {
            dbox = new YesNoDialog(_currPage, this, Language.getString("yes_no_text"), 300, 200, new OnExitDialogClicked());
            dbox.beginLoadResourceCycle(null, 1.0f);
            dbox.beginSetupCycle();
            _currPage.addChild(dbox);
            dbox.show();
        } else if (this.key == '\u001b' && dbox == null && _currPage instanceof BSFLoadPage) {
            this.exit();
        }
        if (this.key == '\u001b') {
            this.key = '\u0000';
        }
    }

    @Override
    public void init() {
        this._frame = new Frame();
        this._frame.setUndecorated(true);
        this._frame.removeNotify();
        super.init();
    }

    public static void reset() {
        PlayerData.setToDefaults();
        EnvironmentSystemVariables.reset();
        OpticsVariables.reset();
        SuspensionVariables.reset();
        for (GamePage gamePage : GameScreen._instance._pages.values()) {
            gamePage.reset();
        }
    }

    @Override
    public void setup() {
        this._frame.setLocation(0, 0);
        this.screen = Toolkit.getDefaultToolkit().getScreenSize();
        minim = new Minim((PApplet)this);
        this._lang = new Language("game_text.xml");
        this.size((int)(900.0f * this._x_screen_factor), (int)(600.0f * this._y_screen_factor), "processing.opengl.PGraphicsOpenGL");
        G4P.disableAutoDraw();
        this.hint(2);
        this.frameRate(40.0f);
        this._pages = new HashMap();
        this._rscMgr = new ResourceManager(this);
        _lock = new Object();
        _instance = this;
        _changingScreen = false;
        for (Frame frame : Frame.getFrames()) {
            frame.setTitle("Space Time Quest");
            ImageIcon imageIcon = new ImageIcon(this.loadBytes("rocketship.gif"));
            frame.setIconImage(imageIcon.getImage());
        }
        this._loadingThread = new Thread(new ResourceLoader());
        this.PostSetup();
        if (this._lPage == null) {
            throw new RuntimeException("Need to return a valid LoadingPage from PostSetup() to start.");
        }
        if (_hud == null) {
            throw new RuntimeException("Need to return a valid HUD Page from PostSetup() to start.");
        }
        _hud.setVisible(false);
        GameScreen.showPage(this._lPage);
    }

    public static boolean showPage(String string) {
        GamePage gamePage = GameScreen.getPage(string);
        if (gamePage == null) {
            throw new RuntimeException("GamePage of the name " + string + " does not exist.");
        }
        if (GameScreen.showPage(gamePage)) {
            _currPageName = string;
            return true;
        }
        return false;
    }

    protected static boolean showPage(GamePage gamePage) {
        if (!_changingScreen && _currPage != gamePage) {
            _changingScreen = true;
            if (gamePage == null) {
                throw new NullPointerException("Page reference cannot be null");
            }
            _nextPage = gamePage;
            if (_currPage != null) {
                _currPage.Hide(new PageHideCallback());
                _instance.unregisterMouseEvent(_currPage);
            } else {
                _nextPage.Show(new PageShowCallback());
            }
            return true;
        }
        return false;
    }

    public static void addPage(String string, GamePage gamePage) {
        if (gamePage == null) {
            throw new RuntimeException("GamePage reference cannot be null");
        }
        if (string == null) {
            throw new RuntimeException("GamePage name cannot be empty");
        }
        if ((string = string.trim()) == "") {
            throw new RuntimeException("GamePage name cannot be empty");
        }
        if (GameScreen._instance._pages.containsKey(string)) {
            throw new RuntimeException("A page of this name has already been added: " + string);
        }
        GameScreen._instance._pages.put(string, gamePage);
    }

    public static GamePage getPage(String string) {
        return GameScreen._instance._pages.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw() {
        musicPlayTime += 1.0f / this.frameRate;
        if (fadeMusicIn) {
            float f = musicPlayTime / musicFadeIn;
            if (musicPlayTime > musicFadeIn) {
                if (currMusic != null) {
                    currMusic.pause();
                }
                currMusic = nextMusic;
                nextMusic = null;
                fadeMusicIn = false;
                prevMusicGain = musicFinalGain - 12.0f;
            } else {
                if (currMusic != null) {
                    currMusic.setGain(prevMusicGain + -12.0f * f);
                    if (!currMusic.isPlaying()) {
                        currMusic.loop();
                    }
                }
                if (nextMusic != null) {
                    nextMusic.setGain(musicFinalGain + -12.0f * (1.0f - f));
                    if (!nextMusic.isPlaying()) {
                        nextMusic.loop();
                    }
                }
            }
        } else if (currMusic != null && !currMusic.isPlaying()) {
            currMusic.loop();
        }
        this.PreDraw();
        if (this.firstDraw) {
            G4P.draw();
            this.firstDraw = false;
        }
        Object object = _lock;
        synchronized (object) {
            this.background(0);
            if (_hud != null && _hud.isVisible()) {
                _hud.beginUpdateCycle(1.0f / this.frameRate);
            }
            if (_currPage != null) {
                _currPage.beginUpdateCycle(1.0f / this.frameRate);
            }
            if (_nextPage != null) {
                _nextPage.beginUpdateCycle(1.0f / this.frameRate);
            }
            GamePage.PostUpdate();
            if (_nextPage != null) {
                _nextPage.beginRenderCycle();
            }
            if (_currPage != null) {
                _currPage.beginRenderCycle();
            }
            if (_hud != null) {
                _hud.beginRenderCycle();
            }
        }
    }

    static {
        fadeMusicIn = false;
    }

    private static class PageShowCallback
    implements IAnimationCompleteCallback {
        private PageShowCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            Object object = _lock;
            synchronized (object) {
                if (_nextPage != null) {
                    _currPage = _nextPage;
                    _nextPage = null;
                }
                _instance.registerMouseEvent(_currPage);
                _changingScreen = false;
                if (_instance._lPage == _currPage) {
                    _instance._loadingThread.start();
                }
            }
        }
    }

    private static class PageHideCallback
    implements IAnimationCompleteCallback {
        private PageHideCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            Object object = _lock;
            synchronized (object) {
                if (_nextPage != null) {
                    _currPage = _nextPage;
                    _nextPage = null;
                }
                _currPage.Show(new PageShowCallback());
            }
        }
    }

    private class ResourceLoader
    implements Runnable {
        private ResourceLoader() {
        }

        @Override
        public void run() {
            float f = 1.0f / (float)(GameScreen.this._pages.size() + 2);
            for (GamePage gamePage : GameScreen.this._pages.values()) {
                gamePage.beginLoadResourceCycle(GameScreen.this._lPage, f);
                gamePage.beginSetupCycle();
            }
            _hud.beginLoadResourceCycle(GameScreen.this._lPage, f);
            _hud.beginSetupCycle();
            GComponent.globalFont = GFont.getFont(GameScreen.this, "Arial", 13);
            GameScreen.this._lPage.IncrementPercentageDone(f);
            GameScreen.this._rscMgr.setLoaded();
            GameScreen.this._lPage.FinishLoading();
        }
    }

    private class OnExitDialogClicked
    implements ButtonElement.IButtonCallback {
        private OnExitDialogClicked() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (dbox.isYesButton(buttonElement)) {
                GameScreen.this.exit();
            } else {
                dbox.hide();
                _currPage.removeChild(dbox);
                dbox = null;
            }
        }
    }
}

