/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GameScreen;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PConstants;

public abstract class GamePage
extends ScreenElement
implements PConstants {
    private KeyFrameAnimation animHide;
    private KeyFrameAnimation animShow;
    private _OnShow _showcallback = new _OnShow();
    private _OnHide _hidecallback = new _OnHide();
    private ScreenElement _prevChildMouse = null;
    private static boolean _mouseRelease = false;
    private static boolean _mouseClicked = false;
    private static boolean _mousePressed = false;
    private int _prevMouseX;
    private int _prevMouseY;
    private static boolean hitObject = false;
    private boolean _firstShow = true;
    private static boolean needCheckMouseInputs = false;

    public GamePage(PApplet pApplet) {
        super(null, pApplet);
        this._prevMouseY = pApplet.mouseY;
        this._prevMouseX = pApplet.mouseX;
        this.setBounds(this._app.width, this._app.height);
        this.setVisible(false);
    }

    public final void setShowAnimation(KeyFrameAnimation keyFrameAnimation) {
        this.animShow = keyFrameAnimation;
        this.animShow.addCallback(this._showcallback);
    }

    public final void setHideAnimation(KeyFrameAnimation keyFrameAnimation) {
        this.animHide = keyFrameAnimation;
        this.animHide.addCallback(this._hidecallback);
    }

    protected void PreShow() {
    }

    protected void PostShow() {
    }

    protected void PreHide() {
    }

    protected void PostHide() {
    }

    public boolean IsFirstShow() {
        return this._firstShow;
    }

    public final void Hide() {
        if (this.animHide == null) {
            throw new RuntimeException("Need to create a hide animation");
        }
        this.animHide.Start();
    }

    public final void Hide(IAnimationCompleteCallback iAnimationCompleteCallback) {
        this.SetHideCallback(iAnimationCompleteCallback);
        this.PreHide();
        this.Hide();
        this.beginOnPageHideCycle();
    }

    public final void Show() {
        this.setVisible(true);
        if (this.animHide == null) {
            throw new RuntimeException("Need to create a show animation");
        }
        this.animShow.Reset();
        this.animShow.Start();
    }

    public final void Show(IAnimationCompleteCallback iAnimationCompleteCallback) {
        this.SetShowCallback(iAnimationCompleteCallback);
        this.PreShow();
        this.Show();
        this.beginOnPageShowCycle();
    }

    public final void SetShowCallback(IAnimationCompleteCallback iAnimationCompleteCallback) {
        if (this.animShow == null) {
            throw new RuntimeException("Need to create a show animation");
        }
        this.animShow.addCallback(iAnimationCompleteCallback);
    }

    public final void SetHideCallback(IAnimationCompleteCallback iAnimationCompleteCallback) {
        if (this.animHide == null) {
            throw new RuntimeException("Need to create a hide animation");
        }
        this.animHide.addCallback(iAnimationCompleteCallback);
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        needCheckMouseInputs = true;
        switch (mouseEvent.getID()) {
            case 502: {
                _mouseRelease = true;
                break;
            }
            case 501: {
                _mousePressed = true;
                break;
            }
            case 500: {
                _mouseClicked = true;
                break;
            }
        }
    }

    @Override
    public void update(float f) {
        if (this.animHide != null) {
            this.animHide.Update(f);
        }
        if (this.animShow != null) {
            this.animShow.Update(f);
        }
        if (!GameScreen.isPageChanging()) {
            ScreenElement screenElement = null;
            boolean bl = this._prevMouseX != this._app.mouseX || this._prevMouseY != this._app.mouseY;
            for (int i = this._children.size() - 1; i >= 0; --i) {
                ScreenElement screenElement2 = (ScreenElement)this._children.get(i);
                if (hitObject || !needCheckMouseInputs || !screenElement2.isVisible() || (screenElement = screenElement2.HitTest(this._app.mouseX, this._app.mouseY)) == null) continue;
                hitObject = true;
                if (_mouseRelease) {
                    screenElement.onMouseEvent(502, this._app.mouseButton);
                }
                if (_mouseClicked) {
                    screenElement.onMouseEvent(500, this._app.mouseButton);
                }
                if (_mousePressed) {
                    screenElement.onMouseEvent(501, this._app.mouseButton);
                }
                if (this._prevChildMouse == screenElement) break;
                screenElement.onMouseEvent(504, this._app.mouseButton);
                this._app.cursor(12);
                break;
            }
            if (bl) {
                if (this._prevChildMouse != null && this._prevChildMouse != screenElement) {
                    this._prevChildMouse.onMouseEvent(505, this._app.mouseButton);
                    this._app.cursor(0);
                }
                this._prevChildMouse = screenElement;
            }
        }
        this._prevMouseY = this._app.mouseY;
        this._prevMouseX = this._app.mouseX;
    }

    public static void PostUpdate() {
        hitObject = false;
        if (needCheckMouseInputs) {
            _mouseClicked = false;
            _mouseRelease = false;
            _mousePressed = false;
            needCheckMouseInputs = false;
        }
    }

    public final void beginReset() {
        this._firstShow = false;
        this.reset();
    }

    public void reset() {
    }

    private class _OnShow
    implements IAnimationCompleteCallback {
        private _OnShow() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            GamePage.this.PostShow();
            GamePage.this._firstShow = false;
        }
    }

    private class _OnHide
    implements IAnimationCompleteCallback {
        private _OnHide() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            GamePage.this.setVisible(false);
            GamePage.this.PostHide();
        }
    }
}

