/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import java.util.ArrayList;
import org.gwoptics.ArgumentException;
import org.gwoptics.ValueType;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph3D.Axis3D;
import org.gwoptics.graphics.graph3D.IGraph3DCallback;
import org.gwoptics.graphics.graph3D.SurfaceTrace3D;
import processing.core.PApplet;
import processing.core.PVector;

public final class SurfaceGraph3D
extends Renderable {
    private Axis3D _ax;
    private Axis3D _az;
    private Axis3D _ay;
    private ArrayList<SurfaceTrace3D> _traces;
    private float _xLength;
    private float _zLength;
    private float _yLength;
    private int _autoRangeSurfaceIX;
    private boolean _setAxisCrossAtZero;

    public float getZAxisMax() {
        return this._az.getMaxValue();
    }

    public void setXAxisMin(float l) {
        this._ax.setMinValue(l);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setYAxisMin(float l) {
        this._ay.setMinValue(l);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setZAxisMin(float l) {
        this._az.setMinValue(l);
        this._alignAxesToZeroPoint();
    }

    public void setXAxisMax(float l) {
        this._ax.setMaxValue(l);
        this._alignAxesToZeroPoint();
    }

    public void setYAxisMax(float l) {
        this._ay.setMaxValue(l);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setZAxisMax(float l) {
        this._az.setMaxValue(l);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setXAxisLabel(String s) {
        this._ax.setAxisLabel(s);
    }

    public void setYAxisLabel(String s) {
        this._ay.setAxisLabel(s);
    }

    public void setZAxisLabel(String s) {
        this._az.setAxisLabel(s);
    }

    public void setXAxisLabelAccuracy(int l) {
        this._ax.setTickLabelAccuracy(l);
    }

    public void setYAxisLabelAccuracy(int l) {
        this._ay.setTickLabelAccuracy(l);
    }

    public void setZAxisLabelAccuracy(int l) {
        this._az.setTickLabelAccuracy(l);
    }

    public void setXAxisLabelType(ValueType l) {
        this._ax.setTickLabelType(l);
    }

    public void setYAxisLabelType(ValueType l) {
        this._ay.setTickLabelType(l);
    }

    public void setZAxisLabelType(ValueType l) {
        this._az.setTickLabelType(l);
    }

    public void setXAxisMajorTicks(int n) {
        this._ax.setMajorTicks(n);
    }

    public void setXAxisMinorTicks(int n) {
        this._ax.setMinorTicks(n);
    }

    public void setYAxisMajorTicks(int n) {
        this._ay.setMajorTicks(n);
    }

    public void setYAxisMinorTicks(int n) {
        this._ay.setMinorTicks(n);
    }

    public void setZAxisMajorTicks(int n) {
        this._az.setMajorTicks(n);
    }

    public void setZAxisMinorTicks(int n) {
        this._az.setMinorTicks(n);
    }

    public void setBillboarding(boolean value) {
        this._ax.setTickLabelBillboarding(value);
        this._ay.setTickLabelBillboarding(value);
        this._az.setTickLabelBillboarding(value);
    }

    public void setDrawLines(boolean value) {
        this._ax.setDrawLine(value);
        this._ay.setDrawLine(value);
        this._az.setDrawLine(value);
    }

    public void setDrawTickLabels(boolean value) {
        this._ax.setDrawTickLabels(value);
        this._ay.setDrawTickLabels(value);
        this._az.setDrawTickLabels(value);
    }

    public void setDrawTicks(boolean value) {
        this._ax.setDrawTicks(value);
        this._ay.setDrawTicks(value);
        this._az.setDrawTicks(value);
    }

    public void setDrawAxisLabel(boolean value) {
        this._ax.setDrawAxisLabel(value);
        this._ay.setDrawAxisLabel(value);
        this._az.setDrawAxisLabel(value);
    }

    public void setAxisColour(int R, int G, int B) {
        this.setAxisColour(new GWColour(R, G, B));
    }

    public void setAxisColour(GWColour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setAxisColour(c);
        this._ay.setAxisColour(c);
        this._az.setAxisColour(c);
    }

    public void setFontColour(int R, int G, int B) {
        this.setFontColour(new GWColour(R, G, B));
    }

    public void setFontColour(GWColour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setFontColour(c);
        this._ay.setFontColour(c);
        this._az.setFontColour(c);
    }

    public void setAutoRanging(int surfaceIndex) {
        if (surfaceIndex > this._traces.size() - 1) {
            throw new ArgumentException("This surface trace index does not exist in the traces available");
        }
        SurfaceTrace3D t = null;
        if (this._autoRangeSurfaceIX > -1 && (t = this._traces.get(this._autoRangeSurfaceIX)) != null) {
            t.setAutoRangeZAxis(false);
        }
        if (surfaceIndex < -1) {
            surfaceIndex = -1;
        }
        this._autoRangeSurfaceIX = surfaceIndex;
        if (surfaceIndex > -1 && (t = this._traces.get(surfaceIndex)) != null) {
            t.setAutoRangeZAxis(true);
        }
    }

    public SurfaceGraph3D(PApplet p, float xLength, float yLength, float zLength) {
        this(p, xLength, yLength, zLength, false);
    }

    public SurfaceGraph3D(PApplet p, float xLength, float yLength, float zLength, boolean setAxisCrossAtZero) {
        super(p);
        this._az = new Axis3D(this._parent);
        this._ax = new Axis3D(this._parent);
        this._ay = new Axis3D(this._parent);
        if (xLength < 1.0f) {
            this._xLength = 1.0f;
            this._ax.setDraw(false);
        } else {
            this._xLength = xLength;
        }
        if (zLength < 1.0f) {
            this._zLength = 1.0f;
            this._az.setDraw(false);
        } else {
            this._zLength = zLength;
        }
        if (yLength < 1.0f) {
            this._yLength = 1.0f;
            this._ay.setDraw(false);
        } else {
            this._yLength = yLength;
        }
        this._traces = new ArrayList();
        this._autoRangeSurfaceIX = -1;
        this._az.setAxesDirection(new PVector(0.0f, 1.0f, 0.0f));
        this._az.setAxisLabel("Z-Axis");
        this._az.position = new PVector(0.0f, 0.0f, 0.0f);
        this._az.setLength(this._zLength);
        this._az.setLabelDirection(new PVector(-1.0f, 0.0f, -1.0f));
        this._az.setTickLabelXRotation((float)Math.PI);
        this._az.setTickLabelYRotation(-2.3561945f);
        this._az.setLabelZRotation(1.5707964f);
        this._az.setLabelXRotation(2.6179938f);
        this._az.setTickLabelBillboarding(false);
        this._ax.setAxesDirection(new PVector(1.0f, 0.0f, 0.0f));
        this._ax.setAxisLabel("X-Axis");
        this._ax.setLabelXRotation(-1.5707964f);
        this._ax.setLabelOffset(10.0f);
        this._ax.setLength(this._xLength);
        this._ax.setTickLabelYRotation(1.5707964f);
        this._ax.setTickLabelZRotation(1.5707964f);
        this._ax.setLabelDirection(new PVector(0.0f, 0.0f, -1.0f));
        this._ax.position = new PVector(0.0f, 0.0f, 0.0f);
        this._ax.setTickLabelBillboarding(false);
        this._ay.setAxesDirection(new PVector(0.0f, 0.0f, 1.0f));
        this._ay.setAxisLabel("Y-Axis");
        this._ay.setLength(this._yLength);
        this._ay.setLabelOffset(10.0f);
        this._ay.setLabelXRotation((float)Math.PI);
        this._ay.setLabelYRotation(1.5707964f);
        this._ay.setLabelZRotation(1.5707964f);
        this._ay.setTickLabelYRotation(1.5707964f);
        this._ay.setTickLabelZRotation(1.5707964f);
        this._ay.setTickLabelXRotation(-1.5707964f);
        this._ay.setLabelDirection(new PVector(-1.0f, 0.0f, 0.0f));
        this._ay.position = new PVector(0.0f, 0.0f, 0.0f);
        this._ay.setTickLabelBillboarding(false);
        this._setAxisCrossAtZero = setAxisCrossAtZero;
    }

    private void _alignAxesToZeroPoint() {
        if (this._setAxisCrossAtZero && this._az.getMinValue() <= 0.0f && this._az.getMaxValue() >= 0.0f) {
            float pos = Math.abs(this._az.getLength() * Math.abs(this._az.getMinValue() / (this._az.getMaxValue() - this._az.getMinValue())));
            this._ax.position = new PVector(0.0f, pos, 0.0f);
            this._ay.position = new PVector(0.0f, pos, 0.0f);
        } else {
            this._ax.position = new PVector(0.0f, 0.0f, 0.0f);
            this._ay.position = new PVector(0.0f, 0.0f, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _alterSurfaceSpacing() {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            for (SurfaceTrace3D s : this._traces) {
                s.calculateSpacing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTraceCount() {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            return this._traces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSurfaceTrace(IGraph3DCallback cb, int XRes, int YRes, IColourmap map) {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            this._traces.add(new SurfaceTrace3D(this._parent, this._ax, this._ay, this._az, XRes, YRes, cb, String.valueOf(this._traces.size() + 1), map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSurfaceTrace(int index) {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            if (this._traces.size() <= index) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._traces.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plotSurfaceTrace(int index) {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            if (this._traces.size() <= index) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._traces.get(index).generateSurface();
        }
    }

    public void setTraceStroke(int index, GWColour c) {
        if (this._traces.size() <= index) {
            throw new ArrayIndexOutOfBoundsException();
        }
        SurfaceTrace3D t = this._traces.get(index);
        if (c == null) {
            t.setIsSurfacedStroked(false);
        } else {
            t.setIsSurfacedStroked(true);
            t.setSurfaceStroke(c);
        }
    }

    public void setTraceFill(int index, GWColour c) {
        if (this._traces.size() <= index) {
            throw new ArrayIndexOutOfBoundsException();
        }
        SurfaceTrace3D t = this._traces.get(index);
        if (c == null) {
            t.setIsSurfaceFilled(false);
        } else {
            t.setIsSurfaceFilled(true);
            t.setSurfaceFill(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void draw() {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            this._parent.pushMatrix();
            this._parent.translate(this.position.x, this.position.y, this.position.z);
            for (SurfaceTrace3D s : this._traces) {
                s.draw();
            }
            this._alignAxesToZeroPoint();
            this._ax.draw();
            this._ay.draw();
            this._az.draw();
            this._parent.popMatrix();
        }
    }
}

