/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D;

import java.util.ArrayList;
import org.gwoptics.ValueType;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.graph2D.LabelPos;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PVector;

public class Axis2D
extends Renderable
implements PConstants {
    private PVector _unitVec;
    protected PVector length;
    private int _length;
    private float _minShow;
    private float _maxShow;
    protected int _axisLineWidth;
    protected int _axisTickLineWidth;
    protected static PFont _font;
    protected String _label;
    protected PVector _labelDirection;
    protected float _majorTickSpacing;
    protected int _minorTicks;
    protected int _majorTickSize;
    protected int _minorTickSize;
    protected int _axisTickLblSize;
    protected int _axisTickLblOffset;
    protected int _axisLblSize;
    protected float _axisTickLblRotation = 0.0f;
    protected Alignment _axisTickLblAlign;
    protected float _axisLblRotation = 0.0f;
    protected float _axisLblOffset;
    protected LabelPos _axisLblPos;
    protected GWColour _axisColour = new GWColour(0, 0, 0);
    protected GWColour _fontColour = new GWColour(0, 0, 0);
    protected boolean _drawTicks = true;
    protected boolean _drawTickLabels = true;
    protected boolean _drawName = true;
    protected ValueType _tickLblType = ValueType.DECIMAL;
    protected int _accuracy = 1;
    private float _posConv;
    protected float _longestLabel = 0.0f;
    protected ArrayList<Integer> _majorTickPositions;
    protected ArrayList<Float> _majorTickLabels;
    protected ArrayList<Integer> _minorTickPositions;
    protected boolean _generateTicks;
    protected boolean _offsetByLabelWidth;
    protected boolean _isLogarithmic;
    protected float _logMax;
    protected float _logMin;
    protected static final int MIN_TICK_SPACING = 3;

    public void setAxisColour(int R, int G, int B) {
        this.setAxisColour(new GWColour(R, G, B));
    }

    public void setAxisColour(GWColour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._axisColour = c;
    }

    public void setFontColour(int R, int G, int B) {
        this.setFontColour(new GWColour(R, G, B));
    }

    public void setFontColour(GWColour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._fontColour = c;
    }

    public void setDrawTicks(boolean value) {
        this._drawTicks = value;
    }

    public void setDrawTickLabels(boolean value) {
        this._drawTickLabels = value;
    }

    public void setDrawAxisLabel(boolean value) {
        this._drawName = value;
    }

    public void setAxisLabel(String lbl) {
        this._label = lbl;
    }

    public void setAxisLabelPos(LabelPos lblpos) {
        this._axisLblPos = lblpos;
    }

    public void setLabelOffset(float val) {
        this._axisLblOffset = val;
    }

    public void setOffsetLabelByTickLength(boolean value) {
        this._offsetByLabelWidth = value;
    }

    public void setTickLabelOffset(int val) {
        this._axisTickLblOffset = val;
    }

    public void setTickLabelAlignment(Alignment a) {
        this._axisTickLblAlign = a;
    }

    public void setTickLabelRotation(float val) {
        this._axisTickLblRotation = val;
    }

    public void setLabelRotation(float val) {
        this._axisLblRotation = val;
    }

    public void setLabelDirection(PVector vlbl) {
        vlbl.normalize();
        this._labelDirection = vlbl;
    }

    public void setAxesDirection(PVector uv) {
        uv.normalize();
        this._unitVec = uv;
    }

    public void setTickSpacing(float spacing) {
        this._majorTickSpacing = spacing;
        this._generateTicks = true;
    }

    public void setMinorTicks(int t) {
        this._minorTicks = t;
        this._generateTicks = true;
    }

    public void setTickLabelType(ValueType v) {
        this._tickLblType = v;
    }

    public void setTickLabelAccuracy(int v) {
        this._accuracy = v;
    }

    public void setMajorTickLength(int val) {
        this._majorTickSize = val;
    }

    public void setMinorTickLength(int val) {
        this._minorTickSize = val;
    }

    public void setMaxValue(float val) {
        this._maxShow = val;
        if (this._isLogarithmic) {
            this._logMax = (float)Math.log10(this._maxShow);
            this._logMin = (float)Math.log10(this._minShow);
            this._posConv = (float)(this._length - 1) / (this._logMax - this._logMin);
        } else {
            this._posConv = (float)(this._length - 1) / (this._maxShow - this._minShow);
        }
        this._generateTicks = true;
    }

    public void setMinValue(float val) {
        this._minShow = val;
        if (this._isLogarithmic) {
            this._logMax = (float)Math.log10(this._maxShow);
            this._logMin = (float)Math.log10(this._minShow);
            this._posConv = (float)(this._length - 1) / (this._logMax - this._logMin);
        } else {
            this._posConv = (float)(this._length - 1) / (this._maxShow - this._minShow);
        }
        this._generateTicks = true;
    }

    public float getMajorTickSpacing() {
        return this._majorTickSpacing;
    }

    public float getMaxValue() {
        return this._maxShow;
    }

    public float getMinValue() {
        return this._minShow;
    }

    public int getLength() {
        return this._length;
    }

    public Integer[] getMajorTickPositions() {
        if (this._majorTickPositions != null) {
            Integer[] rtn = new Integer[this._majorTickPositions.size()];
            rtn = this._majorTickPositions.toArray(rtn);
            return rtn;
        }
        return null;
    }

    public Integer[] getMinorTickPositions() {
        if (this._minorTickPositions != null) {
            Integer[] rtn = new Integer[this._minorTickPositions.size()];
            rtn = this._minorTickPositions.toArray(rtn);
            return rtn;
        }
        return null;
    }

    public void setLogarithmicAxis(boolean value) {
        this._isLogarithmic = value;
        if (this._maxShow == 0.0f || this._minShow == 0.0f) {
            throw new RuntimeException("Axis limits cannot be 0");
        }
        this.setMaxValue(this._maxShow);
        this.setMinValue(this._minShow);
    }

    public Axis2D(PApplet parent, int length) {
        super(parent);
        this._unitVec = new PVector(1.0f, 0.0f);
        this._labelDirection = new PVector(0.0f, 1.0f);
        this._length = length;
        this._minShow = 0.0f;
        this._maxShow = 1.0f;
        this._majorTickSpacing = 0.5f;
        this._minorTicks = 2;
        this._majorTickSize = 6;
        this._minorTickSize = 3;
        this._axisTickLblSize = 12;
        this._axisLblSize = 12;
        this._axisLblOffset = 4.0f;
        this._axisLblPos = LabelPos.MIDDLE;
        this._axisLineWidth = 1;
        this._axisTickLineWidth = 1;
        this._axisTickLblAlign = Alignment.CENTER;
        this._axisTickLblOffset = 6;
        this._generateTicks = true;
        this._isLogarithmic = false;
        this._posConv = (float)this._length / (this._maxShow - this._minShow);
        this._offsetByLabelWidth = false;
        parent.registerPre((Object)this);
        if (_font == null) {
            _font = parent.createFont("Arial-BoldMT", 12.0f);
        }
    }

    public void pre() {
        if (this._generateTicks) {
            this._generateTicks();
            this._generateTicks = false;
        }
    }

    public void draw() {
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this.position.x, this.position.y);
        this.length = PVector.mult((PVector)this._unitVec, (float)this._length);
        this._drawAxisLine();
        if (this._drawTicks || this._drawTickLabels) {
            this._drawTicksAndLabels();
        }
        if (this._drawName) {
            this._drawAxisLabel();
        }
        this._parent.popStyle();
        this._parent.popMatrix();
    }

    public int valueToPosition(float value) {
        if (this._isLogarithmic) {
            return (int)Math.round((Math.log10(value) - (double)this._logMin) * (double)this._posConv);
        }
        return Math.round((value - this._minShow) * this._posConv);
    }

    public int valueToPosition(double value) {
        if (this._isLogarithmic) {
            return (int)Math.round((Math.log10(value) - (double)this._logMin) * (double)this._posConv);
        }
        return (int)Math.round((value - (double)this._minShow) * (double)this._posConv);
    }

    public float positionToValue(int pixel) {
        if (this._isLogarithmic) {
            return (float)Math.pow(10.0, this._logMin + (float)pixel / this._posConv);
        }
        return this._minShow + (float)pixel / this._posConv;
    }

    protected void _drawAxisLine() {
        this._parent.pushStyle();
        this._parent.stroke(this._axisColour.toInt());
        this._parent.strokeWeight((float)this._axisLineWidth);
        this._parent.beginShape(4);
        this._parent.vertex(0.0f, 0.0f);
        this._parent.vertex(this.length.x, this.length.y);
        this._parent.endShape();
        this._parent.popStyle();
    }

    protected void _generateTicks() {
        float max;
        float currMinorTickValue;
        float minorTickSpc;
        float currTickValue;
        float firstTickOffset;
        float spcDivMn;
        this._majorTickLabels = new ArrayList();
        this._majorTickPositions = new ArrayList();
        this._minorTickPositions = new ArrayList();
        if (this._isLogarithmic) {
            spcDivMn = (float)(Math.log10(this._minShow) / (double)this._majorTickSpacing);
            firstTickOffset = (float)(Math.ceil(spcDivMn) * (double)this._majorTickSpacing - Math.log10(this._minShow));
            currTickValue = (float)(Math.log10(this._minShow) + (double)firstTickOffset);
            minorTickSpc = this._majorTickSpacing / (float)(this._minorTicks + 1);
            currMinorTickValue = currTickValue;
            max = (float)Math.log10(this._maxShow);
        } else {
            spcDivMn = this._minShow / this._majorTickSpacing;
            firstTickOffset = (float)(Math.ceil(spcDivMn) * (double)this._majorTickSpacing - (double)this._minShow);
            currTickValue = this._minShow + firstTickOffset;
            minorTickSpc = this._majorTickSpacing / (float)(this._minorTicks + 1);
            currMinorTickValue = currTickValue;
            max = this._maxShow;
        }
        currMinorTickValue -= minorTickSpc;
        while (currMinorTickValue >= this._minShow) {
            if (this._isLogarithmic) {
                this._minorTickPositions.add(this.valueToPosition(Math.pow(10.0, currMinorTickValue)));
            } else {
                this._minorTickPositions.add(this.valueToPosition(currMinorTickValue));
            }
            currMinorTickValue -= minorTickSpc;
        }
        while (currTickValue <= max) {
            if (this._isLogarithmic) {
                this._majorTickPositions.add(this.valueToPosition(Math.pow(10.0, currTickValue)));
                this._majorTickLabels.add(Float.valueOf((float)Math.pow(10.0, currTickValue)));
            } else {
                this._majorTickPositions.add(this.valueToPosition(currTickValue));
                this._majorTickLabels.add(Float.valueOf(currTickValue));
            }
            currMinorTickValue = currTickValue + minorTickSpc;
            while (currMinorTickValue <= max && currMinorTickValue < currTickValue + this._majorTickSpacing) {
                if (this._isLogarithmic) {
                    this._minorTickPositions.add(this.valueToPosition(Math.pow(10.0, currMinorTickValue)));
                } else {
                    this._minorTickPositions.add(this.valueToPosition(currMinorTickValue));
                }
                currMinorTickValue += minorTickSpc;
            }
            currTickValue += this._majorTickSpacing;
        }
    }

    protected void _drawTicksAndLabels() {
        PVector tickLblPos = new PVector(0.0f, 0.0f);
        PVector tickPos = new PVector(0.0f, 0.0f);
        PVector tickEnd = new PVector(0.0f, 0.0f);
        PVector tickPosMinor = new PVector(0.0f, 0.0f);
        PVector tickEndMinor = new PVector(0.0f, 0.0f);
        String tickLbl = "";
        this._parent.pushStyle();
        this._parent.strokeWeight((float)this._axisTickLineWidth);
        this._parent.textFont(_font, (float)this._axisTickLblSize);
        this._parent.stroke(this._axisColour.toInt());
        this._parent.strokeWeight((float)this._axisLineWidth);
        if (this._axisTickLblAlign == null) {
            this._parent.textAlign(3);
        } else {
            this._parent.textAlign(this._axisTickLblAlign.getValue());
        }
        int i = 0;
        while (i < this._majorTickPositions.size()) {
            int pos = this._majorTickPositions.get(i);
            float val = this._majorTickLabels.get(i).floatValue();
            tickPos = PVector.mult((PVector)this._unitVec, (float)pos);
            tickEnd = PVector.add((PVector)tickPos, (PVector)PVector.mult((PVector)this._labelDirection, (float)(-this._majorTickSize)));
            if (this._drawTickLabels) {
                switch (this._tickLblType) {
                    case DECIMAL: {
                        tickLbl = String.format(" %." + this._accuracy + "f", Float.valueOf(val));
                        break;
                    }
                    case EXPONENT: {
                        tickLbl = String.format(" %." + this._accuracy + "E", Float.valueOf(val));
                        break;
                    }
                    case INTEGER: {
                        tickLbl = String.format(" %d", Math.round(val));
                    }
                }
                tickLblPos = PVector.add((PVector)tickPos, (PVector)PVector.mult((PVector)this._labelDirection, (float)(this._axisTickLblOffset + Math.abs(this._majorTickSize))));
                float lblSize = this._parent.textWidth(tickLbl);
                if (lblSize > this._longestLabel) {
                    this._longestLabel = lblSize + 5.0f;
                }
                this._parent.pushMatrix();
                this._parent.translate(tickLblPos.x, tickLblPos.y);
                this._parent.rotate(this._axisTickLblRotation);
                this._parent.fill(this._fontColour.toInt());
                this._parent.text(tickLbl, 0.0f, 0.4f * (float)this._axisTickLblSize, 0.0f);
                this._parent.popMatrix();
            }
            if (this._drawTicks) {
                this._parent.beginShape(4);
                this._parent.vertex(tickPos.x, tickPos.y);
                this._parent.vertex(tickEnd.x, tickEnd.y);
                this._parent.endShape();
            }
            ++i;
        }
        if (this._drawTicks) {
            for (Integer i2 : this._minorTickPositions) {
                tickPosMinor = PVector.mult((PVector)this._unitVec, (float)i2.intValue());
                tickEndMinor = PVector.add((PVector)tickPosMinor, (PVector)PVector.mult((PVector)this._labelDirection, (float)(-this._minorTickSize)));
                this._parent.beginShape(4);
                this._parent.vertex(tickPosMinor.x, tickPosMinor.y);
                this._parent.vertex(tickEndMinor.x, tickEndMinor.y);
                this._parent.endShape();
            }
        }
        this._parent.popStyle();
    }

    protected void _drawAxisLabel() {
        this._parent.fill(this._fontColour.toInt());
        this._parent.textAlign(3);
        this._parent.textFont(_font, (float)this._axisLblSize);
        PVector lblPos = new PVector(0.0f, 0.0f, 0.0f);
        switch (this._axisLblPos) {
            case MIDDLE: {
                lblPos = PVector.div((PVector)this.length, (float)2.0f);
                break;
            }
            case START: {
                lblPos = new PVector(0.0f, 0.0f, 0.0f);
                break;
            }
            case END: {
                lblPos = this.length;
                break;
            }
            case OUTSIDE: {
                lblPos = PVector.mult((PVector)this.length, (float)1.1f);
            }
        }
        if (this._offsetByLabelWidth) {
            lblPos.add(PVector.mult((PVector)this._labelDirection, (float)(this._longestLabel + this._axisLblOffset + (float)this._axisTickLblOffset + (float)Math.abs(this._majorTickSize))));
        } else {
            lblPos.add(PVector.mult((PVector)this._labelDirection, (float)((float)this._axisLblSize + this._axisLblOffset + (float)this._axisTickLblOffset + (float)Math.abs(this._majorTickSize))));
        }
        this._parent.pushMatrix();
        this._parent.translate(lblPos.x, lblPos.y);
        this._parent.rotate(this._axisLblRotation);
        this._parent.text(String.valueOf(this._label), 0.0f, 0.25f * (float)_font.getFont().getSize(), 0.0f);
        this._parent.popMatrix();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT(37),
        CENTER(3),
        RIGHT(39);

        private int value;

        private Alignment(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

