/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.colourmap;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.colourmap.IColourmapEquation;
import org.gwoptics.graphics.colourmap.MapNeedsGeneratingException;

public class EquationColourmap
implements IColourmap {
    private GWColour[] _cColourmapLookup;
    private int[] _iColourmapLookup;
    private boolean _needsGenerating;
    private IColourmapEquation _eq;
    private float _dLoc;
    private boolean _isCentreAtZero;

    public boolean isCentreAtZero() {
        return this._isCentreAtZero;
    }

    public void setCentreAtZero(boolean value) {
        this._isCentreAtZero = value;
    }

    public EquationColourmap(IColourmapEquation eq4) {
        if (eq4 == null) {
            throw new NullPointerException("Object requires a non null IColourmapEquation.");
        }
        this._cColourmapLookup = new GWColour[64];
        this._iColourmapLookup = new int[64];
        this._dLoc = 0.015873017f;
    }

    public EquationColourmap(int resolution, IColourmapEquation eq4) {
        if (eq4 == null) {
            throw new NullPointerException("Object requires a non null IColourmapEquation.");
        }
        if (resolution < 1) {
            resolution = 1;
        }
        this._eq = eq4;
        this._cColourmapLookup = new GWColour[resolution];
        this._iColourmapLookup = new int[resolution];
        this._dLoc = 1.0f / (float)(resolution - 1);
    }

    public boolean isGenerated() {
        return !this._needsGenerating;
    }

    public void generateColourmap() {
        int i = 0;
        while (i < this._cColourmapLookup.length) {
            GWColour val;
            this._cColourmapLookup[i] = val = this._eq.colourmapEquation(this._dLoc * (float)i);
            this._iColourmapLookup[i] = val.toInt();
            ++i;
        }
        this._needsGenerating = false;
    }

    public GWColour getColourAtLocation(float l) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float loc = l < 0.0f ? 0.0f : (l > 1.0f ? 1.0f : l);
        return this._cColourmapLookup[Math.round(loc / this._dLoc)];
    }

    public int getIntAtLocation(float l) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float loc = l < 0.0f ? 0.0f : (l > 1.0f ? 1.0f : l);
        return this._iColourmapLookup[Math.round(loc / this._dLoc)];
    }
}

