/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.mathutils;

public final class mathUtils {
    private static final double[] _logFactorials = new double[]{0.6931471805599453, 1.791759469228055, 3.1780538303479453, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.80182748008147, 15.104412573075518, 17.502307845873887, 19.98721449566189, 22.552163853123425, 25.191221182738683, 27.899271383840894, 30.671860106080675, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485};
    private static final long[][] _binomials = new long[][]{{1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 2L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 3L, 3L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 4L, 6L, 4L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 5L, 10L, 10L, 5L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 6L, 15L, 20L, 15L, 6L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 7L, 21L, 35L, 35L, 21L, 7L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 8L, 28L, 56L, 70L, 56L, 28L, 8L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 9L, 36L, 84L, 126L, 126L, 84L, 36L, 9L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 10L, 45L, 120L, 210L, 252L, 210L, 120L, 45L, 10L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 11L, 55L, 165L, 330L, 462L, 462L, 330L, 165L, 55L, 11L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 12L, 66L, 220L, 495L, 792L, 924L, 792L, 495L, 220L, 66L, 12L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 13L, 78L, 286L, 715L, 1287L, 1716L, 1716L, 1287L, 715L, 286L, 78L, 13L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 14L, 91L, 364L, 1001L, 2002L, 3003L, 3432L, 3003L, 2002L, 1001L, 364L, 91L, 14L, 1L, 0L, 0L, 0L, 0L, 0L, 0L}, {1L, 15L, 105L, 455L, 1365L, 3003L, 5005L, 6435L, 6435L, 5005L, 3003L, 1365L, 455L, 105L, 15L, 1L, 0L, 0L, 0L, 0L, 0L}, {1L, 16L, 120L, 560L, 1820L, 4368L, 8008L, 11440L, 12870L, 11440L, 8008L, 4368L, 1820L, 560L, 120L, 16L, 1L, 0L, 0L, 0L, 0L}, {1L, 17L, 136L, 680L, 2380L, 6188L, 12376L, 19448L, 24310L, 24310L, 19448L, 12376L, 6188L, 2380L, 680L, 136L, 17L, 1L, 0L, 0L, 0L}, {1L, 18L, 153L, 816L, 3060L, 8568L, 18564L, 31824L, 43758L, 48620L, 43758L, 31824L, 18564L, 8568L, 3060L, 816L, 153L, 18L, 1L, 0L, 0L}, {1L, 19L, 171L, 969L, 3876L, 11628L, 27132L, 50388L, 75582L, 92378L, 92378L, 75582L, 50388L, 27132L, 11628L, 3876L, 969L, 171L, 19L, 1L, 0L}, {1L, 20L, 190L, 1140L, 4845L, 15504L, 38760L, 77520L, 125970L, 167960L, 184756L, 167960L, 125970L, 77520L, 38760L, 15504L, 4845L, 1140L, 190L, 20L, 1L}};

    public static long factorial(long l) {
        long l2 = 1L;
        if (l < 0L) {
            throw new RuntimeException("Underflow error in factorial");
        }
        if (l > 20L) {
            throw new RuntimeException("Overflow error in factorial");
        }
        if (l == 0L) {
            return 1L;
        }
        int n = 1;
        while ((long)n <= l) {
            l2 *= (long)n;
            ++n;
        }
        return l2;
    }

    public static double logFactorial(int n) {
        if (n <= 1) {
            return 0.0;
        }
        if (n <= 20) {
            return _logFactorials[n - 2];
        }
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    static double logGamma(double d) {
        double d2 = (d - 0.5) * Math.log(d + 4.5) - (d + 4.5);
        double d3 = 1.0 + 76.18009173 / (d + 0.0) - 86.50532033 / (d + 1.0) + 24.01409822 / (d + 2.0) - 1.231739516 / (d + 3.0) + 0.00120858003 / (d + 4.0) - 5.36382E-6 / (d + 5.0);
        return d2 + Math.log(d3 * Math.sqrt(Math.PI * 2));
    }

    static double gamma(double d) {
        return Math.exp(mathUtils.logGamma(d));
    }

    public static long binomial(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return 0L;
        }
        if (n <= 20 || n2 <= 20) {
            return _binomials[n][n2];
        }
        if (n2 <= n && n2 >= 0) {
            return Math.round(Math.exp(mathUtils.logFactorial(n) - mathUtils.logFactorial(n2) - mathUtils.logFactorial(n - n2)));
        }
        return Math.round(mathUtils.gamma(n + 1) / (mathUtils.gamma(n2 + 1) / mathUtils.gamma(n - n2 + 1)));
    }

    public static Double hermite(int n, double d) {
        assert (n >= 0);
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 2.0 * d;
            }
            case 2: {
                return 4.0 * d * d - 2.0;
            }
            case 3: {
                return 8.0 * d * d * d - 12.0 * d;
            }
            case 4: {
                return 16.0 * Math.pow(d, 4.0) - 48.0 * d * d + 12.0;
            }
            case 5: {
                return 32.0 * Math.pow(d, 5.0) - 160.0 * d * d * d + 120.0 * d;
            }
            case 6: {
                return 64.0 * Math.pow(d, 6.0) - 480.0 * Math.pow(d, 4.0) + 720.0 * d * d - 120.0;
            }
            case 7: {
                return 128.0 * Math.pow(d, 7.0) - 1344.0 * Math.pow(d, 5.0) + 3360.0 * d * d * d - 1680.0 * d;
            }
            case 8: {
                return 256.0 * Math.pow(d, 8.0) - 3584.0 * Math.pow(d, 6.0) + 13440.0 * Math.pow(d, 4.0) - 13440.0 * d * d + 1680.0;
            }
            case 9: {
                return 512.0 * Math.pow(d, 9.0) - 9216.0 * Math.pow(d, 7.0) + 48384.0 * Math.pow(d, 5.0) - 80640.0 * d * d * d + 30240.0 * d;
            }
            case 10: {
                return 1024.0 * Math.pow(d, 10.0) - 23040.0 * Math.pow(d, 8.0) + 161280.0 * Math.pow(d, 6.0) - 403200.0 * Math.pow(d, 4.0) + 302400.0 * d * d - 30240.0;
            }
        }
        return 2.0 * d * mathUtils.hermite(n - 1, d) - (double)(2 * (n - 1)) * mathUtils.hermite(n - 2, d);
    }

    public static Double laguerre(int n, int n2, double d) {
        Double d2 = 0.0;
        for (int i = 0; i <= n; ++i) {
            d2 = d2 + (double)mathUtils.binomial(n2 + n, n - i) / (double)mathUtils.factorial(i) * Math.pow(-d, i);
        }
        return d2;
    }
}

