/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.mathutils;

public final class TrigLookup {
    private static final int _accuracy = 100;
    private static final double[] _sinTable = new double[9001];
    private static final double DegtoRadian = Math.PI / 180;
    private static final double RadianToDeg = 57.29577951308232;

    public static double cos(float f) {
        return TrigLookup.sin(f + 1.5707964f);
    }

    public static double sin(float f) {
        int n;
        float f2 = (float)((double)f * 57.29577951308232);
        if (f2 >= 360.0f) {
            f2 %= 360.0f;
        }
        if (f2 < 0.0f) {
            n = -1;
            f2 *= -1.0f;
        } else {
            n = 1;
        }
        int n2 = (int)(f2 * 100.0f);
        if (n2 < 18000) {
            if (n2 < 9001) {
                return (double)n * _sinTable[n2];
            }
            return (double)n * _sinTable[18000 - n2];
        }
        if (n2 < 27001) {
            return (double)(-n) * _sinTable[n2 - 18000];
        }
        return (double)(-n) * _sinTable[36000 - n2];
    }

    static {
        for (int i = 0; i < _sinTable.length; ++i) {
            TrigLookup._sinTable[i] = Math.sin(Math.PI / 180 * (double)i / 100.0);
        }
    }
}

