/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.mathutils;

public class Complex {
    private double _re;
    private double _im;

    Complex() {
        this._im = 0.0;
        this._re = 0.0;
    }

    public Complex(double d, double d2) {
        this._re = d;
        this._im = d2;
    }

    public Complex(double d) {
        this._re = d;
        this._im = 0.0;
    }

    public void set(double d, double d2) {
        this._re = d;
        this._im = d2;
    }

    public void setReal(double d) {
        this._re = d;
    }

    public void setImag(double d) {
        this._im = d;
    }

    public void setAbsPhi(double d, double d2) {
        Complex complex = Complex.scale(d, Complex.exp(new Complex(0.0, d2)));
        this._re = complex._re;
        this._im = complex._im;
    }

    public static Complex newAbsPhi(double d, double d2) {
        Complex complex = Complex.scale(d, Complex.exp(new Complex(0.0, d2)));
        return complex;
    }

    public void add(Complex complex) {
        this._re += complex._re;
        this._im += complex._im;
    }

    public static Complex add(Complex complex, Complex complex2) {
        Complex complex3 = new Complex(0.0);
        complex3._re = complex._re + complex2._re;
        complex3._im = complex._im + complex2._im;
        return complex3;
    }

    public void squared() {
        Complex complex = new Complex(0.0);
        complex._re = (this._re - this._im) * (this._re + this._im);
        complex._im = 2.0 * this._re * this._im;
        this._re = complex._re;
        this._im = complex._im;
    }

    public static Complex squared(Complex complex) {
        Complex complex2 = new Complex(0.0);
        complex2._re = (complex._re - complex._im) * (complex._re + complex._im);
        complex2._im = 2.0 * complex._re * complex._im;
        return complex2;
    }

    public double absSquared() {
        return this._re * this._re + this._im * this._im;
    }

    public static double absSquared(Complex complex) {
        return complex._re * complex._re + complex._im * complex._im;
    }

    public double abs() {
        return Math.sqrt(this._re * this._re + this._im * this._im);
    }

    public static double abs(Complex complex) {
        return Math.sqrt(complex._re * complex._re + complex._im * complex._im);
    }

    public double real() {
        return this._re;
    }

    public static double real(Complex complex) {
        return complex.real();
    }

    public double imag() {
        return this._im;
    }

    public static double imag(Complex complex) {
        return complex.imag();
    }

    public Complex sqrt() {
        double d;
        double d2;
        double d3;
        Complex complex = new Complex(0.0);
        Complex complex2 = new Complex(0.0);
        if (this._re == 0.0 && this._im == 0.0) {
            return complex;
        }
        double d4 = Math.abs(this._re);
        if (d4 >= (d3 = Math.abs(this._im))) {
            d2 = d3 / d4;
            d = Math.sqrt(d4) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d2 * d2)));
        } else {
            d2 = d4 / d3;
        }
        d = Math.sqrt(d3) * Math.sqrt(0.5 * (d2 + Math.sqrt(1.0 + d2 * d2)));
        if (this._re >= 0.0) {
            complex2.set(d, this._im / (2.0 * d));
        } else {
            double d5 = this._im >= 0.0 ? d : -d;
            complex2.set(this._im / (2.0 * d5), d5);
        }
        if (Complex.isNaN(complex2)) {
            throw new RuntimeException("division by zero");
        }
        return complex2;
    }

    public static Complex sqrt(Complex complex) {
        double d;
        double d2;
        Complex complex2 = new Complex(0.0);
        Complex complex3 = new Complex(0.0);
        if (complex.real() == 0.0 && complex.imag() == 0.0) {
            return complex2;
        }
        double d3 = Math.abs(complex.real());
        if (d3 >= (d2 = Math.abs(complex.imag()))) {
            double d4 = d2 / d3;
            d = Math.sqrt(d3) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d4 * d4)));
        } else {
            double d5 = d3 / d2;
            d = Math.sqrt(d2) * Math.sqrt(0.5 * (d5 + Math.sqrt(1.0 + d5 * d5)));
        }
        if (complex._re >= 0.0) {
            complex3.set(d, complex.imag() / (2.0 * d));
        } else {
            double d6 = complex.imag() >= 0.0 ? d : -d;
            complex3.set(complex.imag() / (2.0 * d6), d6);
        }
        if (Complex.isNaN(complex3)) {
            throw new RuntimeException("division by zero");
        }
        return complex3;
    }

    public void inv() {
        double d = 1.0 / Complex.absSquared(this);
        if (Double.isNaN(d)) {
            throw new RuntimeException("division by zero");
        }
        this._re *= d;
        this._im = -1.0 * this._im * d;
    }

    public static Complex inv(Complex complex) {
        Complex complex2 = new Complex(0.0);
        double d = 1.0 / Complex.absSquared(complex);
        if (Double.isNaN(d)) {
            throw new RuntimeException("division by zero");
        }
        complex2._re = complex._re * d;
        complex2._im = -1.0 * complex._im * d;
        return complex2;
    }

    public Double modulus() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.abs(this._re);
        double d4 = Math.abs(this._im);
        if (d3 == 0.0) {
            d = d4;
        } else if (d4 == 0.0) {
            d = d3;
        } else if (d3 > d4) {
            d2 = d4 / d3;
            d = d3 * Math.sqrt(1.0 + d2 * d2);
        } else {
            d2 = d3 / d4;
            d = d4 * Math.sqrt(1.0 + d2 * d2);
        }
        if (Double.isNaN(d)) {
            throw new RuntimeException("division by zero");
        }
        return d;
    }

    public static Double modulus(Complex complex) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.abs(complex.real());
        double d4 = Math.abs(complex.imag());
        if (d3 == 0.0) {
            d = d4;
        } else if (d4 == 0.0) {
            d = d3;
        } else if (d3 > d4) {
            d2 = d4 / d3;
            d = d3 * Math.sqrt(1.0 + d2 * d2);
        } else {
            d2 = d3 / d4;
            d = d4 * Math.sqrt(1.0 + d2 * d2);
        }
        if (Double.isNaN(d)) {
            throw new RuntimeException("division by zero");
        }
        return d;
    }

    public void multiply(Complex complex) {
        Complex complex2 = this;
        this._re = complex2._re * complex._re - complex2._im * complex._im;
        this._im = complex2._im * complex._re + complex2._re * complex._im;
    }

    public static Complex multiply(Complex complex, Complex complex2) {
        Complex complex3 = new Complex(0.0);
        complex3._re = complex._re * complex2._re - complex._im * complex2._im;
        complex3._im = complex._im * complex2._re + complex._re * complex2._im;
        return complex3;
    }

    public void divide(Complex complex) {
        Complex complex2 = this;
        if (Math.abs(complex.real()) >= Math.abs(complex.imag())) {
            double d = complex.imag() / complex.real();
            double d2 = complex.real() + d * complex.imag();
            this._re = (complex2.real() + d * complex2.imag()) / d2;
            this._im = (complex2.imag() - d * complex2.real()) / d2;
        } else {
            double d = complex.real() / complex.imag();
            double d3 = complex.imag() + d * complex.real();
            this._re = (d * complex2.real() + complex2.imag()) / d3;
            this._im = (d * complex2.imag() - complex2.real()) / d3;
        }
        if (Complex.isNaN(this)) {
            throw new RuntimeException("division by zero");
        }
    }

    public static Complex divide(Complex complex, Complex complex2) {
        Complex complex3 = new Complex(0.0);
        if (Math.abs(complex2.real()) >= Math.abs(complex2.imag())) {
            double d = complex2.imag() / complex2.real();
            double d2 = complex2.real() + d * complex2.imag();
            complex3.setReal((complex.real() + d * complex.imag()) / d2);
            complex3.setImag((complex.imag() - d * complex.real()) / d2);
        } else {
            double d = complex2.real() / complex2.imag();
            double d3 = complex2.imag() + d * complex2.real();
            complex3.setReal((d * complex.real() + complex.imag()) / d3);
            complex3.setImag((d * complex.imag() - complex.real()) / d3);
        }
        if (Complex.isNaN(complex3)) {
            throw new ArithmeticException("division by zero");
        }
        return complex3;
    }

    public void conj() {
        this._im = -1.0 * this._im;
    }

    public static Complex conj(Complex complex) {
        return new Complex(complex.real(), -1.0 * complex.imag());
    }

    public void scale(Double d) {
        this._re *= d.doubleValue();
        this._im *= d.doubleValue();
    }

    public static Complex scale(Double d, Complex complex) {
        return new Complex(complex.real() * d, complex.imag() * d);
    }

    public void scaleAndDelay(double d, double d2) {
        Complex complex = this;
        this._re = d * (complex._re * Math.cos(d2) - complex._im * Math.sin(d2));
        this._im = d * (complex._re * Math.sin(d2) + complex._im * Math.cos(d2));
    }

    public static Complex scaleAndDelay(double d, double d2, Complex complex) {
        Complex complex2 = new Complex(0.0);
        complex2._re = d * (complex._re * Math.cos(d2) - complex._im * Math.sin(d2));
        complex2._im = d * (complex._re * Math.sin(d2) + complex._im * Math.cos(d2));
        return complex2;
    }

    public static Complex pow(Complex complex, int n, int n2) {
        Complex complex2 = new Complex(0.0);
        Complex complex3 = new Complex(1.0);
        if (n2 == 0) {
            throw new ArithmeticException("denominator is zero");
        }
        if (n == 0) {
            return complex3;
        }
        Double d = (double)n / (double)n2;
        if (complex.isEqual(complex2)) {
            if (d > 0.0) {
                return complex2;
            }
            throw new ArithmeticException("division by zero (1)");
        }
        if (n == n2) {
            return complex;
        }
        Complex complex4 = Complex.log(complex);
        complex4._re *= d.doubleValue();
        complex4._im *= d.doubleValue();
        if (Complex.isNaN(complex4)) {
            throw new ArithmeticException("pow returns NaN");
        }
        return Complex.exp(complex4);
    }

    public static Complex log(Complex complex) {
        Complex complex2 = new Complex(0.0);
        double d = Math.sqrt(complex._re * complex._re + complex._im * complex._im);
        complex2._re = Math.log(d);
        complex2._im = Math.atan2(complex._im, complex._re);
        if (Complex.isNaN(complex2)) {
            throw new ArithmeticException("log returns NaN");
        }
        return complex2;
    }

    public static Complex exp(Complex complex) {
        Complex complex2 = new Complex(0.0);
        double d = Math.exp(complex._re);
        complex2._re = d * Math.cos(complex._im);
        complex2._im = d * Math.sin(complex._im);
        if (Complex.isNaN(complex2)) {
            throw new ArithmeticException("exp returns NaN");
        }
        return complex2;
    }

    public static Complex expi(Double d) {
        Complex complex = new Complex(Math.cos(d), Math.sin(d));
        if (Complex.isNaN(complex)) {
            throw new ArithmeticException("expi returns NaN");
        }
        return complex;
    }

    public boolean isNaN() {
        boolean bl = Double.isNaN(this._re);
        boolean bl2 = Double.isNaN(this._im);
        return bl | bl2;
    }

    public static boolean isNaN(Complex complex) {
        boolean bl = Double.isNaN(complex._re);
        boolean bl2 = Double.isNaN(complex._im);
        return bl | bl2;
    }

    public boolean isEqual(Complex complex) {
        boolean bl = false;
        if (this.isNaN() && complex.isNaN()) {
            bl = true;
        } else if (this._re == complex.real() && this._im == complex.imag()) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(Complex complex, Complex complex2) {
        boolean bl = false;
        if (complex.isNaN() && complex2.isNaN()) {
            bl = true;
        } else if (complex.real() == complex2.real() && complex.imag() == complex2.imag()) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        char c = '+';
        if (this._im < 0.0) {
            c = '-';
        }
        return this._re + " " + c + " " + Math.abs(this._im) + " i";
    }

    public static String toString(Complex complex) {
        char c = '+';
        if (complex.imag() < 0.0) {
            c = '-';
        }
        return complex.real() + " " + c + Math.abs(complex.imag()) + " i";
    }
}

