/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph3D.Axis3D;
import org.gwoptics.graphics.graph3D.IGraph3DCallback;
import org.gwoptics.graphics.graph3D.SquareGridMesh;
import processing.core.PApplet;

public class SurfaceTrace3D
extends Renderable {
    public String name;
    private SquareGridMesh _grid;
    private IColourmap _heightMap;
    private IGraph3DCallback _callback;
    private boolean _updateGrid;
    private float _dx;
    private float _dy;
    private Axis3D _ax;
    private Axis3D _az;
    private Axis3D _ay;
    private float[] _highestValue = new float[3];
    private float[] _lowestValue = new float[3];
    private boolean _autoRangeZaxis = false;

    public void setCallback(IGraph3DCallback iGraph3DCallback) {
        this._callback = iGraph3DCallback;
        this._updateGrid = true;
    }

    public void setIsSurfacedStroked(boolean bl) {
        this._grid.isStroked = bl;
    }

    public void setSurfaceStroke(GWColour gWColour) {
        this._grid.strokeColour = gWColour;
    }

    public void setIsSurfaceFilled(boolean bl) {
        this._grid.isFilled = bl;
    }

    public void setSurfaceFill(GWColour gWColour) {
        this._grid.fillColour = gWColour;
    }

    public void setAutoRangeZAxis(boolean bl) {
        this._autoRangeZaxis = bl;
    }

    public float getZValue(int n, int n2) {
        return this._grid.getZValue(n, n2);
    }

    public float[] getMaximumPoint() {
        return this._highestValue;
    }

    public float[] getLowestPoint() {
        return this._lowestValue;
    }

    public SurfaceTrace3D(PApplet pApplet, Axis3D axis3D, Axis3D axis3D2, Axis3D axis3D3, int n, int n2, IGraph3DCallback iGraph3DCallback, String string, IColourmap iColourmap) {
        super(pApplet);
        if (iGraph3DCallback == null) {
            throw new NullPointerException("A callback object must be specified for a trace.");
        }
        int n3 = n < 1 ? 1 : n;
        int n4 = n2 < 1 ? 1 : n2;
        this._ax = axis3D;
        this._ay = axis3D2;
        this._az = axis3D3;
        this.name = string;
        this._callback = iGraph3DCallback;
        this._heightMap = iColourmap;
        this._grid = new SquareGridMesh(n3, n4, axis3D.getLength() / (float)n3, axis3D2.getLength() / (float)n4, pApplet);
        if (iColourmap != null) {
            this._grid.isColoured = true;
            if (!iColourmap.isGenerated()) {
                iColourmap.generateColourmap();
            }
        }
        this.calculateSpacing();
        this._updateGrid = true;
    }

    public void calculateSpacing() {
        this._dx = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)this._grid.sizeX();
        this._dy = (this._ay.getMaxValue() - this._ay.getMinValue()) / (float)this._grid.sizeY();
    }

    public void generateSurface() {
        if (this._callback != null && this._updateGrid) {
            int n;
            int n2;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float[][] fArray = null;
            float f6 = 1.0f;
            this._highestValue = new float[3];
            this._lowestValue = new float[3];
            if (this._autoRangeZaxis) {
                fArray = new float[this._grid.sizeX() + 1][this._grid.sizeY() + 1];
            } else {
                f2 = this._az.getMaxValue();
                f3 = this._az.getMinValue();
                f4 = this._az.getLength() / (f2 - f3);
                f5 = 1.0f / (f2 - f3);
            }
            for (n2 = 0; n2 <= this._grid.sizeX(); ++n2) {
                for (n = 0; n <= this._grid.sizeY(); ++n) {
                    f = this._callback.computePoint(this._ax.getMinValue() + (float)n2 * this._dx, this._ay.getMinValue() + (float)n * this._dy);
                    if (f > this._highestValue[2]) {
                        this._highestValue[0] = (float)n2 * this._dx;
                        this._highestValue[1] = (float)n * this._dx;
                        this._highestValue[2] = f;
                    } else if (f < this._lowestValue[2]) {
                        this._lowestValue[0] = (float)n2 * this._dx;
                        this._lowestValue[1] = (float)n * this._dx;
                        this._lowestValue[2] = f;
                    }
                    if (this._autoRangeZaxis && fArray != null) {
                        fArray[n2][n] = f;
                        continue;
                    }
                    if (f < f3) {
                        f = f3;
                    }
                    if (f > f2) {
                        f = f2;
                    }
                    if (this._grid.isColoured) {
                        this._grid.setVertexColour(n2, n, this._heightMap.getColourAtLocation(Math.abs((f - f3) * f5)));
                    }
                    this._grid.setZValue(n2, n, (f - f3) * f4);
                }
            }
            if (this._autoRangeZaxis && fArray != null) {
                f2 = this._highestValue[2];
                f3 = this._lowestValue[2];
                f4 = this._az.getLength() / (f2 - f3);
                if (this._heightMap.isCentreAtZero()) {
                    f6 = Math.max(Math.abs(f2), Math.abs(f3));
                    f5 = 1.0f / (f6 * 2.0f);
                } else {
                    f6 = Math.abs(f2 - f3);
                    f5 = 1.0f / (f2 - f3);
                }
                this._az.setMaxValue(this._highestValue[2]);
                this._az.setMinValue(this._lowestValue[2]);
                for (n2 = 0; n2 <= this._grid.sizeX(); ++n2) {
                    for (n = 0; n <= this._grid.sizeY(); ++n) {
                        if (this._grid.isColoured) {
                            this._grid.setVertexColour(n2, n, this._heightMap.getColourAtLocation(1.0f - Math.abs(fArray[n2][n] - f6) * f5));
                        }
                        this._grid.setZValue(n2, n, (fArray[n2][n] - f3) * f4);
                    }
                }
            }
        }
    }

    @Override
    public void draw() {
        this._grid.draw();
    }
}

